import { registerBlockType } from '@wordpress/blocks';
import './style.scss';
import Edit from './edit';
import save from './save';
import metadata from './block.json';
import { __ } from '@wordpress/i18n';

const shortcodeIcon = {
    src: (
        <svg id="Layer_2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 29.7 25.38">
            <defs>
                <style>{`.cls-1{fill:var(--wp--preset--color--white);stroke-width:0px;}`}</style>
            </defs>
            <g id="Layer_1-2">
                <path class="cls-1" d="m8.96,1.42c.39,0,.71-.32.71-.71s-.32-.71-.71-.71H.71c-.39,0-.71.32-.71.71v23.96c0,.39.32.71.71.71h8.25c.39,0,.71-.32.71-.71s-.32-.71-.71-.71H1.42V1.42h7.55Z"/>
                <path class="cls-1" d="m28.99,0h-8.81c-.39,0-.71.32-.71.71s.32.71.71.71h8.1v22.55h-8.1c-.39,0-.71.32-.71.71s.32.71.71.71h8.81c.39,0,.71-.32.71-.71V.71c0-.39-.32-.71-.71-.71Z"/>
            </g>
        </svg>
    ),
    background: 'var(--wp--preset--color--primary)',
    foreground: 'var(--wp--preset--color--white)'
};

registerBlockType(metadata.name, {
    title: __('Artcloud Shortcode Block', 'artcloud-blocks'),
    description: __('Render php shortcode', 'artcloud-blocks'),
    icon: shortcodeIcon,
    edit: Edit,
    save: save,
});
