/* eslint-disable @wordpress/no-unsafe-wp-apis */
// import editor style
import './editor.scss';
import './style.scss';
import {
	PanelBody,
	__experimentalBorderControl as BorderControl,
} from '@wordpress/components';

import colors from '../colors';
import {
	InnerBlocks,
	useBlockProps,
	InspectorControls,
} from '@wordpress/block-editor';
import { __ } from '@wordpress/i18n';

import { Fragment } from '@wordpress/element';
const Edit = ({ attributes, setAttributes, clientId }) => {
	const { uniqueId, activePhaseBorder } = attributes;

	// set unique ID
	setAttributes({
		uniqueId: clientId,
	});
	return (
		<Fragment>
			<style>
				{`.artcloud_phase_${uniqueId} .artcloud__phase_active { border: ${activePhaseBorder.width} ${activePhaseBorder.style} ${activePhaseBorder.color} !important; }`}
				{`.artcloud_phase_${uniqueId} .artcloud__phase_body--show { border-top: ${activePhaseBorder.width} ${activePhaseBorder.style} ${activePhaseBorder.color} !important; }`}
			</style>
			<InspectorControls>
				<PanelBody
					initialOpen={false}
					title={__(
						'Active Phase Style',
						'artcloud-blocks'
					)}
				>
					<BorderControl
						colors={colors}
						label={__('Border', 'artcloud-blocks')}
						onChange={(value) =>
							setAttributes({ activePhaseBorder: value })
						}
						value={activePhaseBorder}
						withSlider={true}
					/>
				</PanelBody>
			</InspectorControls>
			<div
				{...useBlockProps({
					className: `artcloud_phase_${uniqueId}`,
				})}
			>
				<InnerBlocks
					allowedBlocks={['artcloud-blocks/artcloud-phase-item']}
					template={[['artcloud-blocks/artcloud-phase-item']]}
					
				/>
			</div>
		</Fragment>
	);
};
export default Edit;
