/* eslint-disable react/jsx-no-target-blank */
/* eslint-disable no-shadow */
/* eslint-disable @wordpress/no-unsafe-wp-apis */
const { Fragment } = wp.element;
import {
	InnerBlocks,
	InspectorControls,
	RichText,
	useBlockProps,
} from '@wordpress/block-editor';
import {
	ColorPalette,
	PanelBody,
	RangeControl,
	SelectControl,
	ToggleControl,
	__experimentalBoxControl as BoxControl,
	__experimentalBorderControl as BorderControl,
} from '@wordpress/components';
const { __ } = wp.i18n;

import colors from '../colors';
import icons from './icons';
import tags from '../tags';

// include editor styles
import './editor.scss';

const iconPositions = [
	{
		label: 'Left',
		value: 'artcloud_left_icon',
	},
	{
		label: 'Right',
		value: 'artcloud_right_icon',
	},
];

const Edit = ({ attributes, setAttributes }) => {
	const {
		makeActive,
		border,
		margins,
		paddings,
		borderRadius,
		heading,
		headingTag,
		headingColor,
		showIcon,
		iconClass,
		iconPosition,
		iconColor,
		iconBackground,
		headerBg,
		bodyBg,
	} = attributes;
	return (
		<Fragment>
			<div
				{...useBlockProps({
					className: `artcloud__phase_container ${
						makeActive ? 'artcloud__phase_active' : ''
					}`,
				})}
			>
				<div
					className={`artcloud__phase_head ${iconPosition}`}
					style={{
						color: headingColor ? headingColor : '#333333',
						backgroundColor: headerBg ? headerBg : 'transparent',
						padding: `${paddings.top} ${paddings.left} ${paddings.bottom} ${paddings.right}`,
					}}
				>
					<div className={`artcloud__phase_heading ${iconPosition}`}>
						<span className='artcloud__phase_number'></span>
						<RichText
							tagName={headingTag}
							value={heading}
							className="artcloud__phase_title"
							onChange={(heading) => setAttributes({ heading })}
							style={{
								margin: 0,
								color: headingColor ? headingColor : '#333333',
							}}
						/>
					</div>
					{showIcon && (
						<div
							className={`artcloud__phase_icon`}
							style={{
								color: iconColor ? iconColor : '#333333',
								backgroundColor: iconBackground
									? iconBackground
									: 'transparent',
							}}
						>
							<span
								className={`artcloud__icon dashicons dashicons-${iconClass}`}
							></span>
						</div>
					)}
				</div>
				<div
					className={`artcloud__phase_body ${
						makeActive ? 'artcloud__phase_body--show' : ''
					}`}
					role="region"
					style={{
						backgroundColor: bodyBg ? bodyBg : 'transparent',
						borderTop: `${border.width} ${border.style} ${border.color}`,
						padding: `${paddings.top} ${paddings.left} ${paddings.bottom} ${paddings.right}`,
					}}
				>
					<InnerBlocks
						allowedBlocks={true}
						template={[
							[
								'core/paragraph',
								{
									placeholder:
										'Write your content or add any block here...',
								},
							],
						]}
					/>
				</div>
			</div>
		</Fragment>
	);
};
export default Edit;
