/* eslint-disable react/jsx-no-target-blank */
/* eslint-disable no-lonely-if */
import { InnerBlocks, RichText, useBlockProps } from '@wordpress/block-editor';
const { Fragment } = wp.element;
const Save = ({ attributes }) => {
	const {
		uniqueId,
		makeActive,
		border,
		margins,
		paddings,
		borderRadius,
		heading,
		headingTag,
		headingColor,
		showIcon,
		iconClass,
		iconPosition,
		iconColor,
		iconBackground,
		headerBg,
		bodyBg,
		id,
		linkedPhase,
		link,
		tab,
		disablePhase,
	} = attributes;

	const activeClass = makeActive
		? `artcloud-blocks__phase_body--show active__phase_${uniqueId}`
		: '';

	// initial phase stage
	let currentIconClass;
	if (makeActive === false) {
		currentIconClass = iconClass;
	} else {
		if (iconClass === 'plus-alt2') {
			currentIconClass = 'minus';
		} else if (iconClass === 'arrow-down') {
			currentIconClass = 'arrow-up';
		} else if (iconClass === 'arrow-down-alt2') {
			currentIconClass = 'arrow-up-alt2';
		} else if (iconClass === 'plus-alt') {
			currentIconClass = 'dismiss';
		} else if (iconClass === 'insert') {
			currentIconClass = 'remove';
		}
	}

	return (
		<div
			{...useBlockProps.save({
				className: `artcloud-blocks__phase_container ${
					disablePhase ? 'artcloud-blocks__phase_disabled' : ''
				} ${
					makeActive ? `active__phase_container_${uniqueId}` : ''
				}`,
			})}
			style={{
				border: `${border.width} ${border.style} ${border.color}`,
				marginTop: `${margins.top}`,
				marginBottom: `${margins.bottom}`,
				borderRadius: `${borderRadius}px`,
			}}
			id={id !== '' ? id : ''}
		>
			{linkedPhase ? (
				<Fragment>
					<a
						href={link}
						target={tab ? '_blank' : '_self'}
						rel={tab ? 'noopener noreferrer' : 'noopener'}
						className="artcloud-blocks__phase_link"
					>
						<div
							className={`artcloud-blocks__phase_head ${iconPosition}`}
							data-active={makeActive}
							style={{
								color: headingColor ? headingColor : '#333333',
								backgroundColor: headerBg
									? headerBg
									: 'transparent',
								padding: `${paddings.top} ${paddings.left} ${paddings.bottom} ${paddings.right}`,
							}}
						>
							<div
								className={`artcloud-blocks__phase_heading ${iconPosition}`}
							>
								<RichText.Content
									className="artcloud-blocks__phase_title"
									tagName={headingTag}
									value={heading}
									style={{
										margin: 0,
										color: headingColor
											? headingColor
											: '#333333',
									}}
								/>
							</div>
							{showIcon && (
								<div
									className={`artcloud-blocks__phase_icon`}
									style={{
										color: iconColor
											? iconColor
											: '#333333',
										backgroundColor: iconBackground
											? iconBackground
											: 'transparent',
									}}
								>
									<span
										className={`artcloud-blocks__icon dashicons dashicons-${currentIconClass}`}
									></span>
								</div>
							)}
						</div>
					</a>
				</Fragment>
			) : (
				<Fragment>
					<div
						className={`artcloud-blocks__phase_head ${iconPosition}`}
						data-active={makeActive}
						style={{
							color: headingColor ? headingColor : '#333333',
							backgroundColor: headerBg
								? headerBg
								: 'transparent',
							padding: `${paddings.top} ${paddings.left} ${paddings.bottom} ${paddings.right}`,
						}}
					>
						<div
							className={`artcloud-blocks__phase_heading ${iconPosition}`}
						>
							<RichText.Content
								className="artcloud-blocks__phase_title"
								tagName={headingTag}
								value={heading}
								style={{
									margin: 0,
									color: headingColor
										? headingColor
										: '#333333',
								}}
							/>
						</div>
						{showIcon && (
							<div
								className={`artcloud-blocks__phase_icon`}
								style={{
									color: iconColor ? iconColor : '#333333',
									backgroundColor: iconBackground
										? iconBackground
										: 'transparent',
								}}
							>
								<span
									className={`artcloud-blocks__icon dashicons dashicons-${currentIconClass}`}
								></span>
							</div>
						)}
					</div>
					<div
						className={`artcloud-blocks__phase_body ${activeClass}`}
						role="region"
						style={{
							backgroundColor: bodyBg ? bodyBg : 'transparent',
							borderTop: `${border.width} ${border.style} ${border.color}`,
							padding: `${paddings.top} ${paddings.left} ${paddings.bottom} ${paddings.right}`,
						}}
					>
						<InnerBlocks.Content />
					</div>
				</Fragment>
			)}
		</div>
	);
};
export default Save;
