import { registerBlockType } from '@wordpress/blocks';
import './style.scss';

import metadata from './block.json';

/**
 * Internal dependencies
 */
import Edit from './edit';
import Save from './save';

// icon
import icon from './icon';

/**
 * Block Registration
 */

registerBlockType(metadata, {
	icon: {
		src: icon,
		foreground: 'var(--wp--preset--color--white)',
		background: 'var(--wp--preset--color--primary)',
	},
	edit: Edit,
	save: Save,
});
