import { __ } from '@wordpress/i18n';
import { RichText } from "@wordpress/block-editor";
import { SocialIcons } from './AddSVGS';

export default function NormalPeople({ attributes, sortedItems, setAttributes }) {
    const { peopleTitle, peopleDesc, displayFeaturedImage, displayName, displayTitle, displayPhone, categories, selectedValue, displayEmail, displayCity, displayProfileLink, displaySocialLink, displayHomeLink, displayRankNumber, selectedTitles } = attributes;

    const onChangePeopleTitle = (value) => {
        setAttributes({ peopleTitle: value });
    }
    const onChangePeopleDesc = (value) => {
        setAttributes({ peopleDesc: value });
    }
    return (
        <>
            {categories && categories.length > 0 ? (
                <>  <RichText tagName="h3" onChange={onChangePeopleTitle} value={peopleTitle}
                    className="people-block-title"
                    placeholder={__('Enter People Title', 'artcloud-blocks')}
                    allowedFormats={[]} />
                    <RichText tagName="p" value={peopleDesc} onChange={onChangePeopleDesc}
                        className="people-block-desc"
                        placeholder={__('Enter people description', 'artcloud-blocks')}
                        allowedFormats={[]} />
                    <div className="row artcloud-row">
                        {sortedItems &&
                            sortedItems.map((post) => {
                                const featuredImage =
                                    post._embedded &&
                                    post._embedded['wp:featuredmedia'] &&
                                    post._embedded['wp:featuredmedia'].length > 0 &&
                                    post._embedded['wp:featuredmedia'][0];
                                return (
                                    <div className={`col-${selectedValue || '12'} ${selectedValue === '4' || selectedValue === '3' ? 'vertical' : 'horizontal'}`} key={post.id}>
                                        <div className="artcloud-peoples-item">
                                            <div className="artcloud-peoples-image">
                                                {displayFeaturedImage
                                                    && featuredImage
                                                    && featuredImage.media_details
                                                    && featuredImage.media_details.sizes
                                                    && featuredImage.media_details.sizes.thumbnail && (
                                                        <img
                                                            src={
                                                                featuredImage.media_details.sizes
                                                                    .thumbnail.source_url
                                                            }
                                                            alt={featuredImage.alt_text}
                                                        />
                                                    )}
                                            </div>
                                            <div className="artcloud-peoples-content">
                                                <h5>
                                                    <a href={displayProfileLink && (post.link ? post.link : '#')}>
                                                        {displayName && post.title && post.title.rendered}
                                                    </a>
                                                </h5>
                                                <p>{displayTitle && post.person_meta_fields.people_title}</p>
                                                <p>{displayCity && post.person_meta_fields.people_city}</p>
                                                <p>{displayPhone && post.person_meta_fields.people_phone}</p>
                                                <p>{displayEmail && post.person_meta_fields.people_email}</p>
                                                <div className='social-link'>
                                                    {displayHomeLink && (
                                                        <a href={`https://${post.person_meta_fields.home}`}>
                                                            <svg xmlns="http://www.w3.org/2000/svg" xmlnsXlink="http://www.w3.org/1999/xlink" width="17.922" height="17.922" viewBox="0 0 17.922 17.922">
                                                                <defs>
                                                                    <clipPath id="clip-path">
                                                                        <rect id="Rectangle_649" data-name="Rectangle 649" width="10.319" height="10.43" fill="#fff" />
                                                                    </clipPath>
                                                                </defs>
                                                                <g id="Group_829" data-name="Group 829" transform="translate(-276 -548)">
                                                                    <path id="Subtraction_18" data-name="Subtraction 18" d="M16.933,0H.988A.989.989,0,0,0,0,.989V16.934a.989.989,0,0,0,.989.988H16.933a.989.989,0,0,0,.989-.989h0V.988A.989.989,0,0,0,16.933,0Zm0,0" transform="translate(276 548)" fill="var(--wp--preset--color--primary)" />
                                                                    <g id="Group_741" data-name="Group 741" transform="translate(280 552)">
                                                                        <g id="Group_740" data-name="Group 740" clip-path="url(#clip-path)">
                                                                            <path id="Path_85" data-name="Path 85" d="M10.2,5.028,5.467.13a.427.427,0,0,0-.615,0L2.952,2.1a.238.238,0,0,1-.409-.166V1.464a.427.427,0,0,0-.427-.427H1.528a.427.427,0,0,0-.427.427V3.841a.428.428,0,0,1-.12.3l-.86.89a.427.427,0,0,0,.307.724H.673A.427.427,0,0,1,1.1,6.18V10a.427.427,0,0,0,.427.427H8.791A.427.427,0,0,0,9.218,10V6.18a.427.427,0,0,1,.427-.427h.245a.427.427,0,0,0,.307-.724" transform="translate(0 0)" fill="#fff" />
                                                                        </g>
                                                                    </g>
                                                                </g>
                                                            </svg>
                                                        </a>
                                                    )}
                                                    {displaySocialLink && (
                                                        <div>
                                                            <a href={`https://${post.person_meta_fields.twitter}`}>
                                                                <svg xmlns={socialSVGS.twitter.xmlns} width={socialSVGS.twitter.width} height={socialSVGS.twitter.height} viewBox={socialSVGS.twitter.viewBox}>
                                                                    <path d={socialSVGS.twitter.path} fill={socialSVGS.twitter.fill} />
                                                                </svg>
                                                            </a>
                                                            <a href={`https://${post.person_meta_fields.facebook}`}>
                                                                <svg xmlns={socialSVGS.facebook.xmlns} width={socialSVGS.facebook.width} height={socialSVGS.facebook.height} viewBox={socialSVGS.facebook.viewBox}>
                                                                    <path d={socialSVGS.facebook.path} fill={socialSVGS.facebook.fill} />
                                                                </svg>
                                                            </a>
                                                            <a href={`https://${post.person_meta_fields.linkedin}`}>
                                                                <svg xmlns="http://www.w3.org/2000/svg" xmlnsXlink="http://www.w3.org/1999/xlink" width="17.922" height="17.922" viewBox="0 0 17.922 17.922">
                                                                    <defs>
                                                                        <clipPath id="clip-path">
                                                                            <rect id="Rectangle_871" data-name="Rectangle 871" width="1.433" height="9.358" fill="#fff" />
                                                                        </clipPath>
                                                                    </defs>
                                                                    <g id="Group_828" data-name="Group 828" transform="translate(-302 -548)">
                                                                        <path id="Subtraction_19" data-name="Subtraction 19" d="M16.933,0H.988A.989.989,0,0,0,0,.989V16.934a.989.989,0,0,0,.989.988H16.933a.989.989,0,0,0,.989-.989h0V.988A.989.989,0,0,0,16.933,0Zm0,0" transform="translate(302 548)" fill="var(--wp--preset--color--primary)" />
                                                                        <g id="Group_827" data-name="Group 827" transform="translate(310 552)">
                                                                            <g id="Group_826" data-name="Group 826" clip-path="url(#clip-path)">
                                                                                <path id="Path_285" data-name="Path 285" d="M1.687,36A.686.686,0,0,0,1,36.684v5.808a.686.686,0,0,0,1.372,0V36.684A.686.686,0,0,0,1.687,36" transform="translate(-0.94 -33.82)" fill="#fff" />
                                                                                <path id="Path_286" data-name="Path 286" d="M.053.948a.694.694,0,0,0,.063.119.717.717,0,0,0,.085.1.645.645,0,0,0,.1.085.719.719,0,0,0,.118.064.682.682,0,0,0,.129.039.666.666,0,0,0,.268,0A.69.69,0,0,0,.949,1.32a.719.719,0,0,0,.118-.064.62.62,0,0,0,.1-.085.69.69,0,0,0,.2-.485A.718.718,0,0,0,1.359.552.732.732,0,0,0,1.32.424.7.7,0,0,0,1.257.3.714.714,0,0,0,1.171.2a.654.654,0,0,0-.1-.085A.669.669,0,0,0,.949.053.692.692,0,0,0,.82.013.665.665,0,0,0,.686,0,.692.692,0,0,0,.2.2.714.714,0,0,0,.116.3.742.742,0,0,0,.053.424.732.732,0,0,0,.013.552a.682.682,0,0,0,0,.268A.716.716,0,0,0,.053.948" fill="#fff" />
                                                                            </g>
                                                                        </g>
                                                                    </g>
                                                                </svg>
                                                            </a>
                                                            <a href={`https://${post.person_meta_fields.instagram}`}>
                                                                <svg xmlns={socialSVGS.instagram.xmlns} width={socialSVGS.instagram.width} height={socialSVGS.instagram.height} viewBox={socialSVGS.instagram.viewBox}>
                                                                    <path d={socialSVGS.instagram.path} fill={socialSVGS.instagram.fill} />
                                                                </svg>
                                                            </a>
                                                        </div>)}
                                                    {displayRankNumber && (
                                                        <h6>{post.person_meta_fields.rank_number}</h6>
                                                    )}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                );
                            })}
                    </div>
                </>
            ) : (
                <p>{__('Select a category first', 'artcloud-blocks')}<hr/></p>
            )
            }
        </>
    )
}
