import { useBlockProps } from '@wordpress/block-editor';

const Save = ({ attributes }) => {
	const {
		alignment,
		size,
		fillColor,
		selectedSvg,
		textAlign,
		selectedSvgViewBox
	} = attributes;

	return (
		<div {...useBlockProps.save({ style: `text-align: ${textAlign}`, className: `align${alignment}` })}>
			<svg
				xmlns="http://www.w3.org/2000/svg"
				style={{
					width: `${size}px`,
					height: `${size}px`,
					fill: fillColor,
					stroke: fillColor,
				}}
				viewBox={selectedSvgViewBox}
				strokeWidth="1.5"
				stroke="currentColor"
				className="w-6 h-6"
			>
				<path
					strokeLinecap="round"
					strokeLinejoin="round"
					d={selectedSvg}
				/>
			</svg>
		</div>
	);
};

export default Save;
