import { registerBlockType } from '@wordpress/blocks';
import './style.scss';
import { __ } from '@wordpress/i18n';
import Edit from './edit';
import Save from './save';
import metadata from './block.json';

const iconBlock = {
    src: (
        <svg id="Layer_2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24.19 23.15">
            <defs>
                <style>{`.cls-1{fill:var(--wp--preset--color--white);stroke-width:0px;}`}</style>
            </defs>
            <g id="Layer_1-2">
                <path className="cls-1" d="m24.12,8.74c-.19-.58-.7-.97-1.3-1.01l-6.85-.46L13.46.93h0c-.22-.56-.76-.93-1.36-.93s-1.14.36-1.36.93l-2.55,6.37-6.8.43c-.6.04-1.11.44-1.3,1.01-.19.58,0,1.2.46,1.58l5.27,4.4-1.69,6.6c-.15.59.07,1.2.56,1.55.26.19.56.28.86.28.27,0,.54-.08.79-.23l5.81-3.65,5.76,3.65c.51.32,1.16.3,1.65-.05.49-.36.71-.96.56-1.55l-1.68-6.65,5.25-4.35c.47-.38.65-1.01.46-1.58Zm-6.62,4.84c-.43.36-.62.95-.48,1.49l1.62,6.66-5.76-3.65c-.24-.15-.51-.23-.79-.23s-.55.08-.79.23l-5.83,3.6,1.69-6.6c.14-.55-.05-1.13-.49-1.49L1.46,9.14l6.8-.43c.56-.04,1.06-.4,1.27-.92l2.56-6.37s.04.01.04.03l2.51,6.34c.21.52.71.89,1.27.92l6.83.52-5.25,4.35Z"/>
            </g>
        </svg>
    ),
    background: 'var(--wp--preset--color--primary)',
    foreground: 'var(--wp--preset--color--white)'
};

registerBlockType(metadata.name, {
    title: __('Artcloud Icon Block', 'artcloud-blocks'),
    description: __('Select any SVG icon to display.', 'artcloud-blocks'),
    icon: iconBlock,
    edit: Edit,
    save: Save,
});
