import { __ } from "@wordpress/i18n";
import {
	AlignmentControl,
	BlockControls,
	useBlockProps,
	InspectorControls,
	PanelColorSettings,
} from "@wordpress/block-editor";
import { PanelBody, RangeControl, SelectControl } from "@wordpress/components";
import { useState, useEffect } from "@wordpress/element";
import { useSelect } from '@wordpress/data';
import svgOptionsV from './svgOptionsV.js';
import svgOptionsA from './svgOptionsA.js';

const Edit = ({ attributes, setAttributes }) => {
	const {
		alignment,
		size,
		fillColor,
		backgroundColor,
		textAlign,
		svgOptions,
		selectedSvg,
		selectedSvgV,
		selectedSvgA,
		selectedSvgViewBox,
	} = attributes;
	const activeThemeName = useSelect((select) => {
		return select('core').getCurrentTheme();
	}, []);

	setAttributes({ svgOptions: activeThemeName && activeThemeName.name.rendered === 'Vihreat' ? svgOptionsV : svgOptionsA });

	// const [selectedSvg, setSelectedSvg] = useState(initialSelectedSvg);

	const onChangeBackgroundColor = (newBgColor) => {
		setAttributes({ backgroundColor: newBgColor });
	};

	const onChangeFillColor = (newFillColor) => {
		setAttributes({ fillColor: newFillColor });
	};

	const onChangeSvg = (newSvg) => {
		// setSelectedSvg(newSvg);
		setAttributes({ selectedSvg: newSvg });
	};

	const onChangeSize = (newSize) => {
		setAttributes({
			size: newSize,
			width: newSize,
			height: newSize,
		});
	};

	if (!size) {
		setAttributes({ size: 100 });
	}

	const defaultSvg = activeThemeName && activeThemeName.name.rendered === 'Vihreat' ? selectedSvgV : selectedSvgA;

	const selectedSvgOption = svgOptions && svgOptions.find((option) => option.value === selectedSvg);

	setAttributes({ selectedSvgViewBox: selectedSvgOption && selectedSvgOption.viewBox });

	useEffect(() => {
		if (!selectedSvg) {
			setAttributes({ selectedSvg: defaultSvg });
		}
	}, [defaultSvg]);

	return (
		<div {...useBlockProps({ className: `align${alignment} has-text-align-${textAlign} alert-icon-svg` })}>
		<BlockControls group="block">
				<AlignmentControl
					value={textAlign}
					onChange={(nextAlign) => {
						setAttributes({ textAlign: nextAlign });
					}}
				/>
			</BlockControls>
			<InspectorControls>
				<PanelColorSettings
					title={__("Color Settings", "artcloud-blocks")}
					icon="admin-appearance"
					initialOpen
					colorSettings={[
						{
							label: __("Background Color", "artcloud-blocks"),
							value: backgroundColor,
							onChange: onChangeBackgroundColor,
						},
						{
							label: __("Fill Color", "artcloud-blocks"),
							value: fillColor,
							onChange: onChangeFillColor,
						},
					]}
				></PanelColorSettings>
				<PanelBody title={__("SVG Options")} initialOpen={true}>
					<SelectControl
						label={__("Select SVG", "artcloud-blocks")}
						value={selectedSvg}
						options={svgOptions.map((option) => ({
							label: option.label,
							value: option.value,
						}))}
						onChange={onChangeSvg}
					/>
					<RangeControl
						label={__("Size")}
						value={size}
						onChange={onChangeSize}
						min={1}
						max={500}
					/>
				</PanelBody>
			</InspectorControls>
			<svg
				xmlns="http://www.w3.org/2000/svg"
				style={{
					width: `${size}px`,
					height: `${size}px`,
					fill: fillColor,
					stroke: fillColor,
				}}
				viewBox={selectedSvgViewBox}
				strokeWidth="1.5"
				stroke="currentColor"
				className="w-6 h-6"
			>
				<path
					strokeLinecap="round"
					strokeLinejoin="round"
					d={selectedSvg}
				/>
			</svg>
		</div>
	);
};
// export { svgOptions };
export default Edit;
