<?php

function artcloud_highlight_blocks_render($attributes, $content)
{
	$selected_post_ids = [];

	// Retrieve the post IDs for the selected titles.
	if (isset($attributes['selectedTitles']) && !empty($attributes['selectedTitles'])) {
		foreach ($attributes['selectedTitles'] as $titleObj) {
			$post_id = $titleObj['id'];
			if ($post_id) {
				$selected_post_ids[] = $post_id;
			} else {
				$post = get_page_by_title($titleObj['title'], OBJECT, $attributes['postType']);
				if ($post) {
					$selected_post_ids[] = $post->ID;
				}
			}
		}
	}
	// Set up the query to get recent products.
	$args = array(
		'post_type' => $attributes['postType'],
		'posts_per_page' => $attributes['numberOfItems'],
		'post_status' => 'publish',
		'post__in' => $selected_post_ids,
		'order' => $attributes['order'],
		'orderby' => 'post__in',
	);
	if (!empty($selected_post_ids)) {
		$args['post__in'] = $selected_post_ids;
	} elseif (!empty($attributes['categories'])) {
		$category_slugs = array();
		foreach ($attributes['categories'] as $category) {
			$category_slugs[] = $category['slug'] ? $category['slug'] : $category['value'];
		}
		$args['category_name'] = implode(',', $category_slugs);
		$args['orderby'] = $attributes['orderBy'];
	} else {
		$args['orderby'] = $attributes['orderBy'];
	}
	// The WP query
	$query = new WP_Query($args);
	$recent_items = $query->get_posts();
	$output = '<div ' . get_block_wrapper_attributes() . '>';
	if (!empty($recent_items)) {
		foreach ($recent_items as $post) {
			$post_id = $post->ID;
			$post_readmore = get_permalink($post_id);
			$post_image_url = '';
			if ($attributes["displayFeaturedImage"] && has_post_thumbnail($post_id)) {
				$post_image_url = get_the_post_thumbnail_url($post_id, 'full');
			}

			$defaultImage = site_url() . '/wp-content/plugins/artcloud-blocks/assets/img/default-image.jpg';
			$medium_image_url = get_post_image_url($post_id, $attributes);
			$post_image_url = $medium_image_url ? $medium_image_url[0] : $defaultImage;
			$allowed_extensions = array('jpg', 'jpeg', 'png', 'gif');
			if (empty($post_image_url) || !in_array(strtolower(pathinfo($post_image_url, PATHINFO_EXTENSION)), $allowed_extensions)) {
				$post_image_url = $defaultImage;
			}
			$post_description = '';
			if ($attributes["displayDescription"]) {
				$post_description = wp_trim_words(get_the_excerpt($post_id), 26);
			}
			$backgroundColor = isset($attributes["backgroundColor"]) ? $attributes["backgroundColor"] : "";
			$textColor = isset($attributes["textColor"]) ? $attributes["textColor"] : "";
			$btnBackgroundColor = isset($attributes["btnBackgroundColor"]) ? $attributes["btnBackgroundColor"] : "";
			$btnTextColor = isset($attributes["btnTextColor"]) ? $attributes["btnTextColor"] : "";
			$selectedStyle = isset($attributes["selectedStyle"]) ? $attributes["selectedStyle"] : "style1";
			// Output the post information.
			$output .= '<div class="image-cards ' . ($selectedStyle === 'style1' ? '' : 'row-reverse') . '">';
			$output .= '<div class="col-7 post-image">';
			$output .= '<img src="' . esc_url($post_image_url) . '" alt="' . esc_attr($post->post_title) . '">';
			$output .= '</div>';
			$output .= '<div class="col-5 post-content" style="background-color:' . $backgroundColor . '" >';
			$output .= '<div className="highlightSVG">' . $content . '</div>';
			$output .= '<a href="' . esc_url($post_readmore) . '"><h2 style="color:' . $textColor . '">' . $post->post_title . '</h2></a>';
			if ($attributes["displayDescription"]) {
				$output .= '<p>' . wp_kses_post($post_description) . '</p>';
			}
			$output .= '<a style="background-color:' . $btnBackgroundColor . ' ;color:' . $btnTextColor . '" href="' . esc_url($post_readmore) . '" class="item-btns wp-block-post-excerpt__more-link">' . __('Lue artikkeli', 'artcloud-blocks') . '</a>';
			$output .= '</div>';
			$output .= '</div>';
		}
	} else {
		$output .= '<p>No item Selected</p>';
	}
	$output .= '</div>';
	return $output;
}
