import { InnerBlocks,useBlockProps } from '@wordpress/block-editor';

const Save = ({ attributes }) => {
  const { selectedSvg } = attributes;
 return (
    <div {...useBlockProps.save({
      className: `card-text-align`,
    })}>
      <InnerBlocks.Content />
      <style>
        {`
        .artcloud_hero_column_content .wp-block-image img {
            mask-image: url("data:image/svg+xml,${encodeURIComponent(selectedSvg)}") !important;
            mask-position: center;
            mask-repeat: no-repeat;
            mask-size: 100% auto;
            max-width: 100%;
            height: 494px;
            object-fit: cover;
            text-align: center;
            margin: 0 auto;
            width: 29.7rem !important;
          }
        `}
      </style>
    </div>
  );
};

export default Save;
