import { __ } from '@wordpress/i18n';
import { InnerBlocks, useBlockProps, InspectorControls } from '@wordpress/block-editor';
import { PanelBody, SelectControl } from '@wordpress/components';
import { useEffect, useState } from '@wordpress/element';
import { useSelect } from '@wordpress/data';
import svgOptionsV from './svgOptionsV.js';
import svgOptionsA from './svgOptionsA.js';
const ALLOWED_BLOCKS = [
    'core/column',
    'core/cover',
    'core/columns',
    'core/image',
    'core/button',
    'core/heading',
    'core/paragraph',
    'core/group'
];

const blockColumns = [
    [
        'core/cover', { className: 'artcloud_hero_cover', overlayColor: 'yellow-green' },
        [[
            'core/columns',
            { className: 'artcloud_hero_column_main' },
            [
                [
                    'core/column',
                    { className: 'artcloud_hero_column_content', verticalAlignment: 'center' },
                    [
                        [
                            'core/heading',
                            { level: 2, className: 'artcloud_hero_heading', content: 'Tässä on lyhyt sisäänheitto otsikko!' },
                        ],
                        [
                            'core/paragraph',
                            { className: 'artcloud_hero_description', content: 'Tähän alle sitten pienempi otsikko ja sivuston kuvaus.' },
                        ],

                        [
                            'core/columns',
                            { className: 'artcloud_hero_columns_child' },
                            [
                                [
                                    'core/column',
                                    { className: 'artcloud_hero_column_child', verticalAlignment: 'center' },
                                    [
                                        [
                                            'core/buttons',
                                            {
                                                className: 'artcloud_hero_button',
                                                text: __('Show', 'artcloud-blocks'),
                                                url: '#',
                                            },
                                            [
                                                [
                                                    'core/button',
                                                    {
                                                        className: 'artcloud_hero_button',
                                                        text: __('Show', 'artcloud-blocks'),
                                                        url: '#',
                                                    },
                                                ],
                                                [
                                                    'core/button',
                                                    {
                                                        className: 'artcloud_hero_button',
                                                        text: __('Signup', 'artcloud-blocks'),
                                                        url: '#',
                                                    },
                                                ],
                                            ]
                                        ]
                                    ],
                                ],
                            ],
                        ],
                    ],
                ],
                [
                    'core/column',
                    { className: 'artcloud_hero_column_content' },
                    [
                        [
                            'core/image',
                            {
                                className: 'artcloud_hero_image',
                                content: ''
                            },
                        ],
                    ],
                ],
            ],
        ],
        ],
    ],
];

const Edit = ({ attributes, setAttributes }) => {
	const { svgOptions, selectedSvg, selectedSvgV, selectedSvgA } = attributes;

    const activeThemeName = useSelect((select) => {
        return select('core').getCurrentTheme();
    }, []);

	setAttributes({ svgOptions: activeThemeName && activeThemeName.name.rendered === 'Vihreat' ? svgOptionsV : svgOptionsA });

    const defaultSvg = activeThemeName && activeThemeName.name.rendered === 'Vihreat' ? selectedSvgV : selectedSvgA;

    useEffect(() => {
		if (!selectedSvg) {
        setAttributes({ selectedSvg: defaultSvg });
		}
    }, [defaultSvg]);

    const handleSelectChange = (newSvg) => {
        setAttributes({ selectedSvg: newSvg });
    };

    const getMaskImageUrl = (selectedOption) => {
        const selectedSvgOption = svgOptions.find((option) => option.value === selectedOption);
        return selectedSvgOption ? `url("data:image/svg+xml,${encodeURIComponent(selectedSvgOption.value)}")` : '';
    };

    return (
        <div {...useBlockProps()}>
            <InspectorControls>
                <PanelBody title={__("Background settings", "artcloud-blocks")} initialOpen={true}>
                    <SelectControl
                        label={__("Available options", "artcloud-blocks")}
                        value={selectedSvg}
                        options={svgOptions.map((option) => ({ label: option.label, value: option.value }))}
                        onChange={handleSelectChange}
                    />
                </PanelBody>
            </InspectorControls>
            <style>
                {`.artcloud_hero_column_content .wp-block-image img {
                    mask-image: ${getMaskImageUrl(selectedSvg)} !important;
                    mask-position: center;
                    mask-repeat: no-repeat;
                    mask-size: 100% auto;
                    max-width: 100%;
                    height: 494px;
                    object-fit: cover;
                    text-align: center;
                    margin: 0 auto;
                    width: 29.7rem !important;
                }`}
            </style>
            <InnerBlocks
                template={blockColumns}
                allowedBlocks={ALLOWED_BLOCKS}
            />
        </div>
    );
};

export default Edit;
