import { InnerBlocks, useBlockProps } from '@wordpress/block-editor';

const Save = ({ attributes }) => {
	const { titlePosition, selectedSvg, svgColor, svgSize, svgHeight } = attributes;
	return (
		<div {...useBlockProps.save({
			className: `feedback-text-align`,
		})}>
			<style>
				{` .wp-block-column.artcloud_fb_column {
					mask-image: url("data:image/svg+xml,${encodeURIComponent(selectedSvg)}") !important;
					mask-position: center;
					background-color: ${svgColor};
					mask-repeat: no-repeat;
					mask-size: ${svgSize}rem;
					height:${svgSize + 5 > svgHeight ? svgSize + 5 : svgHeight}rem;
					max-width: ${svgSize}rem;
                }`}
			</style>
			<style>
				{` .artcloud_fb_heading{
					top: ${titlePosition}rem;
				}`
				}
			</style>
			<style>
				{` .artcloud_fb_description{
					top: ${titlePosition + 1}rem;
				}
				`}
			</style>
			<InnerBlocks.Content />
		</div>
	);
};

export default Save;
