function getProductsByCategory(categories) {
    // Assuming wc_get_products is a custom function to retrieve products.
    // Make sure it is properly defined and accessible.
  
    // Get all of the products from the database.
    const products = wc_get_products({
      'post_type': 'product',
      'post_status': 'publish',
    });
  
    // Filter the products by category.
    const filteredProducts = [];
    for (const product of products) {
      for (const category of categories) {
        if (product.categories.includes(category)) {
          filteredProducts.push(product);
          break; // No need to continue checking other categories for this product.
        }
      }
    }
  
    // Return the filtered products.
    return filteredProducts;
  }
  