import { registerBlockType } from '@wordpress/blocks';
import './style.scss';
import { __ } from '@wordpress/i18n';
import Edit from './edit';
import save from './save';
import metadata from './block.json';

const blogikirjoittajatIcon = {
    src: (
        <svg id="Layer_2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20.82 25.25">
            <defs>
                <style>{`.cls-1{fill:var(--wp--preset--color--white);stroke-width:0px;}`}</style>
            </defs>
            <g id="Layer_1-2">
                <path class="cls-1" d="m20.8,19.43c-.77-3.64-5.5-5-7.34-5.4v-.88c1.26-.79,2.11-2.17,2.16-3.75.79-.32,1.35-1.1,1.35-2s-.56-1.68-1.35-2v-.8c0-2.54-2.07-4.61-4.61-4.61h-1.2c-2.54,0-4.61,2.07-4.61,4.61v.62c-.84.3-1.44,1.1-1.44,2.04s.6,1.74,1.44,2.04c.01,1.63.87,3.05,2.16,3.86v.88c-1.85.4-6.57,1.76-7.34,5.4-.01.06-.02.12-.02.18v4.78c0,.47.38.85.85.85h19.11c.47,0,.85-.38.85-.85v-4.78c0-.06,0-.12-.02-.18ZM9.81,1.7h1.2c1.6,0,2.9,1.3,2.9,2.9v.12c-.57-.33-1.32-.88-1.59-1.19-.03-.23-.15-.44-.36-.59-.39-.27-.92-.17-1.18.21-.07.1-.18.31-.17.59h-.02s0-.02.01-.05c0,.01-.47,1.16-3.69,1.09v-.18c0-1.6,1.3-2.9,2.9-2.9Zm-2.9,4.79c.08,0,.17,0,.25,0,2.51,0,3.79-.69,4.44-1.32.21.18.46.37.72.55.44.31.88.57,1.24.73.13.06.24.1.36.14v2.67c0,1.07-.58,2-1.44,2.5-.17.03-.32.1-.45.21-.32.12-.66.19-1.02.19h-1.2c-.36,0-.7-.07-1.02-.19-.12-.11-.28-.19-.45-.21-.86-.5-1.44-1.44-1.44-2.5v-2.77Zm2.9,7.38h1.2c.25,0,.5-.02.74-.06v.6l-1.3,1.37-1.39-1.39v-.58c.24.04.49.06.74.06Zm9.31,9.67H1.7v-3.84c.39-1.61,2.08-2.63,3.44-3.2,1.12-.47,2.21-.73,2.78-.85l1.94,1.94c.16.16.38.25.6.25,0,0,0,0,.01,0,.23,0,.45-.1.61-.27l1.82-1.92c.58.12,1.66.37,2.77.84,1.36.57,3.05,1.59,3.44,3.2v3.84Z"/>
            </g>
        </svg>
    ),
    background: 'var(--wp--preset--color--primary)',
    foreground: 'var(--wp--preset--color--white)'
};

registerBlockType(metadata.name, {
    title: __('Artcloud Authors Block', 'artcloud-blocks'),
    description: __('Display posts and events authors block', 'artcloud-blocks'),
    icon: blogikirjoittajatIcon,
    edit: Edit,
    save: save,
});
