import { registerBlockType } from '@wordpress/blocks';
import './style.scss';

import Edit from './edit';
import save from './save';
import metadata from './block.json';
import { __ } from '@wordpress/i18n';

const alertIcon = {
    src: (
        <svg id="Layer_2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 28.5 28.5">
            <g id="Layer_1-2">
                <path style={{ fill: 'var(--wp--preset--color--white)', strokeWidth: '0px' }} d="m14.25,0C6.39,0,0,6.39,0,14.25s6.39,14.25,14.25,14.25,14.25-6.39,14.25-14.25S22.1,0,14.25,0Zm0,27.08c-7.07,0-12.83-5.75-12.83-12.83S7.17,1.42,14.25,1.42s12.83,5.75,12.83,12.83-5.76,12.83-12.83,12.83Z"/>
                <path style={{ fill: 'var(--wp--preset--color--white)', strokeWidth: '0px' }} d="m14.74,20.21c-.06-.06-.14-.12-.23-.15-.17-.08-.37-.08-.54,0-.09.03-.16.08-.23.15-.06.07-.12.14-.15.23-.04.09-.06.18-.06.27,0,.19.08.37.21.5.14.14.31.21.5.21s.37-.07.5-.21c.07-.07.12-.14.16-.23.03-.08.05-.18.05-.27s-.02-.18-.05-.27c-.04-.09-.09-.16-.16-.23Z"/>
                <path style={{ fill: 'var(--wp--preset--color--white)', strokeWidth: '0px' }} d="m14.25,6.2c-.39,0-.71.32-.71.71v9.82c0,.39.32.71.71.71s.71-.32.71-.71V6.91c0-.39-.32-.71-.71-.71Z"/>
            </g>
        </svg>
    ),
    background: 'var(--wp--preset--color--primary)',
    foreground: 'var(--wp--preset--color--white)'
};


registerBlockType(metadata.name, {
    title: __('Artcloud Alert Block', 'artcloud-blocks'),
    description: __(
        'Display alert message in your post and page.',
        'artcloud-blocks'
    ),
    icon: alertIcon,
    edit: Edit,
    save,
});

