/* eslint-disable @wordpress/no-unsafe-wp-apis */
// import editor style
import './editor.scss';
import './style.scss';
import {
	PanelBody,
	__experimentalBorderControl as BorderControl,
} from '@wordpress/components';

import colors from '../colors';
import {
	InnerBlocks,
	useBlockProps,
	InspectorControls,
} from '@wordpress/block-editor';
import { __ } from '@wordpress/i18n';

import { Fragment } from '@wordpress/element';
const Edit = ({ attributes, setAttributes, clientId }) => {
	const { uniqueId, activeAccordionBorder } = attributes;

	// set unique ID
	setAttributes({
		uniqueId: clientId,
	});
	return (
		<Fragment>
			<style>
				{`.artcloud_accordion_${uniqueId} .artcloud__accordion_active { border: ${activeAccordionBorder.width} ${activeAccordionBorder.style} ${activeAccordionBorder.color} !important; }`}
				{`.artcloud_accordion_${uniqueId} .artcloud__accordion_body--show { border-top: ${activeAccordionBorder.width} ${activeAccordionBorder.style} ${activeAccordionBorder.color} !important; }`}
			</style>
			<InspectorControls>
				<PanelBody
					initialOpen={false}
					title={__(
						'Active Accordion Style',
						'artcloud-blocks'
					)}
				>
					<BorderControl
						colors={colors}
						label={__('Border', 'artcloud-blocks')}
						onChange={(value) =>
							setAttributes({ activeAccordionBorder: value })
						}
						value={activeAccordionBorder}
						withSlider={true}
					/>
				</PanelBody>
			</InspectorControls>
			<div
				{...useBlockProps({
					className: `artcloud_accordion_${uniqueId}`,
				})}
			>
				<InnerBlocks
					allowedBlocks={['artcloud-blocks/artcloud-accordion-item']}
					template={[['artcloud-blocks/artcloud-accordion-item']]}
					
				/>
			</div>
		</Fragment>
	);
};
export default Edit;
