/* eslint-disable react/jsx-no-target-blank */
/* eslint-disable no-lonely-if */
import { InnerBlocks, RichText, useBlockProps } from '@wordpress/block-editor';
const Save = ({ attributes }) => {
	const {
		makeActive,
		border,
		margins,
		paddings,
		borderRadius,
		heading,
		headingTag,
		headingColor,
		showIcon,
		iconClass,
		iconPosition,
		iconColor,
		iconBackground,
		headerBg,
		bodyBg,
	} = attributes;

	const activeClass = makeActive ? `artcloud__accordion_body--show` : '';

	// initial accordion stage
	let currentIconClass;
	if (makeActive === false) {
		currentIconClass = iconClass;
	} else {
		if (iconClass === 'plus-alt2') {
			currentIconClass = 'minus';
		} else if (iconClass === 'arrow-down') {
			currentIconClass = 'arrow-up';
		} else if (iconClass === 'arrow-down-alt2') {
			currentIconClass = 'arrow-up-alt2';
		} else if (iconClass === 'plus-alt') {
			currentIconClass = 'dismiss';
		} else if (iconClass === 'insert') {
			currentIconClass = 'remove';
		}
	}

	return (
		<div
			{...useBlockProps.save({
				className: `artcloud__accordion_container ${
					makeActive ? 'artcloud__accordion_active' : ''
				}`,
			})}
			style={{
				border: `${border.width} ${border.style} ${border.color}`,
				marginTop: `${margins.top}`,
				marginBottom: `${margins.bottom}`,
				borderRadius: `${borderRadius}px`,
			}}
		>
			<div
				className={`artcloud__accordion_head ${iconPosition}`}
				data-active={makeActive}
				style={{
					color: headingColor ? headingColor : '#333333',
					backgroundColor: headerBg ? headerBg : 'transparent',
					padding: `${paddings.top} ${paddings.left} ${paddings.bottom} ${paddings.right}`,
				}}
			>
				<div className={`artcloud__accordion_heading ${iconPosition}`}>
					<RichText.Content
						className="artcloud__accordion_title"
						tagName={headingTag}
						value={heading}
						style={{
							margin: 0,
							color: headingColor ? headingColor : '#333333',
						}}
					/>
				</div>
				{showIcon && (
					<div
						className={`artcloud__accordion_icon`}
						style={{
							color: iconColor ? iconColor : '#333333',
							backgroundColor: iconBackground
								? iconBackground
								: 'transparent',
						}}
					>
						<span
							className={`artcloud__icon dashicons dashicons-${currentIconClass}`}
						>
							<svg xmlns="http://www.w3.org/2000/svg" width="19.414" height="23.207" viewBox="0 0 19.414 23.207"><g id="Group_813" data-name="Group 813" transform="translate(18.707 0.5) rotate(90)"><line id="Line_20" data-name="Line 20" x2="21" transform="translate(0 9)" fill="none" stroke="#000" stroke-linecap="round" stroke-width="1"></line><line id="Line_21" data-name="Line 21" x2="9" y2="9" transform="translate(13)" fill="none" stroke="#000" stroke-linecap="round" stroke-width="1"></line><line id="Line_22" data-name="Line 22" y1="9" x2="9" transform="translate(13 9)" fill="none" stroke="#000" stroke-linecap="round" stroke-width="1"></line></g></svg>
						</span>
					</div>
				)}
			</div>
			<div
				className={`artcloud__accordion_body ${activeClass}`}
				role="region"
				style={{
					backgroundColor: bodyBg ? bodyBg : 'transparent',
					borderTop: `${border.width} ${border.style} ${border.color}`,
					padding: `${paddings.top} ${paddings.left} ${paddings.bottom} ${paddings.right}`,
				}}
			>
				<InnerBlocks.Content />
			</div>
		</div>
	);
};
export default Save;
