/* eslint-disable react/jsx-no-target-blank */
/* eslint-disable no-shadow */
/* eslint-disable @wordpress/no-unsafe-wp-apis */
const { Fragment } = wp.element;
import {
	InnerBlocks,
	InspectorControls,
	RichText,
	useBlockProps,
} from '@wordpress/block-editor';
import {
	ColorPalette,
	PanelBody,
	RangeControl,
	SelectControl,
	ToggleControl,
	__experimentalBoxControl as BoxControl,
	__experimentalBorderControl as BorderControl,
} from '@wordpress/components';
const { __ } = wp.i18n;

import colors from '../colors';
import icons from './icons';
import tags from '../tags';

// include editor styles
import './editor.scss';

const iconPositions = [
	{
		label: 'Left',
		value: 'artcloud_left_icon',
	},
	{
		label: 'Right',
		value: 'artcloud_right_icon',
	},
];

const Edit = ({ attributes, setAttributes }) => {
	const {
		makeActive,
		border,
		margins,
		paddings,
		borderRadius,
		heading,
		headingTag,
		headingColor,
		showIcon,
		iconClass,
		iconPosition,
		iconColor,
		iconBackground,
		headerBg,
		bodyBg,
	} = attributes;
	return (
		<Fragment>
			<div
				{...useBlockProps({
					className: `artcloud__accordion_container ${
						makeActive ? 'artcloud__accordion_active' : ''
					}`,
				})}
			>
				<div
					className={`artcloud__accordion_head ${iconPosition}`}
					style={{
						color: headingColor ? headingColor : '#333333',
						backgroundColor: headerBg ? headerBg : 'transparent',
						padding: `${paddings.top} ${paddings.left} ${paddings.bottom} ${paddings.right}`,
					}}
				>
					<div className={`artcloud__accordion_heading ${iconPosition}`}>
						<RichText
							tagName={headingTag}
							value={heading}
							className="artcloud__accordion_title"
							onChange={(heading) => setAttributes({ heading })}
							style={{
								margin: 0,
								color: headingColor ? headingColor : '#333333',
							}}
						/>
					</div>
					{showIcon && (
						<div
							className={`artcloud__accordion_icon`}
							style={{
								color: iconColor ? iconColor : '#333333',
								backgroundColor: iconBackground
									? iconBackground
									: 'transparent',
							}}
						>
							<span
								className={`artcloud__icon dashicons dashicons-${iconClass}`}
							>
								<svg xmlns="http://www.w3.org/2000/svg" width="19.414" height="23.207" viewBox="0 0 19.414 23.207"><g id="Group_813" data-name="Group 813" transform="translate(18.707 0.5) rotate(90)"><line id="Line_20" data-name="Line 20" x2="21" transform="translate(0 9)" fill="none" stroke="#000" stroke-linecap="round" stroke-width="1"></line><line id="Line_21" data-name="Line 21" x2="9" y2="9" transform="translate(13)" fill="none" stroke="#000" stroke-linecap="round" stroke-width="1"></line><line id="Line_22" data-name="Line 22" y1="9" x2="9" transform="translate(13 9)" fill="none" stroke="#000" stroke-linecap="round" stroke-width="1"></line></g></svg>
							</span>
						</div>
					)}
				</div>
				<div
					className={`artcloud__accordion_body ${
						makeActive ? 'artcloud__accordion_body--show' : ''
					}`}
					role="region"
					style={{
						backgroundColor: bodyBg ? bodyBg : 'transparent',
						borderTop: `${border.width} ${border.style} ${border.color}`,
						padding: `${paddings.top} ${paddings.left} ${paddings.bottom} ${paddings.right}`,
					}}
				>
					<InnerBlocks
						allowedBlocks={true}
						template={[
							[
								'core/paragraph',
								{
									placeholder:
										'Write your content or add any block here...',
								},
							],
						]}
					/>
				</div>
			</div>
		</Fragment>
	);
};
export default Edit;
