/* eslint-disable react/jsx-no-target-blank */
/* eslint-disable no-shadow */
/* eslint-disable @wordpress/no-unsafe-wp-apis */
const { Fragment } = wp.element;
import {
	InnerBlocks,
	InspectorControls,
	RichText,
	useBlockProps,
} from '@wordpress/block-editor';
import {
	ColorPalette,
	PanelBody,
	RangeControl,
	SelectControl,
	ToggleControl,
	__experimentalBoxControl as BoxControl,
	__experimentalBorderControl as BorderControl,
	TextControl,
} from '@wordpress/components';
const { __ } = wp.i18n;

import colors from '../colors';
import icons from './icons';
import tags from '../tags';

// include editor styles
import './editor.scss';

const iconPositions = [
	{
		label: 'Left',
		value: 'artcloud-blocks_left_icon',
	},
	{
		label: 'Right',
		value: 'artcloud-blocks_right_icon',
	},
];

const Edit = ({ attributes, setAttributes, clientId }) => {
	const {
		uniqueId,
		makeActive,
		border,
		margins,
		paddings,
		borderRadius,
		heading,
		headingTag,
		headingColor,
		showIcon,
		iconClass,
		iconPosition,
		iconColor,
		iconBackground,
		headerBg,
		bodyBg,
		id,
		linkedAccordion,
		link,
		tab,
		disableAccordion,
	} = attributes;

	// set unique ID
	setAttributes({
		uniqueId: clientId.slice(0, 8),
	});

	return (
		<Fragment>
			<InspectorControls>
				<PanelBody
					initialOpen={false}
					title={__('Accordion ID', 'artcloud-blocks')}
				>
					<TextControl
						label={__(
							'Set Accordion ID',
							'artcloud-blocks'
						)}
						value={id}
						onChange={(id) => setAttributes({ id })}
					/>
				</PanelBody>
				<PanelBody
					initialOpen={false}
					title={__('Accordion Status', 'artcloud-blocks')}
				>
					{linkedAccordion !== true && (
						<ToggleControl
							label={__(
								'Make it Active on Load',
								'artcloud-blocks'
							)}
							checked={makeActive}
							onChange={() =>
								setAttributes({ makeActive: !makeActive })
							}
						/>
					)}
					{linkedAccordion !== true && (
						<ToggleControl
							label={__(
								'Make it a Disable Accordion?',
								'artcloud-blocks'
							)}
							checked={disableAccordion}
							onChange={() =>
								setAttributes({
									disableAccordion: !disableAccordion,
								})
							}
							help={__(
								'No click event works. This feature is for the frontend only!',
								'artcloud-blocks'
							)}
						/>
					)}
					<ToggleControl
						label={__(
							'Turn it into a Linked Accordion?',
							'artcloud-blocks'
						)}
						checked={linkedAccordion}
						onChange={() =>
							setAttributes({ linkedAccordion: !linkedAccordion })
						}
						help={__(
							'Linked Accordion disable the Accordion Body and open the link when it is clicked.',
							'artcloud-blocks'
						)}
					/>
					{linkedAccordion && (
						<Fragment>
							<TextControl
								label={__(
									'Link URL',
									'artcloud-blocks'
								)}
								value={link}
								onChange={(link) => setAttributes({ link })}
							/>
							<ToggleControl
								label={__(
									'Open in new tab?',
									'artcloud-blocks'
								)}
								checked={tab}
								onChange={() =>
									setAttributes({
										tab: !tab,
									})
								}
							/>
						</Fragment>
					)}
				</PanelBody>
				<PanelBody
					initialOpen={false}
					title={__('Accordion Settings', 'artcloud-blocks')}
				>
					<BoxControl
						values={margins}
						label={__(
							'Accordion Margin',
							'artcloud-blocks'
						)}
						sides={['top', 'bottom']}
						units={[]}
						allowReset={false}
						onChange={(newValue) =>
							setAttributes({
								...margins,
								margins: {
									top: newValue.top,
									bottom: newValue.bottom,
								},
							})
						}
					/>
					<div className="aa-custom-spacer"></div>
					<BoxControl
						values={paddings}
						label={__(
							'Content Padding',
							'artcloud-blocks'
						)}
						sides={['horizontal', 'vertical']}
						units={[]}
						splitOnAxis={true}
						allowReset={false}
						onChange={(newValue) =>
							setAttributes({
								...paddings,
								paddings: {
									top: newValue.top,
									left: newValue.left,
									right: newValue.right,
									bottom: newValue.bottom,
								},
							})
						}
					/>
					<div className="aa-custom-spacer"></div>
					<BorderControl
						colors={colors}
						label={__(
							'Set Accordion Border',
							'artcloud-blocks'
						)}
						onChange={(value) => setAttributes({ border: value })}
						value={border}
						withSlider={true}
					/>
					<div className="aa-custom-spacer"></div>
					<RangeControl
						label={__('Border Radius', 'artcloud-blocks')}
						value={borderRadius}
						onChange={(borderRadius) =>
							setAttributes({ borderRadius })
						}
						min={0}
						max={50}
					/>
				</PanelBody>
				<PanelBody
					initialOpen={false}
					title={__('Accordion Head', 'artcloud-blocks')}
				>
					<p className="artcloud-blocks__label">
						{__('Header Color', 'artcloud-blocks')}
					</p>
					<ColorPalette
						colors={colors}
						value={headingColor}
						onChange={(headingColor) =>
							setAttributes({ headingColor })
						}
					/>
					<p className="artcloud-blocks__label">
						{__('Header Background', 'artcloud-blocks')}
					</p>
					<ColorPalette
						colors={colors}
						value={headerBg}
						onChange={(headerBg) => setAttributes({ headerBg })}
					/>
					<SelectControl
						label={__(
							'Select Heading Tag',
							'artcloud-blocks'
						)}
						options={tags}
						onChange={(headingTag) => setAttributes({ headingTag })}
						value={headingTag}
					/>
				</PanelBody>
				<PanelBody
					title={__('Accordion Icon', 'artcloud-blocks')}
					initialOpen={false}
				>
					<ToggleControl
						label={__('Show Icon', 'artcloud-blocks')}
						checked={showIcon}
						onChange={() => setAttributes({ showIcon: !showIcon })}
					/>
					{showIcon && (
						<Fragment>
							<SelectControl
								label={__(
									'Select Icon Type',
									'artcloud-blocks'
								)}
								options={icons}
								onChange={(iconClass) => {
									setAttributes({ iconClass });
								}}
								value={iconClass}
							/>
							<SelectControl
								label={__(
									'Icon Position',
									'artcloud-blocks'
								)}
								options={iconPositions}
								onChange={(iconPosition) => {
									setAttributes({ iconPosition });
								}}
								value={iconPosition}
							/>
							<p className="artcloud-blocks__label">
								{__('Icon Color', 'artcloud-blocks')}
							</p>
							<ColorPalette
								colors={colors}
								value={iconColor}
								onChange={(iconColor) =>
									setAttributes({ iconColor })
								}
							/>
							<p className="artcloud-blocks__label">
								{__(
									'Icon Background',
									'artcloud-blocks'
								)}
							</p>
							<ColorPalette
								colors={colors}
								value={iconBackground}
								onChange={(iconBackground) =>
									setAttributes({ iconBackground })
								}
							/>
						</Fragment>
					)}
				</PanelBody>
				<PanelBody
					title={__('Accordion Body', 'artcloud-blocks')}
					initialOpen={false}
				>
					<p className="artcloud-blocks__label">
						{__('Background Color', 'artcloud-blocks')}
					</p>
					<ColorPalette
						colors={colors}
						value={bodyBg}
						onChange={(bodyBg) => setAttributes({ bodyBg })}
					/>
				</PanelBody>
			</InspectorControls>
			<div
				{...useBlockProps({
					className: `artcloud-blocks__accordion_container ${
						makeActive
							? `active__accordion_container_${uniqueId}`
							: ''
					}`,
				})}
				style={{
					border: `${border.width} ${border.style} ${border.color}`,
					marginTop: `${margins.top}`,
					marginBottom: `${margins.bottom}`,
					borderRadius: `${borderRadius}px`,
				}}
				id={id !== '' ? id : ''}
			>
				{linkedAccordion ? (
					<Fragment>
						<a
							href={link}
							target={tab ? '_blank' : '_self'}
							rel={tab ? 'noopener noreferrer' : 'noopener'}
							className="artcloud-blocks__accordion_link"
						>
							<div
								className={`artcloud-blocks__accordion_head ${iconPosition}`}
								style={{
									color: headingColor
										? headingColor
										: '#333333',
									backgroundColor: headerBg
										? headerBg
										: 'transparent',
									padding: `${paddings.top} ${paddings.left} ${paddings.bottom} ${paddings.right}`,
								}}
							>
								<div
									className={`artcloud-blocks__accordion_heading ${iconPosition}`}
								>
									<RichText
										tagName={headingTag}
										value={heading}
										className="artcloud-blocks__accordion_title"
										onChange={(heading) =>
											setAttributes({ heading })
										}
										style={{
											margin: 0,
											color: headingColor
												? headingColor
												: '#333333',
										}}
									/>
								</div>
								{showIcon && (
									<div
										className={`artcloud-blocks__accordion_icon`}
										style={{
											color: iconColor
												? iconColor
												: '#333333',
											backgroundColor: iconBackground
												? iconBackground
												: 'transparent',
										}}
									>
										<span className={`artcloud-blocks__icon dashicons dashicons-${iconClass}`}>
											<svg xmlns="http://www.w3.org/2000/svg" width="19.414" height="23.207" viewBox="0 0 19.414 23.207"><g id="Group_813" data-name="Group 813" transform="translate(18.707 0.5) rotate(90)"><line id="Line_20" data-name="Line 20" x2="21" transform="translate(0 9)" fill="none" stroke="#000" stroke-linecap="round" stroke-width="1"></line><line id="Line_21" data-name="Line 21" x2="9" y2="9" transform="translate(13)" fill="none" stroke="#000" stroke-linecap="round" stroke-width="1"></line><line id="Line_22" data-name="Line 22" y1="9" x2="9" transform="translate(13 9)" fill="none" stroke="#000" stroke-linecap="round" stroke-width="1"></line></g></svg>
										</span>
									</div>
								)}
							</div>
						</a>
					</Fragment>
				) : (
					<Fragment>
						<div
							className={`artcloud-blocks__accordion_head ${iconPosition}`}
							style={{
								color: headingColor ? headingColor : '#333333',
								backgroundColor: headerBg
									? headerBg
									: 'transparent',
								padding: `${paddings.top} ${paddings.left} ${paddings.bottom} ${paddings.right}`,
							}}
						>
							<div
								className={`artcloud-blocks__accordion_heading ${iconPosition}`}
							>
								<RichText
									tagName={headingTag}
									value={heading}
									className="artcloud-blocks__accordion_title"
									onChange={(heading) =>
										setAttributes({ heading })
									}
									style={{
										margin: 0,
										color: headingColor
											? headingColor
											: '#333333',
									}}
								/>
							</div>
							{showIcon && (
								<div
									className={`artcloud-blocks__accordion_icon`}
									style={{
										color: iconColor
											? iconColor
											: '#333333',
										backgroundColor: iconBackground
											? iconBackground
											: 'transparent',
									}}
								>
									<span
										className={`artcloud-blocks__icon dashicons dashicons-${iconClass}`}
									></span>
								</div>
							)}
						</div>
						<div
							className={`artcloud-blocks__accordion_body ${
								makeActive
									? `active__accordion_${uniqueId}`
									: ''
							}`}
							role="region"
							style={{
								backgroundColor: bodyBg
									? bodyBg
									: 'transparent',
								borderTop: `${border.width} ${border.style} ${border.color}`,
								padding: `${paddings.top} ${paddings.left} ${paddings.bottom} ${paddings.right}`,
							}}
						>
							<InnerBlocks
								allowedBlocks={true}
								template={[
									[
										'core/paragraph',
										{
											placeholder:
												'Write your content or add any block here...',
										},
									],
								]}
							/>
						</div>
					</Fragment>
				)}
			</div>
		</Fragment>
	);
};
export default Edit;
