/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/blocks/artcloud-posts/edit.js":
/*!*******************************************!*\
  !*** ./src/blocks/artcloud-posts/edit.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Edit)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _editor_scss__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./editor.scss */ "./src/blocks/artcloud-posts/editor.scss");







function Edit({
  attributes,
  setAttributes
}) {
  const {
    title,
    numberOfItems,
    orderBy,
    order,
    selectedStyle,
    displayFeaturedImage,
    displayDescription,
    displayDateAuthor,
    postType,
    categories,
    selectedTitles,
    textColor,
    backgroundColor,
    btnBackgroundColor,
    btnTextColor
  } = attributes;
  const postTypes = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => {
    return select('core').getPostTypes();
  }, []);
  const catIds = categories && categories.length > 0 ? categories.map(cat => cat.id) : [];
  const postTypeTaxonomy = postTypes && postTypes.length ? postTypes.find(type => type.slug === postType)?.taxonomies[0] || 'category' : '';
  const items = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => {
    // If titles are selected, fetch posts by title
    if (selectedTitles && selectedTitles.length > 0) {
      const titleArgs = {
        per_page: -1,
        // Fetch all posts when selecting by title
        _embed: true
      };
      return select('core').getEntityRecords('postType', postType, titleArgs);
    }

    // If no titles are selected, fall back to other queries (category, etc.)
    const otherQueryArgs = {
      per_page: numberOfItems,
      order,
      orderby: orderBy,
      _embed: true
    };
    postType === 'post' ? otherQueryArgs.categories = catIds : otherQueryArgs[postTypeTaxonomy] = catIds;
    return select('core').getEntityRecords('postType', postType, otherQueryArgs);
  }, [postType, catIds, postTypeTaxonomy, numberOfItems, orderBy, order, selectedTitles]);

  //For Post
  const allCats = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => {
    return postTypeTaxonomy ? select('core').getEntityRecords('taxonomy', postTypeTaxonomy, {
      per_page: -1
    }) : [];
  }, [postTypeTaxonomy]);
  const catSuggestions = {};
  //For other post type
  if (allCats) {
    for (let i = 0; i < allCats.length; i++) {
      const cat = allCats[i];
      catSuggestions[cat.name] = cat;
    }
  }
  const onCategoryChange = values => {
    const hasNoSuggestions = values.some(value => typeof value === 'string' && !catSuggestions[value]);
    if (hasNoSuggestions) return;
    const updatesCats = values.map(token => {
      return typeof token === 'string' ? catSuggestions[token] : token;
    });
    setAttributes({
      categories: updatesCats
    });
  };
  const onChangeTitle = value => {
    setAttributes({
      title: value
    });
  };
  const onChangeBackgroundColor = newBgColor => {
    setAttributes({
      backgroundColor: newBgColor
    });
  };
  const onChangeTextColor = newTextColor => {
    setAttributes({
      textColor: newTextColor
    });
  };
  const onChangebtnTextColor = newTextColor => {
    setAttributes({
      btnTextColor: newTextColor
    });
  };
  const onChangeBtnBackgroundColor = newBgColor => {
    setAttributes({
      btnBackgroundColor: newBgColor
    });
  };
  const onPostTypeChange = value => {
    setAttributes({
      postType: value
    });
    setAttributes({
      categories: []
    });
  };
  const displayImageChange = value => {
    setAttributes({
      displayFeaturedImage: value
    });
  };
  const displayDateAuthorChange = value => {
    setAttributes({
      displayDateAuthor: value
    });
  };
  const displayDescriptionChange = value => {
    setAttributes({
      displayDescription: value
    });
  };
  const onNumberOfItemsChange = value => {
    setAttributes({
      numberOfItems: value
    });
  };
  const onSelectTitles = selected => {
    const titleObjs = selected.map(title => {
      const foundpost = allpostTitles.find(post => post.title === title);
      return foundpost ? foundpost : {
        id: null,
        title: title
      };
    });
    setAttributes({
      selectedTitles: titleObjs
    });
  };
  const onChangeStyle = value => {
    setAttributes({
      selectedStyle: value
    });
  };
  const filteredItems = (items || []).filter(item => !selectedTitles || selectedTitles.length === 0 || selectedTitles.some(titleObj => titleObj.title === item.title.rendered));
  const allpostTitles = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => {
    const baseArgs = {
      per_page: -1
    };
    if (catIds && catIds.length > 0) {
      baseArgs['categories'] = catIds;
    }
    const allposts = select('core').getEntityRecords('postType', postType, baseArgs);
    return allposts ? allposts.map(post => ({
      id: post.id,
      title: post.title.rendered
    })) : [];
  }, [catIds]);
  const excludedSlugs = ["attachment", "nav_menu_item", "page", "team", "product", "event", "wp_block", "wp_template", "wp_template_part", "wp_navigation", "wp_font_face", "wp_font_family"];
  //sort post by selected title wise
  function sortpostsBySelectedTitles(posts, selectedTitles) {
    const sortedposts = [];

    // Iterate through the selectedTitles and find matching posts
    selectedTitles.forEach(titleObj => {
      const matchingpost = posts.find(post => titleObj.title === post.title.rendered);
      if (matchingpost) {
        sortedposts.push(matchingpost);
      }
    });

    // Add remaining posts that were not in selectedTitles
    posts.forEach(post => {
      if (!selectedTitles.some(titleObj => titleObj.title === post.title.rendered)) {
        sortedposts.push(post);
      }
    });
    return sortedposts;
  }
  const sortedItems = sortpostsBySelectedTitles(filteredItems, selectedTitles);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.InspectorControls, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.PanelBody, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.SelectControl, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Select Style', 'artcloud-blocks'),
    value: selectedStyle,
    options: [{
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Style 1', 'artcloud-blocks'),
      value: 'style1'
    }, {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Style 2', 'artcloud-blocks'),
      value: 'style2'
    }
    // Add more styles as needed
    ],
    onChange: onChangeStyle
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ToggleControl, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Display Image', 'artcloud-blocks'),
    checked: displayFeaturedImage,
    onChange: displayImageChange
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ToggleControl, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Display Content', 'artcloud-blocks'),
    checked: displayDescription,
    onChange: displayDescriptionChange
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ToggleControl, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Display Date & Author', 'artcloud-blocks'),
    checked: displayDateAuthor,
    onChange: displayDateAuthorChange
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.SelectControl, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Select Post Type', 'artcloud-blocks'),
    value: postType,
    options: postTypes ? postTypes.filter(type => !excludedSlugs.includes(type.slug)).map(type => ({
      label: type.name,
      value: type.slug
    })) : [],
    onChange: onPostTypeChange
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.QueryControls, {
    categorySuggestions: catSuggestions,
    selectedCategories: categories,
    onCategoryChange: onCategoryChange,
    numberOfItems: numberOfItems,
    onNumberOfItemsChange: onNumberOfItemsChange,
    orderBy: orderBy,
    onOrderByChange: value => setAttributes({
      orderBy: value
    }),
    order: order,
    onOrderChange: value => setAttributes({
      order: value
    })
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.FormTokenField, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Select posts by Title', 'artcloud-blocks'),
    value: selectedTitles.map(titleObj => titleObj.title),
    suggestions: allpostTitles.map(post => post.title),
    onChange: onSelectTitles
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.PanelColorSettings, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Color Settings', 'artcloud-blocks'),
    icon: "admin-appearance",
    initialOpen: true,
    colorSettings: [{
      value: backgroundColor,
      onChange: onChangeBackgroundColor,
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Background Color', 'artcloud-blocks')
    }, {
      value: textColor,
      onChange: onChangeTextColor,
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Text Color', 'artcloud-blocks')
    }, {
      value: btnBackgroundColor,
      onChange: onChangeBtnBackgroundColor,
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Button BG Color', 'artcloud-blocks')
    }, {
      value: btnTextColor,
      onChange: onChangebtnTextColor,
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('ButtonText Color', 'artcloud-blocks')
    }]
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.ContrastChecker, {
    textColor: textColor,
    backgroundColor: backgroundColor
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    ...(0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.useBlockProps)()
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.RichText, {
    tagName: "h1",
    style: {
      color: btnBackgroundColor
    },
    className: "post-block-title",
    placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Enter title', 'artcloud-blocks'),
    allowedFormats: [],
    value: title,
    onChange: onChangeTitle
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "row"
  }, sortedItems && sortedItems.map(post => {
    var _post$_embedded$autho;
    const postImage = post._embedded && post._embedded['wp:featuredmedia'] && post._embedded['wp:featuredmedia'].length > 0 && post._embedded['wp:featuredmedia'][0];
    const authorName = (_post$_embedded$autho = post?._embedded?.['author']?.[0]?.name) !== null && _post$_embedded$autho !== void 0 ? _post$_embedded$autho : post.speaker_name;
    const postContent = post.excerpt.rendered;
    const postExcerpt = selectedStyle === 'style1' ? postContent.split(' ').slice(0, 8).join(' ') : postContent.split(' ').slice(0, 25).join(' ');
    const postDate = new Date(post.date);
    const options1 = {
      day: 'numeric',
      month: 'numeric',
      year: 'numeric'
    };
    const options2 = {
      day: 'numeric',
      month: 'numeric',
      year: 'numeric',
      hour: 'numeric',
      minute: 'numeric',
      second: 'numeric',
      hour24: true // Set this to true for 12-hour clock format
    };
    const selectedOptions = selectedStyle === 'style1' ? options1 : options2;
    const formattedDateTime = postDate.toLocaleDateString('fi-FI', selectedOptions).replace(/\//g, ' ').replace(',', '');
    const dateAuthor = formattedDateTime + ' | ' + authorName;
    const defaultImage = window.location.origin + '/wp-content/plugins/artcloud-blocks/assets/img/default-image.jpg';
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "artcloud-item col-4",
      style: {
        backgroundColor: backgroundColor,
        color: textColor
      }
    }, selectedStyle === 'style1' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(React.Fragment, null, displayFeaturedImage && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "artcloud-postImg"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
      alt: postImage && postImage.alt_text,
      src: postImage && postImage.media_details.sizes.full.source_url ? postImage.media_details.sizes.full.source_url : defaultImage
    })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "artcloud-content"
    }, displayDateAuthor && dateAuthor && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h6", {
      style: {
        color: textColor
      }
    }, " ", dateAuthor, " "), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", {
      style: {
        color: textColor
      }
    }, post.title.rendered), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.RawHTML, null, displayDescription && postExcerpt && postExcerpt), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
      style: {
        backgroundColor: btnBackgroundColor,
        color: btnTextColor
      },
      className: "wp-block-post-excerpt__more-link",
      href: post.link
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Lue lisää', 'artcloud-blocks')))), selectedStyle === 'style2' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(React.Fragment, null, displayFeaturedImage && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "artcloud-postImg"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
      alt: postImage && postImage.alt_text,
      src: postImage && postImage.media_details.sizes.full.source_url ? postImage.media_details.sizes.full.source_url : defaultImage
    })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "artcloud-content"
    }, displayDateAuthor && dateAuthor && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h6", {
      style: {
        color: textColor
      }
    }, " ", dateAuthor), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h5", {
      style: {
        color: textColor
      }
    }, post.title.rendered), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.RawHTML, null, displayDescription && postExcerpt && postExcerpt), " ")));
  }))));
}

/***/ }),

/***/ "./src/blocks/artcloud-posts/index.js":
/*!********************************************!*\
  !*** ./src/blocks/artcloud-posts/index.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./style.scss */ "./src/blocks/artcloud-posts/style.scss");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _edit__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./edit */ "./src/blocks/artcloud-posts/edit.js");
/* harmony import */ var _save__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./save */ "./src/blocks/artcloud-posts/save.js");
/* harmony import */ var _block_json__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./block.json */ "./src/blocks/artcloud-posts/block.json");







const iconPosts = {
  src: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    id: "Layer_2",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 29.91 28.91"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("style", null, `.cls-1{fill:var(--wp--preset--color--white);stroke-width:0px;}`)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
    id: "Layer_1-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    class: "cls-1",
    d: "m23.49,15.03H6.08c-.39,0-.71.32-.71.71s.32.71.71.71h17.42c.39,0,.71-.32.71-.71s-.32-.71-.71-.71Z"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    class: "cls-1",
    d: "m23.49,19.18H6.08c-.39,0-.71.32-.71.71s.32.71.71.71h17.42c.39,0,.71-.32.71-.71s-.32-.71-.71-.71Z"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    class: "cls-1",
    d: "m9.01,22.91h-2.94c-.39,0-.71.32-.71.71s.32.71.71.71h2.94c.39,0,.71-.32.71-.71s-.32-.71-.71-.71Z"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    class: "cls-1",
    d: "m29.2,0H.71c-.39,0-.71.32-.71.71v27.49c0,.39.32.71.71.71h28.49c.39,0,.71-.32.71-.71V.71c0-.39-.32-.71-.71-.71Zm-.71,1.42v9.55c-.11-.07-.23-.12-.37-.12H1.42V1.42h27.07ZM1.42,27.49v-15.22h26.71c.14,0,.26-.05.37-.12v15.33H1.42Z"
  }))),
  background: 'var(--wp--preset--color--primary)',
  foreground: 'var(--wp--preset--color--white)'
};
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)(_block_json__WEBPACK_IMPORTED_MODULE_6__.name, {
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Artcloud Posts Block', 'artcloud-blocks'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Show posts and events', 'artcloud-blocks'),
  icon: iconPosts,
  edit: _edit__WEBPACK_IMPORTED_MODULE_4__["default"],
  save: _save__WEBPACK_IMPORTED_MODULE_5__["default"]
});

/***/ }),

/***/ "./src/blocks/artcloud-posts/save.js":
/*!*******************************************!*\
  !*** ./src/blocks/artcloud-posts/save.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ save)
/* harmony export */ });
function save() {
  return null;
}

/***/ }),

/***/ "./src/blocks/artcloud-posts/editor.scss":
/*!***********************************************!*\
  !*** ./src/blocks/artcloud-posts/editor.scss ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./src/blocks/artcloud-posts/style.scss":
/*!**********************************************!*\
  !*** ./src/blocks/artcloud-posts/style.scss ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "react":
/*!************************!*\
  !*** external "React" ***!
  \************************/
/***/ ((module) => {

module.exports = window["React"];

/***/ }),

/***/ "@wordpress/block-editor":
/*!*************************************!*\
  !*** external ["wp","blockEditor"] ***!
  \*************************************/
/***/ ((module) => {

module.exports = window["wp"]["blockEditor"];

/***/ }),

/***/ "@wordpress/blocks":
/*!********************************!*\
  !*** external ["wp","blocks"] ***!
  \********************************/
/***/ ((module) => {

module.exports = window["wp"]["blocks"];

/***/ }),

/***/ "@wordpress/components":
/*!************************************!*\
  !*** external ["wp","components"] ***!
  \************************************/
/***/ ((module) => {

module.exports = window["wp"]["components"];

/***/ }),

/***/ "@wordpress/data":
/*!******************************!*\
  !*** external ["wp","data"] ***!
  \******************************/
/***/ ((module) => {

module.exports = window["wp"]["data"];

/***/ }),

/***/ "@wordpress/element":
/*!*********************************!*\
  !*** external ["wp","element"] ***!
  \*********************************/
/***/ ((module) => {

module.exports = window["wp"]["element"];

/***/ }),

/***/ "@wordpress/i18n":
/*!******************************!*\
  !*** external ["wp","i18n"] ***!
  \******************************/
/***/ ((module) => {

module.exports = window["wp"]["i18n"];

/***/ }),

/***/ "./src/blocks/artcloud-posts/block.json":
/*!**********************************************!*\
  !*** ./src/blocks/artcloud-posts/block.json ***!
  \**********************************************/
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$schema":"https://raw.githubusercontent.com/WordPress/gutenberg/trunk/schemas/json/block.json","apiVersion":3,"name":"artcloud-blocks/artcloud-posts","version":"1.0.0","title":"ArtCloud Posts Block","category":"artcloud-blocks","description":"Dynamic posts block","keywords":["product","grid"],"supports":{"align":["wide","full"],"html":false},"textdomain":"artcloud-blocks","editorScript":"file:./index.js","editorStyle":"file:./index.css","style":"file:./style-index.css","attributes":{"title":{"type":"string","default":"Ajankohtaista"},"numberOfItems":{"type":"number","default":3},"displayFeaturedImage":{"type":"boolean","default":true},"displayDescription":{"type":"boolean","default":true},"displayDateAuthor":{"type":"boolean","default":true},"postType":{"type":"string","default":"post"},"categories":{"type":"array","items":{"type":"object"}},"selectedTitles":{"type":"array","default":[]},"backgroundColor":{"type":"string"},"selectedStyle":{"type":"string","default":"style1"},"textColor":{"type":"string","default":"#000000"},"btnBackgroundColor":{"type":"string"},"order":{"type":"string","default":"desc"},"orderBy":{"type":"string","default":"date"},"btnTextColor":{"type":"string"}}}');

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = __webpack_modules__;
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/chunk loaded */
/******/ 	(() => {
/******/ 		var deferred = [];
/******/ 		__webpack_require__.O = (result, chunkIds, fn, priority) => {
/******/ 			if(chunkIds) {
/******/ 				priority = priority || 0;
/******/ 				for(var i = deferred.length; i > 0 && deferred[i - 1][2] > priority; i--) deferred[i] = deferred[i - 1];
/******/ 				deferred[i] = [chunkIds, fn, priority];
/******/ 				return;
/******/ 			}
/******/ 			var notFulfilled = Infinity;
/******/ 			for (var i = 0; i < deferred.length; i++) {
/******/ 				var [chunkIds, fn, priority] = deferred[i];
/******/ 				var fulfilled = true;
/******/ 				for (var j = 0; j < chunkIds.length; j++) {
/******/ 					if ((priority & 1 === 0 || notFulfilled >= priority) && Object.keys(__webpack_require__.O).every((key) => (__webpack_require__.O[key](chunkIds[j])))) {
/******/ 						chunkIds.splice(j--, 1);
/******/ 					} else {
/******/ 						fulfilled = false;
/******/ 						if(priority < notFulfilled) notFulfilled = priority;
/******/ 					}
/******/ 				}
/******/ 				if(fulfilled) {
/******/ 					deferred.splice(i--, 1)
/******/ 					var r = fn();
/******/ 					if (r !== undefined) result = r;
/******/ 				}
/******/ 			}
/******/ 			return result;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/jsonp chunk loading */
/******/ 	(() => {
/******/ 		// no baseURI
/******/ 		
/******/ 		// object to store loaded and loading chunks
/******/ 		// undefined = chunk not loaded, null = chunk preloaded/prefetched
/******/ 		// [resolve, reject, Promise] = chunk loading, 0 = chunk loaded
/******/ 		var installedChunks = {
/******/ 			"blocks/artcloud-posts/index": 0,
/******/ 			"blocks/artcloud-posts/style-index": 0
/******/ 		};
/******/ 		
/******/ 		// no chunk on demand loading
/******/ 		
/******/ 		// no prefetching
/******/ 		
/******/ 		// no preloaded
/******/ 		
/******/ 		// no HMR
/******/ 		
/******/ 		// no HMR manifest
/******/ 		
/******/ 		__webpack_require__.O.j = (chunkId) => (installedChunks[chunkId] === 0);
/******/ 		
/******/ 		// install a JSONP callback for chunk loading
/******/ 		var webpackJsonpCallback = (parentChunkLoadingFunction, data) => {
/******/ 			var [chunkIds, moreModules, runtime] = data;
/******/ 			// add "moreModules" to the modules object,
/******/ 			// then flag all "chunkIds" as loaded and fire callback
/******/ 			var moduleId, chunkId, i = 0;
/******/ 			if(chunkIds.some((id) => (installedChunks[id] !== 0))) {
/******/ 				for(moduleId in moreModules) {
/******/ 					if(__webpack_require__.o(moreModules, moduleId)) {
/******/ 						__webpack_require__.m[moduleId] = moreModules[moduleId];
/******/ 					}
/******/ 				}
/******/ 				if(runtime) var result = runtime(__webpack_require__);
/******/ 			}
/******/ 			if(parentChunkLoadingFunction) parentChunkLoadingFunction(data);
/******/ 			for(;i < chunkIds.length; i++) {
/******/ 				chunkId = chunkIds[i];
/******/ 				if(__webpack_require__.o(installedChunks, chunkId) && installedChunks[chunkId]) {
/******/ 					installedChunks[chunkId][0]();
/******/ 				}
/******/ 				installedChunks[chunkId] = 0;
/******/ 			}
/******/ 			return __webpack_require__.O(result);
/******/ 		}
/******/ 		
/******/ 		var chunkLoadingGlobal = globalThis["webpackChunkartcloud_blocks"] = globalThis["webpackChunkartcloud_blocks"] || [];
/******/ 		chunkLoadingGlobal.forEach(webpackJsonpCallback.bind(null, 0));
/******/ 		chunkLoadingGlobal.push = webpackJsonpCallback.bind(null, chunkLoadingGlobal.push.bind(chunkLoadingGlobal));
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module depends on other loaded chunks and execution need to be delayed
/******/ 	var __webpack_exports__ = __webpack_require__.O(undefined, ["blocks/artcloud-posts/style-index"], () => (__webpack_require__("./src/blocks/artcloud-posts/index.js")))
/******/ 	__webpack_exports__ = __webpack_require__.O(__webpack_exports__);
/******/ 	
/******/ })()
;
//# sourceMappingURL=index.js.map