/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/blocks/artcloud-peoples/AddLabelForm.js":
/*!*****************************************************!*\
  !*** ./src/blocks/artcloud-peoples/AddLabelForm.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AddLabelForm: () => (/* binding */ AddLabelForm)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__);





const AddLabelForm = ({
  attributes,
  setAttributes,
  sortedMembers,
  handleSubmit,
  closeModal
}) => {
  const {
    categories,
    selectedTitles
  } = attributes;
  const [rows, setRows] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)([{
    0: '',
    1: '',
    2: '',
    3: ''
  }]);
  const [rankInfo, setRankInfo] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)([{}]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
    const fetchData = async () => {
      const catID = categories && categories.length > 0 ? categories && categories[0].id : null;
      const taxonomy = await _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2___default()({
        path: `/wp/v2/group/${catID}`
      });
      const rank_info_db = taxonomy && taxonomy.rank_information ? taxonomy.rank_information : 'a:0:{}';
      if (rank_info_db && rank_info_db !== 'a:0:{}' && rank_info_db !== 'a:1:{i:0;a:0:{}}') {
        function unserialize(data) {
          return data.match(/s:([0-9]+):"(.*?)";/g).map(function (s) {
            var m = s.match(/s:([0-9]+):"(.*?)";/);
            if (m) {
              if (m[2].startsWith('a:') || m[2].startsWith('O:')) {
                return JSON.parse(deserializeValue(m[2]));
              } else {
                return m[2];
              }
            } else {
              return s;
            }
          });
        }
        function deserializeValue(value) {
          var deserialized = unserialize(value);
          return deserialized.length === 1 ? deserialized[0] : deserialized;
        }
        if (rank_info_db && rank_info_db !== 'a:0:{}') {
          const deserializedMetadata = unserialize(rank_info_db);
          let updatedRankInfo = [];
          for (let i = 0; i < deserializedMetadata.length; i += 4) {
            updatedRankInfo.push(deserializedMetadata.slice(i, i + 4));
          }
          setRankInfo(updatedRankInfo);
        } else {
          console.warn('Taxonomy or rank_information is null.');
        }
      }
    };
    fetchData();
  }, [categories]);
  const handleChange = (index, field, value) => {
    const newRows = [...rows];
    newRows[index] = {
      ...newRows[index],
      [field]: value
    };
    setRows(newRows);
    const newRankInfo = [...rankInfo];
    if (newRankInfo[index]) {
      newRankInfo[index] = {
        ...newRankInfo[index],
        [field]: value
      };
    } else {
      newRankInfo[index] = {
        [field]: value
      };
    }
    setRankInfo(newRankInfo);
  };
  const handleAddRow = () => {
    const newRow = {
      0: '',
      1: '',
      2: '',
      3: ''
    };
    setRows([...rows, newRow]);
  };
  const handleRemoveRow = index => {
    const newRows = [...rows];
    newRows.splice(index, 1);
    setRows(newRows);
    const newRankInfo = [...rankInfo];
    newRankInfo.splice(index, 1);
    setRankInfo(newRankInfo);
  };
  const handleFormSubmit = async e => {
    e.preventDefault();
    let formData = Array.from({
      length: Math.max(rows.length, rankInfo.length)
    }).flatMap((_, index) => rankInfo[index] || (rows[index] ? rows[index] : ''));
    try {
      const saveResponse = await saveTermMeta(formData);
      closeModal();
      // console.log('Save Response:', saveResponse);
    } catch (error) {
      console.error('Error saving term meta or fetching posts:', error);
    }
    const newData = formData;
    handleSubmit(newData);
    // console.log('Form Data:', formData);
  };
  const saveTermMeta = async rankInformation => {
    try {
      const termId = categories && categories.length > 0 ? categories[0].id : null;
      const response = await _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2___default()({
        path: '/persons_info/v1/save_rank_information/',
        method: 'POST',
        headers: {
          'Content-Type': 'application/json'
        },
        body: JSON.stringify({
          term_id: termId,
          rank_information: rankInformation
        })
      });
      return response;
    } catch (error) {
      throw error;
    }
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("form", {
    onSubmit: handleFormSubmit
  }, Array.from({
    length: Math.max(rows.length, rankInfo.length)
  }).map((_, index) => {
    const isExistingRow = index < rankInfo.length;
    const rankInfoData = isExistingRow ? rankInfo[index] : {};
    const rowData = isExistingRow ? rankInfoData : rows[index];
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "artcloud-peoples-row"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      key: index,
      id: `row-${index + 1}`,
      className: "artcloud-people-member"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
      type: "number",
      value: rowData[0] || '',
      onChange: e => handleChange(index, 0, e.target.value),
      placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Number', 'artcloud-blocks')
    }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
      type: "text",
      value: rowData[1] || '',
      onChange: e => handleChange(index, 1, e.target.value),
      placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Designation', 'artcloud-blocks')
    }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("select", {
      value: rowData[2] || '',
      onChange: e => handleChange(index, 2, e.target.value)
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("option", {
      value: ""
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Select People', 'artcloud-blocks')), sortedMembers && sortedMembers.map(post => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("option", {
      key: post.id,
      value: post.id
    }, post.title.rendered))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("select", {
      value: rowData[3] || '',
      onChange: e => handleChange(index, 3, e.target.value)
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("option", {
      value: ""
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Select Varalla', 'artcloud-blocks')), sortedMembers && sortedMembers.map(post => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("option", {
      key: post.id,
      value: post.id
    }, post.title.rendered)))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
      href: "#",
      className: "artcloud-people-delete",
      onClick: e => handleRemoveRow(index)
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "dashicons dashicons-trash"
    })));
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
    variant: "secondary",
    onClick: handleAddRow,
    className: "artcloud-people-addMember"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Add Row', 'artcloud-blocks')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
    variant: "primary",
    type: "submit"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Save', 'artcloud-blocks'))));
};

/***/ }),

/***/ "./src/blocks/artcloud-peoples/AddSVGS.js":
/*!************************************************!*\
  !*** ./src/blocks/artcloud-peoples/AddSVGS.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SocialIcons: () => (/* binding */ SocialIcons)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

const SocialIcons = {
  twitter: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    width: "17.537",
    height: "17.922",
    viewBox: "0 0 17.537 17.922"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    id: "logo",
    d: "M10.437,7.589,16.965,0H15.418L9.75,6.589,5.222,0H0L6.847,9.964,0,17.922H1.547l5.986-6.959,4.781,6.959h5.222l-7.1-10.333ZM8.318,10.052,7.624,9.06,2.1,1.165H4.481L8.935,7.536l.694.992,5.79,8.282H13.043L8.318,10.052Z",
    fill: "#006845"
  })),
  facebook: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    width: "17.922",
    height: "17.922",
    viewBox: "0 0 17.922 17.922"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    id: "Subtraction_12",
    "data-name": "Subtraction 12",
    d: "M9.573,17.922H.99A.99.99,0,0,1,0,16.934V.989A.991.991,0,0,1,.988,0H16.933a.99.99,0,0,1,.989.989V16.933a.99.99,0,0,1-.988.989h-4.56V10.991H14.71l.35-2.713H12.374V6.551c0-.791.228-1.318,1.341-1.318h1.424V2.813a19.251,19.251,0,0,0-2.087-.106,3.48,3.48,0,0,0-2.514.92,3.628,3.628,0,0,0-.965,2.656v2H7.246v2.713H9.573v6.931Z",
    fill: "#006845"
  })),
  instagram: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    width: "17.922",
    height: "17.926",
    viewBox: "0 0 17.922 17.926"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    id: "Subtraction_13",
    "data-name": "Subtraction 13",
    d: "M8.983,17.926h0a52.049,52.049,0,0,1-6.043-.215A3.426,3.426,0,0,1,.3,15.1a16.182,16.182,0,0,1-.276-4.5c.013-.507.027-1.081.027-1.637,0-.736-.007-1.4-.013-1.989V6.933C0,3.777-.01,2.47,1.169,1.245A3.392,3.392,0,0,1,3.045.216,17.743,17.743,0,0,1,6.517,0C7.1,0,7.747.005,8.493.012l.321,0c.954.008,1.9.014,2.981.014h.1a16.612,16.612,0,0,1,2.613.079l.023,0a3.846,3.846,0,0,1,2.3,1.154A4.233,4.233,0,0,1,17.9,3.9c.023.28.024,9.83,0,10.117a4.336,4.336,0,0,1-.935,2.49,3.671,3.671,0,0,1-1.926,1.2A51.958,51.958,0,0,1,8.983,17.926Zm0-2.581c.227,0,.458,0,.681,0s.451,0,.675,0c2.11,0,4.072-.175,4.895-2.285a10.519,10.519,0,0,0,.348-3.66c0-.213,0-.434,0-.662,0-.255,0-.5,0-.717.012-2.195.02-3.645-1.11-4.774-1.032-1.031-2.4-1.113-4.073-1.113l-.659,0h0c-.244,0-.495,0-.754,0-.218,0-.439,0-.652,0s-.424,0-.633,0a9.34,9.34,0,0,0-3,.349A3.145,3.145,0,0,0,2.735,4.424a10.528,10.528,0,0,0-.348,3.671q0,.314,0,.651,0,.274,0,.544a11.615,11.615,0,0,0,.348,3.778A3.142,3.142,0,0,0,4.7,15a9.339,9.339,0,0,0,3,.349c.209,0,.424,0,.632,0h0C8.55,15.347,8.768,15.345,8.985,15.345Zm1.5-1.181c-.232,0-.465,0-.713-.005s-.516-.006-.781-.006c-5.257,0-5.408-.152-5.408-5.41,0-2.7.11-4.016.759-4.7s1.773-.708,4.058-.71h.119c.33,0,.641,0,.941-.006.323,0,.628-.006.912-.006a11.1,11.1,0,0,1,1.982.126,2.23,2.23,0,0,1,1.251.613c.89.932.953,3.02.756,7.348C14.24,13.961,12.605,14.164,10.481,14.164ZM8.986,5.358a3.388,3.388,0,1,0,3.387,3.388A3.392,3.392,0,0,0,8.986,5.358Zm3.522-.926a.792.792,0,1,0,.791.792A.793.793,0,0,0,12.508,4.432ZM8.986,10.946a2.106,2.106,0,0,1-1.636-.688,2.368,2.368,0,0,1,0-3.024,2.108,2.108,0,0,1,1.637-.687,2.107,2.107,0,0,1,1.636.688,2.368,2.368,0,0,1,0,3.024A2.108,2.108,0,0,1,8.986,10.946Z",
    fill: "#006845"
  })),
  linkedin: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    width: "17.922",
    height: "17.922",
    viewBox: "0 0 17.922 17.922"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("clipPath", {
    id: "clip-path"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    id: "Rectangle_871",
    "data-name": "Rectangle 871",
    width: "1.433",
    height: "9.358",
    fill: "#fff"
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
    id: "Group_828",
    "data-name": "Group 828",
    transform: "translate(-302 -548)"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    id: "Subtraction_19",
    "data-name": "Subtraction 19",
    d: "M16.933,0H.988A.989.989,0,0,0,0,.989V16.934a.989.989,0,0,0,.989.988H16.933a.989.989,0,0,0,.989-.989h0V.988A.989.989,0,0,0,16.933,0Zm0,0",
    transform: "translate(302 548)",
    fill: "#006845"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
    id: "Group_827",
    "data-name": "Group 827",
    transform: "translate(310 552)"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
    id: "Group_826",
    "data-name": "Group 826",
    "clip-path": "url(#clip-path)"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    id: "Path_285",
    "data-name": "Path 285",
    d: "M1.687,36A.686.686,0,0,0,1,36.684v5.808a.686.686,0,0,0,1.372,0V36.684A.686.686,0,0,0,1.687,36",
    transform: "translate(-0.94 -33.82)",
    fill: "#fff"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    id: "Path_286",
    "data-name": "Path 286",
    d: "M.053.948a.694.694,0,0,0,.063.119.717.717,0,0,0,.085.1.645.645,0,0,0,.1.085.719.719,0,0,0,.118.064.682.682,0,0,0,.129.039.666.666,0,0,0,.268,0A.69.69,0,0,0,.949,1.32a.719.719,0,0,0,.118-.064.62.62,0,0,0,.1-.085.69.69,0,0,0,.2-.485A.718.718,0,0,0,1.359.552.732.732,0,0,0,1.32.424.7.7,0,0,0,1.257.3.714.714,0,0,0,1.171.2a.654.654,0,0,0-.1-.085A.669.669,0,0,0,.949.053.692.692,0,0,0,.82.013.665.665,0,0,0,.686,0,.692.692,0,0,0,.2.2.714.714,0,0,0,.116.3.742.742,0,0,0,.053.424.732.732,0,0,0,.013.552a.682.682,0,0,0,0,.268A.716.716,0,0,0,.053.948",
    fill: "#fff"
  }))))),
  homesocial: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    width: "17.922",
    height: "17.922",
    viewBox: "0 0 17.922 17.922"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("clipPath", {
    id: "clip-path"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    id: "Rectangle_649",
    "data-name": "Rectangle 649",
    width: "10.319",
    height: "10.43",
    fill: "#fff"
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
    id: "Group_829",
    "data-name": "Group 829",
    transform: "translate(-276 -548)"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    id: "Subtraction_18",
    "data-name": "Subtraction 18",
    d: "M16.933,0H.988A.989.989,0,0,0,0,.989V16.934a.989.989,0,0,0,.989.988H16.933a.989.989,0,0,0,.989-.989h0V.988A.989.989,0,0,0,16.933,0Zm0,0",
    transform: "translate(276 548)",
    fill: "#006845"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
    id: "Group_741",
    "data-name": "Group 741",
    transform: "translate(280 552)"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
    id: "Group_740",
    "data-name": "Group 740",
    "clip-path": "url(#clip-path)"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    id: "Path_85",
    "data-name": "Path 85",
    d: "M10.2,5.028,5.467.13a.427.427,0,0,0-.615,0L2.952,2.1a.238.238,0,0,1-.409-.166V1.464a.427.427,0,0,0-.427-.427H1.528a.427.427,0,0,0-.427.427V3.841a.428.428,0,0,1-.12.3l-.86.89a.427.427,0,0,0,.307.724H.673A.427.427,0,0,1,1.1,6.18V10a.427.427,0,0,0,.427.427H8.791A.427.427,0,0,0,9.218,10V6.18a.427.427,0,0,1,.427-.427h.245a.427.427,0,0,0,.307-.724",
    transform: "translate(0 0)",
    fill: "#fff"
  })))))
};

/***/ }),

/***/ "./src/blocks/artcloud-peoples/BoardMember.js":
/*!****************************************************!*\
  !*** ./src/blocks/artcloud-peoples/BoardMember.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BoardMember: () => (/* binding */ BoardMember)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _AddSVGS__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./AddSVGS */ "./src/blocks/artcloud-peoples/AddSVGS.js");






const BoardMember = ({
  attributes,
  sortedMembers,
  formData,
  setAttributes
}) => {
  const [rows, setRows] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)([{
    0: "",
    1: "",
    2: "",
    3: ""
  }]);
  const {
    displayFeaturedImage,
    displayName,
    displayTitle,
    displayDesignation,
    displayPhone,
    categories,
    displayEmail,
    displayCity,
    displayProfileLink,
    displaySocialLink,
    displayHomeLink,
    displayRankNumber,
    selectedValue,
    displayVaralla,
    memberTitle,
    memberDesc
  } = attributes;
  const onChangeMemberTitle = value => {
    setAttributes({
      memberTitle: value
    });
  };
  const onChangeMemeberDesc = value => {
    setAttributes({
      memberDesc: value
    });
  };
  const categoryID = categories && categories.length > 0 ? categories && categories[0].id : null;
  const taxonomy = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    return select("core").getEntityRecords("taxonomy", "group", {
      include: [categoryID]
    });
  });
  const rank_info_db = taxonomy && taxonomy[0] && taxonomy[0].rank_information;
  const flatArray = formData.flatMap(item => {
    if (typeof item === "object" && !Array.isArray(item)) {
      return Object.values(item);
    } else {
      return item;
    }
  });

  // console.log(flatArray);

  const numberOfColumns = 4;
  const rank_info_form_data = {};
  for (let i = 0; i < flatArray.length; i += numberOfColumns) {
    const subArray = flatArray.slice(i, i + numberOfColumns);
    rank_info_form_data[i / numberOfColumns] = subArray;
  }
  let rank_infos = {};
  if (rank_info_db && rank_info_db !== 'a:0:{}' && rank_info_db !== 'a:1:{i:0;a:0:{}}') {
    function unserialize(data) {
      return data.match(/s:([0-9]+):"(.*?)";/g).map(function (s) {
        var m = s.match(/s:([0-9]+):"(.*?)";/);
        if (m) {
          if (m[2].startsWith("a:") || m[2].startsWith("O:")) {
            return JSON.parse(deserializeValue(m[2]));
          } else {
            return m[2];
          }
        } else {
          return s;
        }
      });
    }
    function deserializeValue(value) {
      var deserialized = unserialize(value);
      return deserialized.length === 1 ? deserialized[0] : deserialized;
    }
    const deserializedMetadata = unserialize(rank_info_db);

    // Convert the flat array to a JSON object
    for (let i = 0; i < deserializedMetadata.length; i += 4) {
      rank_infos[i / 4] = deserializedMetadata.slice(i, i + 4);
    }
  } else {
    console.warn("Taxonomy or rank_information is null.");
  }
  let rank_info = {};
  function empty(obj) {
    return Object.keys(obj).length === 0 && obj.constructor === Object;
  }
  if (!empty(rank_info_form_data)) {
    rank_info = rank_info_form_data;
  } else {
    rank_info = rank_infos;
  }
  // console.log(categories);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, categories && categories.length > 0 ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", {
    className: "people-block-title"
  }, categories && categories[0] ? categories[0].name : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Group Name", "artcloud-blocks")), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "people-block-desc"
  }, categories && categories[0] ? categories[0].description : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Group description not added", "artcloud-blocks")), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "row artcloud-row row-1"
  }, sortedMembers && sortedMembers.map((person, index) => {
    const featuredImage = person._embedded && person._embedded["wp:featuredmedia"] && person._embedded["wp:featuredmedia"].length > 0 && person._embedded["wp:featuredmedia"][0];
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(React.Fragment, {
      key: person.id
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: `col-${selectedValue || '12'} ${selectedValue === '4' || selectedValue === '3' ? 'vertical' : 'horizontal'}`,
      key: person.id,
      style: {
        order: Array.from({
          length: Math.max(rows.length, Object.keys(rank_info).length)
        }).map((_, index) => rank_info[index] && rank_info[index][2] == person.id && rank_info[index][0]).find(value => value !== false) || 1000000
      }
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: `artcloud-peoples-item ${person.id}`
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "artcloud-peoples-image"
    }, displayFeaturedImage && featuredImage && featuredImage.media_details && featuredImage.media_details.sizes && featuredImage.media_details.sizes.thumbnail && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
      src: featuredImage.media_details.sizes.thumbnail.source_url,
      alt: featuredImage.alt_text
    })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "artcloud-peoples-content"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h5", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
      href: displayProfileLink && (person.link ? person.link : "#")
    }, displayName && person.title && person.title.rendered)), displayDesignation && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, Array.from({
      length: Math.max(rows.length, Object.keys(rank_info).length)
    }).map((_, index) => rank_info[index] && rank_info[index][2] == person.id && rank_info[index][1])), displayTitle && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: "people_title"
    }, person.person_meta_fields.people_title), displayCity && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: "people_city"
    }, person.person_meta_fields.people_city), displayPhone && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: "people_phone"
    }, person.person_meta_fields.people_phone), displayEmail && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: "people_email"
    }, person.person_meta_fields.people_email), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "social-link"
    }, displayHomeLink && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
      className: "people_home",
      href: `https://${person.person_meta_fields.home}`
    }, _AddSVGS__WEBPACK_IMPORTED_MODULE_5__.SocialIcons.homesocial), displaySocialLink && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
      className: "people_twitter",
      href: `https://${person.person_meta_fields.twitter}`
    }, _AddSVGS__WEBPACK_IMPORTED_MODULE_5__.SocialIcons.twitter), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
      className: "people_facebook",
      href: `https://${person.person_meta_fields.facebook}`
    }, _AddSVGS__WEBPACK_IMPORTED_MODULE_5__.SocialIcons.facebook), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
      className: "people_linkedin",
      href: `https://${person.person_meta_fields.linkedin}`
    }, _AddSVGS__WEBPACK_IMPORTED_MODULE_5__.SocialIcons.linkedin), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
      className: "people_instagram",
      href: `https://${person.person_meta_fields.instagram}`
    }, _AddSVGS__WEBPACK_IMPORTED_MODULE_5__.SocialIcons.instagram)), displayRankNumber && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h6", {
      className: "people_rank"
    }, person.person_meta_fields.rank_number)), displayVaralla && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "artcloud-peoples-name"
    }, Array.from({
      length: Math.max(rows.length, Object.keys(rank_info).length)
    }).map((_, index) => rank_info[index] && rank_info[index][2] == person.id && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h6", null, "Varalla "), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, wp.data.select('core').getEntityRecord('postType', 'person', rank_info[index][3])?.title?.rendered || ''))))))));
  }))) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Select a category first', 'artcloud-blocks'), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("hr", null)));
};

/***/ }),

/***/ "./src/blocks/artcloud-peoples/EditUserForm.js":
/*!*****************************************************!*\
  !*** ./src/blocks/artcloud-peoples/EditUserForm.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);



const EditUserForm = ({
  postId,
  closeEditModal
}) => {
  const parentDiv = jQuery(`.artcloud-peoples-item.${postId}`);
  const [formData, setFormData] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)({
    people_email: parentDiv.find('.people_email').text(),
    people_title: parentDiv.find('.people_title').text(),
    people_city: parentDiv.find('.people_city').text(),
    people_phone: parentDiv.find('.people_phone').text(),
    linkedin: parentDiv.find('a.people_linkedin').attr('href'),
    instagram: parentDiv.find('a.people_instagram').attr('href'),
    facebook: parentDiv.find('a.people_facebook').attr('href'),
    home: parentDiv.find('a.people_home').attr('href'),
    twitter: parentDiv.find('a.people_twitter').attr('href'),
    rank_number: parentDiv.find('.people_rank').text()
  });
  const handleChange = event => {
    const {
      name,
      value
    } = event.target;
    setFormData(prevFormData => ({
      ...prevFormData,
      [name]: value
    }));
  };
  const savePeopleData = event => {
    event.preventDefault();
    const data = {
      post_id: postId,
      _people_email: formData.people_email,
      _people_title: formData.people_title,
      _people_city: formData.people_city,
      _people_phone: formData.people_phone,
      _linkedin_url: formData.linkedin,
      _instagram_url: formData.instagram,
      _facebook_url: formData.facebook,
      _home_url: formData.home,
      _twitter_url: formData.twitter,
      _rank_number: formData.rank_number
    };
    wp.ajax.post({
      url: wp.ajax.settings.url,
      action: 'update_person_data',
      data: data,
      dataType: 'json',
      success: function (response) {
        updateFormDataInDOM(postId, formData);
        closeEditModal();
      }
    });
  };
  function updateFormDataInDOM(postId, formData) {
    const parentDiv = jQuery(`.artcloud-peoples-item.${postId}`);
    const updateTextData = {
      'p.people_title': formData.people_title,
      'p.people_city': formData.people_city,
      'p.people_phone': formData.people_phone,
      'p.people_email': formData.people_email,
      'h6.people_rank': formData.rank_number
    };
    const updateHrefData = {
      'a.people_linkedin': formData.linkedin,
      'a.people_instagram': formData.instagram,
      'a.people_facebook': formData.facebook,
      'a.people_home': formData.home,
      'a.people_twitter': formData.twitter
    };

    // Update text content
    for (const selector in updateTextData) {
      parentDiv.find(selector).text(updateTextData[selector]);
    }

    // Update href attribute
    for (const selector in updateHrefData) {
      parentDiv.find(selector).attr('href', updateHrefData[selector]);
    }
  }
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    ...(0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.useBlockProps)()
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "artcloud-row"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("form", {
    action: "",
    method: "post",
    onSubmit: savePeopleData
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "col-12"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
    htmlFor: "people_email"
  }, "Email"), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
    type: "email",
    name: "people_email",
    id: "people_email",
    value: formData.people_email,
    onChange: handleChange
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "col-12"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
    htmlFor: "people_title"
  }, "Title"), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
    type: "text",
    name: "people_title",
    id: "people_title",
    value: formData.people_title,
    onChange: handleChange
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "col-12"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
    htmlFor: "people_city"
  }, "City"), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
    type: "text",
    name: "people_city",
    id: "people_city",
    value: formData.people_city,
    onChange: handleChange
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "col-12"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
    htmlFor: "people_phone"
  }, "Phone"), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
    type: "tel",
    name: "people_phone",
    id: "people_phone",
    value: formData.people_phone,
    onChange: handleChange
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "col-12"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
    htmlFor: "linkedin"
  }, "Linkedin"), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
    type: "text",
    name: "linkedin",
    id: "linkedin",
    value: formData.linkedin,
    onChange: handleChange
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "col-12"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
    htmlFor: "instagram"
  }, "Instagram"), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
    type: "text",
    name: "instagram",
    id: "instagram",
    value: formData.instagram,
    onChange: handleChange
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "col-12"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
    htmlFor: "facebook"
  }, "Facebook"), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
    type: "text",
    name: "facebook",
    id: "facebook",
    value: formData.facebook,
    onChange: handleChange
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "col-12"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
    htmlFor: "home"
  }, "Home"), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
    type: "text",
    name: "home",
    id: "home",
    value: formData.home,
    onChange: handleChange
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "col-12"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
    htmlFor: "twitter"
  }, "Twitter"), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
    type: "text",
    name: "twitter",
    id: "twitter",
    value: formData.twitter,
    onChange: handleChange
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "col-12"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
    htmlFor: "rank_number"
  }, "Rank"), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
    type: "number",
    name: "rank_number",
    id: "rank_number",
    value: formData.rank_number,
    onChange: handleChange
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    className: "components-button is-primary",
    type: "submit"
  }, "Save"))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EditUserForm);

/***/ }),

/***/ "./src/blocks/artcloud-peoples/NormalPeople.js":
/*!*****************************************************!*\
  !*** ./src/blocks/artcloud-peoples/NormalPeople.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ NormalPeople)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _AddSVGS__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./AddSVGS */ "./src/blocks/artcloud-peoples/AddSVGS.js");




function NormalPeople({
  attributes,
  sortedItems,
  setAttributes
}) {
  const {
    peopleTitle,
    peopleDesc,
    displayFeaturedImage,
    displayName,
    displayTitle,
    displayPhone,
    categories,
    selectedValue,
    displayEmail,
    displayCity,
    displayProfileLink,
    displaySocialLink,
    displayHomeLink,
    displayRankNumber,
    selectedTitles
  } = attributes;
  const onChangePeopleTitle = value => {
    setAttributes({
      peopleTitle: value
    });
  };
  const onChangePeopleDesc = value => {
    setAttributes({
      peopleDesc: value
    });
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, categories && categories.length > 0 ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, "  ", (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.RichText, {
    tagName: "h3",
    onChange: onChangePeopleTitle,
    value: peopleTitle,
    className: "people-block-title",
    placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Enter People Title', 'artcloud-blocks'),
    allowedFormats: []
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.RichText, {
    tagName: "p",
    value: peopleDesc,
    onChange: onChangePeopleDesc,
    className: "people-block-desc",
    placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Enter people description', 'artcloud-blocks'),
    allowedFormats: []
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "row artcloud-row"
  }, sortedItems && sortedItems.map(post => {
    const featuredImage = post._embedded && post._embedded['wp:featuredmedia'] && post._embedded['wp:featuredmedia'].length > 0 && post._embedded['wp:featuredmedia'][0];
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: `col-${selectedValue || '12'} ${selectedValue === '4' || selectedValue === '3' ? 'vertical' : 'horizontal'}`,
      key: post.id
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "artcloud-peoples-item"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "artcloud-peoples-image"
    }, displayFeaturedImage && featuredImage && featuredImage.media_details && featuredImage.media_details.sizes && featuredImage.media_details.sizes.thumbnail && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
      src: featuredImage.media_details.sizes.thumbnail.source_url,
      alt: featuredImage.alt_text
    })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "artcloud-peoples-content"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h5", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
      href: displayProfileLink && (post.link ? post.link : '#')
    }, displayName && post.title && post.title.rendered)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, displayTitle && post.person_meta_fields.people_title), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, displayCity && post.person_meta_fields.people_city), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, displayPhone && post.person_meta_fields.people_phone), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, displayEmail && post.person_meta_fields.people_email), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "social-link"
    }, displayHomeLink && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
      href: `https://${post.person_meta_fields.home}`
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      xmlnsXlink: "http://www.w3.org/1999/xlink",
      width: "17.922",
      height: "17.922",
      viewBox: "0 0 17.922 17.922"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("clipPath", {
      id: "clip-path"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      id: "Rectangle_649",
      "data-name": "Rectangle 649",
      width: "10.319",
      height: "10.43",
      fill: "#fff"
    }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
      id: "Group_829",
      "data-name": "Group 829",
      transform: "translate(-276 -548)"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      id: "Subtraction_18",
      "data-name": "Subtraction 18",
      d: "M16.933,0H.988A.989.989,0,0,0,0,.989V16.934a.989.989,0,0,0,.989.988H16.933a.989.989,0,0,0,.989-.989h0V.988A.989.989,0,0,0,16.933,0Zm0,0",
      transform: "translate(276 548)",
      fill: "var(--wp--preset--color--primary)"
    }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
      id: "Group_741",
      "data-name": "Group 741",
      transform: "translate(280 552)"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
      id: "Group_740",
      "data-name": "Group 740",
      "clip-path": "url(#clip-path)"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      id: "Path_85",
      "data-name": "Path 85",
      d: "M10.2,5.028,5.467.13a.427.427,0,0,0-.615,0L2.952,2.1a.238.238,0,0,1-.409-.166V1.464a.427.427,0,0,0-.427-.427H1.528a.427.427,0,0,0-.427.427V3.841a.428.428,0,0,1-.12.3l-.86.89a.427.427,0,0,0,.307.724H.673A.427.427,0,0,1,1.1,6.18V10a.427.427,0,0,0,.427.427H8.791A.427.427,0,0,0,9.218,10V6.18a.427.427,0,0,1,.427-.427h.245a.427.427,0,0,0,.307-.724",
      transform: "translate(0 0)",
      fill: "#fff"
    })))))), displaySocialLink && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
      href: `https://${post.person_meta_fields.twitter}`
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      xmlns: socialSVGS.twitter.xmlns,
      width: socialSVGS.twitter.width,
      height: socialSVGS.twitter.height,
      viewBox: socialSVGS.twitter.viewBox
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      d: socialSVGS.twitter.path,
      fill: socialSVGS.twitter.fill
    }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
      href: `https://${post.person_meta_fields.facebook}`
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      xmlns: socialSVGS.facebook.xmlns,
      width: socialSVGS.facebook.width,
      height: socialSVGS.facebook.height,
      viewBox: socialSVGS.facebook.viewBox
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      d: socialSVGS.facebook.path,
      fill: socialSVGS.facebook.fill
    }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
      href: `https://${post.person_meta_fields.linkedin}`
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      xmlnsXlink: "http://www.w3.org/1999/xlink",
      width: "17.922",
      height: "17.922",
      viewBox: "0 0 17.922 17.922"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("clipPath", {
      id: "clip-path"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
      id: "Rectangle_871",
      "data-name": "Rectangle 871",
      width: "1.433",
      height: "9.358",
      fill: "#fff"
    }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
      id: "Group_828",
      "data-name": "Group 828",
      transform: "translate(-302 -548)"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      id: "Subtraction_19",
      "data-name": "Subtraction 19",
      d: "M16.933,0H.988A.989.989,0,0,0,0,.989V16.934a.989.989,0,0,0,.989.988H16.933a.989.989,0,0,0,.989-.989h0V.988A.989.989,0,0,0,16.933,0Zm0,0",
      transform: "translate(302 548)",
      fill: "var(--wp--preset--color--primary)"
    }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
      id: "Group_827",
      "data-name": "Group 827",
      transform: "translate(310 552)"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
      id: "Group_826",
      "data-name": "Group 826",
      "clip-path": "url(#clip-path)"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      id: "Path_285",
      "data-name": "Path 285",
      d: "M1.687,36A.686.686,0,0,0,1,36.684v5.808a.686.686,0,0,0,1.372,0V36.684A.686.686,0,0,0,1.687,36",
      transform: "translate(-0.94 -33.82)",
      fill: "#fff"
    }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      id: "Path_286",
      "data-name": "Path 286",
      d: "M.053.948a.694.694,0,0,0,.063.119.717.717,0,0,0,.085.1.645.645,0,0,0,.1.085.719.719,0,0,0,.118.064.682.682,0,0,0,.129.039.666.666,0,0,0,.268,0A.69.69,0,0,0,.949,1.32a.719.719,0,0,0,.118-.064.62.62,0,0,0,.1-.085.69.69,0,0,0,.2-.485A.718.718,0,0,0,1.359.552.732.732,0,0,0,1.32.424.7.7,0,0,0,1.257.3.714.714,0,0,0,1.171.2a.654.654,0,0,0-.1-.085A.669.669,0,0,0,.949.053.692.692,0,0,0,.82.013.665.665,0,0,0,.686,0,.692.692,0,0,0,.2.2.714.714,0,0,0,.116.3.742.742,0,0,0,.053.424.732.732,0,0,0,.013.552a.682.682,0,0,0,0,.268A.716.716,0,0,0,.053.948",
      fill: "#fff"
    })))))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
      href: `https://${post.person_meta_fields.instagram}`
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
      xmlns: socialSVGS.instagram.xmlns,
      width: socialSVGS.instagram.width,
      height: socialSVGS.instagram.height,
      viewBox: socialSVGS.instagram.viewBox
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
      d: socialSVGS.instagram.path,
      fill: socialSVGS.instagram.fill
    })))), displayRankNumber && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h6", null, post.person_meta_fields.rank_number)))));
  }))) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Select a category first', 'artcloud-blocks'), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("hr", null)));
}

/***/ }),

/***/ "./src/blocks/artcloud-peoples/edit.js":
/*!*********************************************!*\
  !*** ./src/blocks/artcloud-peoples/edit.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Edit)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _AddLabelForm__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./AddLabelForm */ "./src/blocks/artcloud-peoples/AddLabelForm.js");
/* harmony import */ var _BoardMember__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./BoardMember */ "./src/blocks/artcloud-peoples/BoardMember.js");
/* harmony import */ var _NormalPeople__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./NormalPeople */ "./src/blocks/artcloud-peoples/NormalPeople.js");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _editor_scss__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./editor.scss */ "./src/blocks/artcloud-peoples/editor.scss");
/* harmony import */ var _EditUserForm__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./EditUserForm */ "./src/blocks/artcloud-peoples/EditUserForm.js");












function Edit({
  attributes,
  setAttributes
}) {
  const {
    checkedCategories,
    displayVaralla,
    displayDropdown,
    displaySearchOption,
    postType,
    numberOfPosts,
    displayFeaturedImage,
    displayName,
    displayTitle,
    displayDesignation,
    displayPhone,
    categories,
    displayEmail,
    displayCity,
    displayProfileLink,
    displaySocialLink,
    displayHomeLink,
    displayRankNumber,
    selectedTitles
  } = attributes;
  const [searchTerm, setSearchTerm] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useState)('');
  const [filteredPeople, setFilteredPeople] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useState)([]);
  const [delSearchTerm, setDelSearchTerm] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useState)('');
  const [filteredMembers, setFilteredMembers] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useState)([]);
  //Add Label Modal
  const [isOpen, setOpen] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useState)(false);
  const openModal = () => setOpen(true);
  const closeModal = () => setOpen(false);
  const [selectedPostId, setSelectedPostId] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useState)(null);
  //Edit User Modal
  const [isEditOpen, setEditOpen] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useState)(false);
  const openEditModal = postId => {
    setSelectedPostId(postId);
    setEditOpen(true);
  };
  const closeEditModal = () => setEditOpen(false);
  const onHandleValueChange = value => {
    setAttributes({
      selectedValue: value
    });
  };
  const [formData, setFormData] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useState)([]);
  const [formEditData, setEditFormData] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useState)([]);
  const handleSubmit = data => {
    setFormData(data);
  };
  const handleEditSubmit = data => {
    setEditFormData(data);
  };
  const onDisplayFeaturedImageChange = value => {
    setAttributes({
      displayFeaturedImage: value
    });
  };
  const onDisplayNameChange = value => {
    setAttributes({
      displayName: value
    });
  };
  const onDisplayTitleChange = value => {
    setAttributes({
      displayTitle: value
    });
  };
  const onDisplayDesignationChange = value => {
    setAttributes({
      displayDesignation: value
    });
  };
  const onDisplayvarallaChange = value => {
    setAttributes({
      displayVaralla: value
    });
  };
  const onDisplayPhoneChange = value => {
    setAttributes({
      displayPhone: value
    });
  };
  const onDisplayEmailChange = value => {
    setAttributes({
      displayEmail: value
    });
  };
  const onDisplayCityChange = value => {
    setAttributes({
      displayCity: value
    });
  };
  const onDisplayProfileLinkChange = value => {
    setAttributes({
      displayProfileLink: value
    });
  };
  const onDisplaySocialLinkChange = value => {
    setAttributes({
      displaySocialLink: value
    });
  };
  const onDisplayHomeLinkChange = value => {
    setAttributes({
      displayHomeLink: value
    });
  };
  const onDisplayRankNumberChange = value => {
    setAttributes({
      displayRankNumber: value
    });
  };
  const onChangeSearchOption = value => {
    setAttributes({
      displaySearchOption: value
    });
  };
  const onChangeDropdownDisplay = value => {
    setAttributes({
      displayDropdown: value
    });
  };
  const onChangeTabView = value => {
    setAttributes({
      displayTabView: value
    });
  };
  const [sortedMembers, setSortedMembers] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useState)([]);
  const postTypes = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.useSelect)(select => {
    return select('core').getPostTypes({
      per_page: -1
    });
  }, []);
  const catIds = categories && categories.length > 0 ? categories.map(cat => cat.id) : [];
  const postTypeTaxonomy = postTypes && postTypes.length ? postTypes.find(type => type.slug === postType)?.taxonomies[0] || 'category' : '';
  const items = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.useSelect)(select => {
    if (selectedTitles && selectedTitles.length > 0) {
      const titleArgs = {
        per_page: -1,
        _embed: true
      };
      return select('core').getEntityRecords('postType', postType, titleArgs);
    }
    const otherQueryArgs = {
      per_page: numberOfPosts,
      _embed: true
    };
    postType === 'post' ? otherQueryArgs.categories = catIds : otherQueryArgs[postTypeTaxonomy] = catIds;
    return select('core').getEntityRecords('postType', postType, otherQueryArgs);
  }, [postType, catIds, postTypeTaxonomy, numberOfPosts, selectedTitles]);
  //For Post
  const allCats = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.useSelect)(select => {
    return postTypeTaxonomy ? select('core').getEntityRecords('taxonomy', postTypeTaxonomy, {
      per_page: -1
    }) : [];
  }, [postTypeTaxonomy]);
  const catSuggestions = {};
  //For other post type
  if (allCats) {
    for (let i = 0; i < allCats.length; i++) {
      const cat = allCats[i];
      catSuggestions[cat.name] = cat;
    }
  }
  const onCategoryChange = values => {
    const hasNoSuggestions = values.some(value => typeof value === 'string' && !catSuggestions[value]);
    if (hasNoSuggestions) return;
    const updatesCats = values.map(token => {
      return typeof token === 'string' ? catSuggestions[token] : token;
    });
    setAttributes({
      categories: updatesCats
    });
  };
  const onSelectTitles = selected => {
    const titleObjs = selected.map(title => {
      const foundpost = allPostTitles.find(post => post.title === title);
      return foundpost ? foundpost : {
        id: null,
        title: title
      };
    });
    setAttributes({
      selectedTitles: titleObjs
    });
  };
  const filteredItems = (items || []).filter(item => !selectedTitles || selectedTitles.length === 0 || selectedTitles.some(titleObj => titleObj.title === item.title.rendered));
  const allPostTitles = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.useSelect)(select => {
    const baseArgs = {
      per_page: -1
    };
    if (catIds && catIds.length > 0) {
      baseArgs['categories'] = catIds;
    }
    const allPosts = select('core').getEntityRecords('postType', postType, baseArgs);
    return allPosts ? allPosts.map(post => ({
      id: post.id,
      title: post.title.rendered
    })) : [];
  }, [catIds]);
  function sortPostsBySelectedTitles(posts, selectedTitles) {
    const sortedPosts = [];
    selectedTitles.forEach(titleObj => {
      const matchingPost = posts.find(post => titleObj.title === post.title.rendered);
      if (matchingPost) {
        sortedPosts.push(matchingPost);
      }
    });
    posts.forEach(post => {
      if (!selectedTitles.some(titleObj => titleObj.title === post.title.rendered)) {
        sortedPosts.push(post);
      }
    });
    return sortedPosts;
  }
  const filteredPosts = sortPostsBySelectedTitles(filteredItems, selectedTitles);
  const handleCheckboxChange = categoryId => {
    const updatedCheckedCategories = checkedCategories.includes(categoryId);
    setAttributes({
      checkedCategories: updatedCheckedCategories ? checkedCategories.filter(id => id !== categoryId) : [...checkedCategories, categoryId]
    });
  };
  const addPersons = personID => {
    const categoryID = categories.length > 0 ? categories[0].id : null;
    const categoryName = categories.length > 0 ? categories[0].value : null;
    const taxonomySlug = 'group';
    if (!categoryID) {
      console.error('Please specify a category ID before adding the person.');
      return;
    }
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_9___default()({
      path: `/wp/v2/person/${personID}`,
      method: 'GET'
    }).then(existingPersonData => {
      const existingCategories = existingPersonData[taxonomySlug] || [];
      if (!existingCategories.includes(categoryID)) {
        existingCategories.push(categoryID);
        _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_9___default()({
          path: `/wp/v2/person/${personID}`,
          method: 'PATCH',
          data: {
            [taxonomySlug]: existingCategories
          }
        }).then(response => {
          const updatedCategories = [...categories, {
            id: categoryID,
            value: categoryName
          }];
          setAttributes({
            categories: updatedCategories
          });
        }).catch(error => {
          console.error('Error adding person to category:', error);
        });
      } else {
        console.log(`Person ${personID} is already in category ${categoryID}`);
      }
    }).catch(error => {
      console.error('Error fetching person data:', error);
    });
  };
  const deletePerson = personID => {
    const categoryID = categories.length > 0 ? categories[0].id : null;
    const categoryName = categories.length > 0 ? categories[0].value : null;
    const taxonomySlug = 'group';
    wp.apiFetch({
      path: `/wp/v2/person/${personID}`,
      method: 'PATCH',
      data: {
        [taxonomySlug]: []
      }
    }).then(response => {
      // console.log(`Person ${personID} removed from all categories`, response);
      const updatedCategories = [...categories, {
        id: categoryID,
        value: categoryName
      }];
      setAttributes({
        categories: updatedCategories
      });
    }).catch(error => {
      console.error('Error deleting person from categories:', error);
    });
  };
  const uniqueCategories = categories && categories.filter((category, index, self) => index === self.findIndex(c => c.id === category.id));
  const logNestedCategories = (parentCategoryId, depth = 0) => {
    const childCategories = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.select)('core').getEntityRecords('taxonomy', 'group', {
      parent: parentCategoryId,
      hide_empty: true,
      per_page: -1
    });
    if (!childCategories || childCategories.length === 0) {
      return [];
    }
    const nestedCategories = [];
    childCategories.forEach(category => {
      nestedCategories.push({
        ...category,
        depth
      });
      const nestedChildren = logNestedCategories(category.id, depth + 1);
      nestedCategories.push(...nestedChildren);
    });
    return nestedCategories;
  };
  const childCategories = uniqueCategories && uniqueCategories[0]?.id ? logNestedCategories(uniqueCategories[0].id) : [];
  const allChildIds = childCategories.map(category => category.id);
  // const sortedMembers = filteredPosts;
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    let newSortedMembers = checkedCategories.length > 0 ? filteredPosts.filter(post => post.group.some(groupId => checkedCategories.includes(groupId))) : filteredPosts;
    if (newSortedMembers.length === 0) {
      newSortedMembers = filteredPosts;
    }
    setSortedMembers(newSortedMembers);
  }, [checkedCategories, filteredPosts]);
  const remainingPeoples = allPostTitles.filter(post => !sortedMembers.some(member => member.id === post.id));
  //Search People
  const handleSearchChange = e => {
    setSearchTerm(e.target.value);
  };
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    if (searchTerm.trim() === '') {
      setFilteredPeople(remainingPeoples);
    } else {
      const filtered = remainingPeoples.filter(post => post.title.toLowerCase().includes(searchTerm.toLowerCase()));
      setFilteredPeople(filtered);
    }
  }, [searchTerm, remainingPeoples]);

  // Function to handle delete search input change
  const handleDelSearchChange = e => {
    setDelSearchTerm(e.target.value);
  };

  // Function to filter members based on delete search term
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    if (delSearchTerm.trim() === '') {
      // If delete search term is empty, show all members
      setFilteredMembers(sortedMembers);
    } else {
      // Filter members based on delete search term
      const filtered = sortedMembers.filter(post => post.title.rendered.toLowerCase().includes(delSearchTerm.toLowerCase()));
      setFilteredMembers(filtered);
    }
  }, [delSearchTerm, sortedMembers]);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    ...(0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.useBlockProps)()
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, isOpen && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Modal, {
    title: "Add Person Level",
    onRequestClose: closeModal
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_AddLabelForm__WEBPACK_IMPORTED_MODULE_6__.AddLabelForm, {
    closeModal: closeModal,
    attributes: attributes,
    sortedMembers: sortedMembers,
    allPostTitles: allPostTitles,
    handleSubmit: handleSubmit
  })), isEditOpen && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Modal, {
    title: "Edit People",
    onRequestClose: closeEditModal
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_EditUserForm__WEBPACK_IMPORTED_MODULE_11__["default"], {
    attributes: attributes,
    postId: selectedPostId,
    closeEditModal: closeEditModal,
    sortedMembers: sortedMembers,
    setSortedMembers: setSortedMembers
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.InspectorControls, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelBody, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.QueryControls, {
    categorySuggestions: catSuggestions,
    selectedCategories: uniqueCategories,
    onCategoryChange: onCategoryChange
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.SelectControl, {
    onChange: onHandleValueChange,
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('No of Columns', 'artcloud-blocks')
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("option", {
    value: "6"
  }, "Valitse"), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("option", {
    value: "12"
  }, "1"), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("option", {
    value: "6"
  }, "2"), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("option", {
    value: "4"
  }, "3"), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("option", {
    value: "3"
  }, "4")), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
    label: displayDropdown ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Dropdown View', 'artcloud-blocks') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Tab View', 'artcloud-blocks'),
    help: displayDropdown ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Dropdown View', 'artcloud-blocks') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Tab View', 'artcloud-blocks'),
    checked: displayDropdown,
    onChange: onChangeDropdownDisplay
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.CheckboxControl, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Display Search Option', 'artcloud-blocks'),
    checked: displaySearchOption,
    onChange: onChangeSearchOption
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelBody, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Add/Remove People', 'artcloud-blocks'),
    initialOpen: false
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
    className: "components-form-token-field__label"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Add People to Group', 'artcloud-blocks')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("strong", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Search People', 'artcloud-blocks'))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
    type: "text",
    name: "addSearchPeople",
    id: "addSearchPeople",
    value: searchTerm,
    onChange: handleSearchChange
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("strong", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Total People', 'artcloud-blocks'), ": ", filteredPeople.length)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.__experimentalScrollable, {
    style: {
      maxHeight: 200
    }
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    style: {
      height: 500
    }
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("ul", null, filteredPeople.map(post => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("li", {
    key: post.id,
    className: "artcloud-peopleAdd"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, post.title), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    href: "#",
    className: "artcloud-people-add",
    onClick: () => addPersons(post.id)
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "dashicons dashicons-plus-alt"
  })))))))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("hr", null), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
    className: "components-form-token-field__label"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('People Added to Group', 'artcloud-blocks')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("strong", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Search People', 'artcloud-blocks'))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
    type: "text",
    name: "delSearchPeople",
    id: "delSearchPeople",
    value: delSearchTerm,
    onChange: handleDelSearchChange
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("strong", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Total People', 'artcloud-blocks'), ": ", filteredMembers.length)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.__experimentalScrollable, {
    style: {
      maxHeight: 200
    }
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    style: {
      height: 500
    }
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("ul", null, filteredMembers.map(post => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("li", {
    key: post.id,
    className: "artcloud-peopleDelete"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, post.title.rendered), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    href: "#",
    className: "artcloud-people-delete",
    onClick: () => deletePerson(post.id)
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    class: "dashicons dashicons-trash"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    href: "#",
    className: "artcloud-people-edit",
    onClick: () => openEditModal(post.id)
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    class: "dashicons dashicons-edit-page"
  }))))))))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelBody, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Show/Hide Information', 'artcloud-blocks'),
    initialOpen: false
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.CheckboxControl, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Profile Image', 'artcloud-blocks'),
    checked: displayFeaturedImage,
    onChange: onDisplayFeaturedImageChange
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.CheckboxControl, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Full Name', 'artcloud-blocks'),
    checked: displayName,
    onChange: onDisplayNameChange
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.CheckboxControl, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Designation', 'artcloud-blocks'),
    checked: displayDesignation,
    onChange: onDisplayDesignationChange
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.CheckboxControl, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Varalla', 'artcloud-blocks'),
    checked: displayVaralla,
    onChange: onDisplayvarallaChange
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.CheckboxControl, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Title', 'artcloud-blocks'),
    checked: displayTitle,
    onChange: onDisplayTitleChange
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.CheckboxControl, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Phone', 'artcloud-blocks'),
    checked: displayPhone,
    onChange: onDisplayPhoneChange
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.CheckboxControl, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Email', 'artcloud-blocks'),
    checked: displayEmail,
    onChange: onDisplayEmailChange
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.CheckboxControl, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Profile Link', 'artcloud-blocks'),
    checked: displayProfileLink,
    onChange: onDisplayProfileLinkChange
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.CheckboxControl, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Home Link', 'artcloud-blocks'),
    checked: displayHomeLink,
    onChange: onDisplayHomeLinkChange
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.CheckboxControl, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Social Link', 'artcloud-blocks'),
    checked: displaySocialLink,
    onChange: onDisplaySocialLinkChange
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.CheckboxControl, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('City', 'artcloud-blocks'),
    checked: displayCity,
    onChange: onDisplayCityChange
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.CheckboxControl, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Rank Number', 'artcloud-blocks'),
    checked: displayRankNumber,
    onChange: onDisplayRankNumberChange
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelBody, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Add New Level', 'artcloud-blocks'),
    initialOpen: false
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
    variant: "secondary",
    onClick: openModal
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Add Level', 'artcloud-blocks'))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelBody, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Sub Groups', 'artcloud-blocks'),
    initialOpen: false
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.__experimentalScrollable, {
    style: {
      maxHeight: 200
    }
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("hr", null), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
    className: "components-form-token-field__label"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('All Subgroups', 'artcloud-blocks')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    style: {
      height: 500
    }
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("ul", null, childCategories.length > 0 ? childCategories.map(category => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("li", {
    key: category.id
  }, `${'\u00A0\u00A0\u00A0\u00A0\u00A0\u00A0'.repeat(category.depth)}`, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
    type: "checkbox",
    id: category.id,
    defaultChecked: checkedCategories.includes(category.id),
    onChange: () => handleCheckboxChange(category.id)
  }), `${category.name}`)) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("li", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('No Subgroups', 'artcloud-blocks')))))))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_BoardMember__WEBPACK_IMPORTED_MODULE_7__.BoardMember, {
    attributes: attributes,
    sortedMembers: sortedMembers,
    formData: formData,
    formEditData: formEditData
  }));
}

/***/ }),

/***/ "./src/blocks/artcloud-peoples/index.js":
/*!**********************************************!*\
  !*** ./src/blocks/artcloud-peoples/index.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./style.scss */ "./src/blocks/artcloud-peoples/style.scss");
/* harmony import */ var _editor_scss__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./editor.scss */ "./src/blocks/artcloud-peoples/editor.scss");
/* harmony import */ var _edit__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./edit */ "./src/blocks/artcloud-peoples/edit.js");
/* harmony import */ var _save__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./save */ "./src/blocks/artcloud-peoples/save.js");
/* harmony import */ var _block_json__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./block.json */ "./src/blocks/artcloud-peoples/block.json");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__);







(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__.registerBlockType)(_block_json__WEBPACK_IMPORTED_MODULE_5__.name, {
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__.__)('Artcloud People Block', 'artcloud-blocks'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__.__)('Show peoples grid with their details.', 'artcloud-blocks'),
  icon: {
    src: 'groups',
    background: 'var(--wp--preset--color--primary)',
    foreground: 'var(--wp--preset--color--white)'
  },
  edit: _edit__WEBPACK_IMPORTED_MODULE_3__["default"],
  save: _save__WEBPACK_IMPORTED_MODULE_4__["default"]
});

/***/ }),

/***/ "./src/blocks/artcloud-peoples/save.js":
/*!*********************************************!*\
  !*** ./src/blocks/artcloud-peoples/save.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ save)
/* harmony export */ });
function save() {
  return null;
}

/***/ }),

/***/ "./src/blocks/artcloud-peoples/editor.scss":
/*!*************************************************!*\
  !*** ./src/blocks/artcloud-peoples/editor.scss ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./src/blocks/artcloud-peoples/style.scss":
/*!************************************************!*\
  !*** ./src/blocks/artcloud-peoples/style.scss ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "react":
/*!************************!*\
  !*** external "React" ***!
  \************************/
/***/ ((module) => {

module.exports = window["React"];

/***/ }),

/***/ "@wordpress/api-fetch":
/*!**********************************!*\
  !*** external ["wp","apiFetch"] ***!
  \**********************************/
/***/ ((module) => {

module.exports = window["wp"]["apiFetch"];

/***/ }),

/***/ "@wordpress/block-editor":
/*!*************************************!*\
  !*** external ["wp","blockEditor"] ***!
  \*************************************/
/***/ ((module) => {

module.exports = window["wp"]["blockEditor"];

/***/ }),

/***/ "@wordpress/blocks":
/*!********************************!*\
  !*** external ["wp","blocks"] ***!
  \********************************/
/***/ ((module) => {

module.exports = window["wp"]["blocks"];

/***/ }),

/***/ "@wordpress/components":
/*!************************************!*\
  !*** external ["wp","components"] ***!
  \************************************/
/***/ ((module) => {

module.exports = window["wp"]["components"];

/***/ }),

/***/ "@wordpress/data":
/*!******************************!*\
  !*** external ["wp","data"] ***!
  \******************************/
/***/ ((module) => {

module.exports = window["wp"]["data"];

/***/ }),

/***/ "@wordpress/element":
/*!*********************************!*\
  !*** external ["wp","element"] ***!
  \*********************************/
/***/ ((module) => {

module.exports = window["wp"]["element"];

/***/ }),

/***/ "@wordpress/i18n":
/*!******************************!*\
  !*** external ["wp","i18n"] ***!
  \******************************/
/***/ ((module) => {

module.exports = window["wp"]["i18n"];

/***/ }),

/***/ "./src/blocks/artcloud-peoples/block.json":
/*!************************************************!*\
  !*** ./src/blocks/artcloud-peoples/block.json ***!
  \************************************************/
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$schema":"https://schemas.wp.org/trunk/block.json","apiVersion":3,"name":"artcloud-blocks/artcloud-peoples","version":"0.1.0","title":"Artcloud Peoples","category":"artcloud-blocks","description":"peoples block","example":{},"supports":{"html":false,"align":["wide","full"]},"textdomain":"artcloud-blocks","editorScript":"file:./index.js","editorStyle":"file:./index.css","style":"file:./style-index.css","viewScript":"file:./view.js","attributes":{"postType":{"type":"string","default":"person"},"peopleTitle":{"type":"string","default":""},"peopleDesc":{"type":"string","default":""},"memberTitle":{"type":"string","default":""},"memberDesc":{"type":"string","default":""},"selectedTitles":{"type":"array","default":[]},"checkedCategories":{"type":"array","default":[]},"selectedMembers":{"type":"array","default":[]},"selectedValue":{"type":"string","default":"6"},"selectedCategory":{"type":"number","default":0},"numberOfPosts":{"type":"number","default":-1},"displayFeaturedImage":{"type":"boolean","default":true},"displaySearchOption":{"type":"boolean","default":true},"displayDropdown":{"type":"boolean","default":true},"displayTitle":{"type":"boolean","default":true},"displayDesignation":{"type":"boolean","default":true},"displayVaralla":{"type":"boolean","default":true},"displayName":{"type":"boolean","default":true},"displayPhone":{"type":"boolean","default":true},"displayCity":{"type":"boolean","default":true},"displayHomeLink":{"type":"boolean","default":true},"displaySocialLink":{"type":"boolean","default":true},"displayProfileLink":{"type":"boolean","default":true},"displayEmail":{"type":"boolean","default":true},"displayRankNumber":{"type":"boolean","default":true},"order":{"type":"string","default":"desc"},"orderBy":{"type":"string","default":"date"},"categories":{"type":"array","items":{"type":"object"}},"description":{"type":"string","default":"Group decription will be here"}}}');

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = __webpack_modules__;
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/chunk loaded */
/******/ 	(() => {
/******/ 		var deferred = [];
/******/ 		__webpack_require__.O = (result, chunkIds, fn, priority) => {
/******/ 			if(chunkIds) {
/******/ 				priority = priority || 0;
/******/ 				for(var i = deferred.length; i > 0 && deferred[i - 1][2] > priority; i--) deferred[i] = deferred[i - 1];
/******/ 				deferred[i] = [chunkIds, fn, priority];
/******/ 				return;
/******/ 			}
/******/ 			var notFulfilled = Infinity;
/******/ 			for (var i = 0; i < deferred.length; i++) {
/******/ 				var [chunkIds, fn, priority] = deferred[i];
/******/ 				var fulfilled = true;
/******/ 				for (var j = 0; j < chunkIds.length; j++) {
/******/ 					if ((priority & 1 === 0 || notFulfilled >= priority) && Object.keys(__webpack_require__.O).every((key) => (__webpack_require__.O[key](chunkIds[j])))) {
/******/ 						chunkIds.splice(j--, 1);
/******/ 					} else {
/******/ 						fulfilled = false;
/******/ 						if(priority < notFulfilled) notFulfilled = priority;
/******/ 					}
/******/ 				}
/******/ 				if(fulfilled) {
/******/ 					deferred.splice(i--, 1)
/******/ 					var r = fn();
/******/ 					if (r !== undefined) result = r;
/******/ 				}
/******/ 			}
/******/ 			return result;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/jsonp chunk loading */
/******/ 	(() => {
/******/ 		// no baseURI
/******/ 		
/******/ 		// object to store loaded and loading chunks
/******/ 		// undefined = chunk not loaded, null = chunk preloaded/prefetched
/******/ 		// [resolve, reject, Promise] = chunk loading, 0 = chunk loaded
/******/ 		var installedChunks = {
/******/ 			"blocks/artcloud-peoples/index": 0,
/******/ 			"blocks/artcloud-peoples/style-index": 0
/******/ 		};
/******/ 		
/******/ 		// no chunk on demand loading
/******/ 		
/******/ 		// no prefetching
/******/ 		
/******/ 		// no preloaded
/******/ 		
/******/ 		// no HMR
/******/ 		
/******/ 		// no HMR manifest
/******/ 		
/******/ 		__webpack_require__.O.j = (chunkId) => (installedChunks[chunkId] === 0);
/******/ 		
/******/ 		// install a JSONP callback for chunk loading
/******/ 		var webpackJsonpCallback = (parentChunkLoadingFunction, data) => {
/******/ 			var [chunkIds, moreModules, runtime] = data;
/******/ 			// add "moreModules" to the modules object,
/******/ 			// then flag all "chunkIds" as loaded and fire callback
/******/ 			var moduleId, chunkId, i = 0;
/******/ 			if(chunkIds.some((id) => (installedChunks[id] !== 0))) {
/******/ 				for(moduleId in moreModules) {
/******/ 					if(__webpack_require__.o(moreModules, moduleId)) {
/******/ 						__webpack_require__.m[moduleId] = moreModules[moduleId];
/******/ 					}
/******/ 				}
/******/ 				if(runtime) var result = runtime(__webpack_require__);
/******/ 			}
/******/ 			if(parentChunkLoadingFunction) parentChunkLoadingFunction(data);
/******/ 			for(;i < chunkIds.length; i++) {
/******/ 				chunkId = chunkIds[i];
/******/ 				if(__webpack_require__.o(installedChunks, chunkId) && installedChunks[chunkId]) {
/******/ 					installedChunks[chunkId][0]();
/******/ 				}
/******/ 				installedChunks[chunkId] = 0;
/******/ 			}
/******/ 			return __webpack_require__.O(result);
/******/ 		}
/******/ 		
/******/ 		var chunkLoadingGlobal = globalThis["webpackChunkartcloud_blocks"] = globalThis["webpackChunkartcloud_blocks"] || [];
/******/ 		chunkLoadingGlobal.forEach(webpackJsonpCallback.bind(null, 0));
/******/ 		chunkLoadingGlobal.push = webpackJsonpCallback.bind(null, chunkLoadingGlobal.push.bind(chunkLoadingGlobal));
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module depends on other loaded chunks and execution need to be delayed
/******/ 	var __webpack_exports__ = __webpack_require__.O(undefined, ["blocks/artcloud-peoples/style-index"], () => (__webpack_require__("./src/blocks/artcloud-peoples/index.js")))
/******/ 	__webpack_exports__ = __webpack_require__.O(__webpack_exports__);
/******/ 	
/******/ })()
;
//# sourceMappingURL=index.js.map