/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/blocks/artcloud-hero/edit.js":
/*!******************************************!*\
  !*** ./src/blocks/artcloud-hero/edit.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _svgOptionsV_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./svgOptionsV.js */ "./src/blocks/artcloud-hero/svgOptionsV.js");
/* harmony import */ var _svgOptionsA_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./svgOptionsA.js */ "./src/blocks/artcloud-hero/svgOptionsA.js");








const ALLOWED_BLOCKS = ['core/column', 'core/cover', 'core/columns', 'core/image', 'core/button', 'core/heading', 'core/paragraph', 'core/group'];
const blockColumns = [['core/cover', {
  className: 'artcloud_hero_cover',
  overlayColor: 'yellow-green'
}, [['core/columns', {
  className: 'artcloud_hero_column_main'
}, [['core/column', {
  className: 'artcloud_hero_column_content',
  verticalAlignment: 'center'
}, [['core/heading', {
  level: 2,
  className: 'artcloud_hero_heading',
  content: 'Tässä on lyhyt sisäänheitto otsikko!'
}], ['core/paragraph', {
  className: 'artcloud_hero_description',
  content: 'Tähän alle sitten pienempi otsikko ja sivuston kuvaus.'
}], ['core/columns', {
  className: 'artcloud_hero_columns_child'
}, [['core/column', {
  className: 'artcloud_hero_column_child',
  verticalAlignment: 'center'
}, [['core/buttons', {
  className: 'artcloud_hero_button',
  text: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Show', 'artcloud-blocks'),
  url: '#'
}, [['core/button', {
  className: 'artcloud_hero_button',
  text: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Show', 'artcloud-blocks'),
  url: '#'
}], ['core/button', {
  className: 'artcloud_hero_button',
  text: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Signup', 'artcloud-blocks'),
  url: '#'
}]]]]]]]]], ['core/column', {
  className: 'artcloud_hero_column_content'
}, [['core/image', {
  className: 'artcloud_hero_image',
  content: ''
}]]]]]]]];
const Edit = ({
  attributes,
  setAttributes
}) => {
  const {
    svgOptions,
    selectedSvg,
    selectedSvgV,
    selectedSvgA
  } = attributes;
  const activeThemeName = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_5__.useSelect)(select => {
    return select('core').getCurrentTheme();
  }, []);
  setAttributes({
    svgOptions: activeThemeName && activeThemeName.name.rendered === 'Vihreat' ? _svgOptionsV_js__WEBPACK_IMPORTED_MODULE_6__["default"] : _svgOptionsA_js__WEBPACK_IMPORTED_MODULE_7__["default"]
  });
  const defaultSvg = activeThemeName && activeThemeName.name.rendered === 'Vihreat' ? selectedSvgV : selectedSvgA;
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
    if (!selectedSvg) {
      setAttributes({
        selectedSvg: defaultSvg
      });
    }
  }, [defaultSvg]);
  const handleSelectChange = newSvg => {
    setAttributes({
      selectedSvg: newSvg
    });
  };
  const getMaskImageUrl = selectedOption => {
    const selectedSvgOption = svgOptions.find(option => option.value === selectedOption);
    return selectedSvgOption ? `url("data:image/svg+xml,${encodeURIComponent(selectedSvgOption.value)}")` : '';
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    ...(0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.useBlockProps)()
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.InspectorControls, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelBody, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Background settings", "artcloud-blocks"),
    initialOpen: true
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.SelectControl, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Available options", "artcloud-blocks"),
    value: selectedSvg,
    options: svgOptions.map(option => ({
      label: option.label,
      value: option.value
    })),
    onChange: handleSelectChange
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("style", null, `.artcloud_hero_column_content .wp-block-image img {
                    mask-image: ${getMaskImageUrl(selectedSvg)} !important;
                    mask-position: center;
                    mask-repeat: no-repeat;
                    mask-size: 100% auto;
                    max-width: 100%;
                    height: 494px;
                    object-fit: cover;
                    text-align: center;
                    margin: 0 auto;
                    width: 29.7rem !important;
                }`), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.InnerBlocks, {
    template: blockColumns,
    allowedBlocks: ALLOWED_BLOCKS
  }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Edit);

/***/ }),

/***/ "./src/blocks/artcloud-hero/index.js":
/*!*******************************************!*\
  !*** ./src/blocks/artcloud-hero/index.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./style.scss */ "./src/blocks/artcloud-hero/style.scss");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _edit__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./edit */ "./src/blocks/artcloud-hero/edit.js");
/* harmony import */ var _save__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./save */ "./src/blocks/artcloud-hero/save.js");
/* harmony import */ var _block_json__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./block.json */ "./src/blocks/artcloud-hero/block.json");







const heroIcon = {
  src: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    id: "Layer_2",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 29.95 28.64"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("style", null, `.cls-1{fill:var(--wp--preset--color--white);stroke-width:0px;}`)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
    id: "Layer_1-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    className: "cls-1",
    d: "m4.79,11.39h6.07c.39,0,.71-.32.71-.71s-.32-.71-.71-.71h-6.07c-.39,0-.71.32-.71.71s.32.71.71.71Z"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    className: "cls-1",
    d: "m4.79,15.35h6.07c.39,0,.71-.32.71-.71s-.32-.71-.71-.71h-6.07c-.39,0-.71.32-.71.71s.32.71.71.71Z"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    className: "cls-1",
    d: "m4.79,19.23h1.31c.39,0,.71-.32.71-.71s-.32-.71-.71-.71h-1.31c-.39,0-.71.32-.71.71s.32.71.71.71Z"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    className: "cls-1",
    d: "m10.24,17.81h-1.31c-.39,0-.71.32-.71.71s.32.71.71.71h1.31c.39,0,.71-.32.71-.71s-.32-.71-.71-.71Z"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    className: "cls-1",
    d: "m29.24,0H0.71c-.39,0-.71.32-.71.71v27.22c0,.39.32.71.71.71h28.53c.39,0,.71-.32.71-.71V.71c0-.39-.32-.71-.71-.71Zm-.71,27.22H1.42V1.42h27.12v25.8Z"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    className: "cls-1",
    d: "m15.8,19.86h8.72c.39,0,.71-.32.71-.71v-8.63c0-.39-.32-.71-.71-.71h-8.72c-.39,0-.71.32-.71.71v8.63c0,.39.32.71.71.71Zm.71-8.63h7.3v7.21h-7.3v-7.21Z"
  }))),
  background: 'var(--wp--preset--color--primary)',
  foreground: 'var(--wp--preset--color--white)'
};
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)(_block_json__WEBPACK_IMPORTED_MODULE_6__.name, {
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('ArtCloud Vihreät Hero', 'artcloud-blocks'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Hero block for fetch image, title & description', 'artcloud-blocks'),
  icon: heroIcon,
  edit: _edit__WEBPACK_IMPORTED_MODULE_4__["default"],
  save: _save__WEBPACK_IMPORTED_MODULE_5__["default"]
});

/***/ }),

/***/ "./src/blocks/artcloud-hero/save.js":
/*!******************************************!*\
  !*** ./src/blocks/artcloud-hero/save.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__);


const Save = ({
  attributes
}) => {
  const {
    selectedSvg
  } = attributes;
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    ..._wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.useBlockProps.save({
      className: `card-text-align`
    })
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.InnerBlocks.Content, null), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("style", null, `
        .artcloud_hero_column_content .wp-block-image img {
            mask-image: url("data:image/svg+xml,${encodeURIComponent(selectedSvg)}") !important;
            mask-position: center;
            mask-repeat: no-repeat;
            mask-size: 100% auto;
            max-width: 100%;
            height: 494px;
            object-fit: cover;
            text-align: center;
            margin: 0 auto;
            width: 29.7rem !important;
          }
        `));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Save);

/***/ }),

/***/ "./src/blocks/artcloud-hero/svgOptionsA.js":
/*!*************************************************!*\
  !*** ./src/blocks/artcloud-hero/svgOptionsA.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const svgOptionsA = [{
  "label": "Abstrakti-1",
  "value": "<svg id=\"Layer_2\" xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 57.65 57.65\"><defs><style>.cls-1{stroke-width:0px;}</style></defs><g id=\"Layer_1-2\"><path class=\"cls-1\" d=\"m32.47,2.76l1.59,5.68c.66,2.36,3.36,3.48,5.49,2.28l5.14-2.89c3.33-1.87,7.02,1.82,5.15,5.15l-2.89,5.14c-1.2,2.14-.08,4.83,2.28,5.49l5.68,1.59c3.68,1.03,3.68,6.25,0,7.28l-5.68,1.59c-2.36.66-3.48,3.36-2.28,5.49l2.89,5.14c1.87,3.33-1.82,7.02-5.15,5.15l-5.14-2.89c-2.14-1.2-4.83-.08-5.49,2.28l-1.59,5.68c-1.03,3.68-6.25,3.68-7.28,0l-1.59-5.68c-.66-2.36-3.36-3.48-5.49-2.28l-5.14,2.89c-3.33,1.87-7.02-1.82-5.15-5.15l2.89-5.14c1.2-2.14.08-4.83-2.28-5.49l-5.68-1.59c-3.68-1.03-3.68-6.25,0-7.28l5.68-1.59c2.36-.66,3.48-3.36,2.28-5.49l-2.89-5.14c-1.87-3.33,1.82-7.02,5.15-5.15l5.14,2.89c2.14,1.2,4.83.08,5.49-2.28l1.59-5.68c1.03-3.68,6.25-3.68,7.28,0Z\" /></g></svg>"
}, {
  "label": "Abstrakti-2",
  "value": "<svg id=\"Layer_2\" xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 56.09 56.09\"><defs><style>.cls-1{stroke-width:0px;}</style></defs><g id=\"Layer_1-2\"><path class=\"cls-1\" d=\"m40.78,8.26h0c1.4,3.14,3.91,5.65,7.05,7.05h0c11.01,4.92,11.01,20.55,0,25.47h0c-3.14,1.4-5.65,3.91-7.05,7.05h0c-4.92,11.01-20.55,11.01-25.47,0h0c-1.4-3.14-3.91-5.65-7.05-7.05h0c-11.01-4.92-11.01-20.55,0-25.47h0c3.14-1.4,5.65-3.91,7.05-7.05h0c4.92-11.01,20.55-11.01,25.47,0Z\"/></g></svg>"
}, {
  "label": "Kukka",
  "value": "<svg id=\"Layer_2\" xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 51.24 51.17\"><defs><style>.cls-1{stroke-width:0px;}</style></defs><g id=\"Layer_1-2\"><path class=\"cls-1\" d=\"m51.21,25.4l-.23-1.27c-.53-2.88-2.81-5.11-5.7-5.59l-1.02-.17-.21-.42,1.18-2.36c1-2,.98-4.37-.06-6.35l-.02-.03c-.6-1.14-1.51-2.09-2.62-2.75l-.37-.22c-2.2-1.3-4.93-1.29-7.12.02l-1.48.89h-.22l-.57-1.99c-.75-2.62-2.95-4.56-5.64-4.97l-1.19-.18c-.11-.02-.22-.02-.32-.02-.11,0-.21,0-.32.02l-1.19.18c-2.69.41-4.89,2.35-5.64,4.97l-.57,1.99h-.22l-1.48-.89c-2.19-1.31-4.92-1.32-7.12-.02l-.36.22c-1.11.66-2.02,1.61-2.62,2.75l-.02.03c-1.04,1.98-1.07,4.35-.06,6.35l1.18,2.36-.21.42-1.06.18c-2.86.48-5.12,2.68-5.68,5.52l-.2,1.04c-.02.11-.03.22-.03.33,0,.11,0,.22.03.33l.23,1.26c.53,2.88,2.81,5.11,5.7,5.59l1.02.17.21.42-1.18,2.36c-1,2-.98,4.37.06,6.35l.02.03c.6,1.14,1.51,2.09,2.62,2.75l.37.22c2.2,1.3,4.93,1.29,7.12-.02l1.48-.89h.22l.57,1.99c.75,2.62,2.95,4.56,5.64,4.97l1.19.18s.1,0,.14.01c.09.02.19.03.28.03.08,0,.16,0,.24-.02l1.19-.18c2.69-.41,4.89-2.36,5.63-4.97l.57-1.99h.22s1.49.89,1.49.89c2.19,1.31,4.92,1.31,7.12.01l.36-.22c1.11-.66,2.01-1.61,2.61-2.75l.02-.03c1.04-1.98,1.06-4.35.06-6.35l-1.18-2.35.21-.42,1.06-.18c2.86-.48,5.12-2.69,5.67-5.53l.19-.98c.06-.22.08-.45.03-.69Z\"/></g></svg>"
}];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (svgOptionsA);

/***/ }),

/***/ "./src/blocks/artcloud-hero/svgOptionsV.js":
/*!*************************************************!*\
  !*** ./src/blocks/artcloud-hero/svgOptionsV.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const svgOptionsV = [{
  "label": "Vihreat",
  "value": "<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" width=\"68.493\" height=\"71.854\" viewBox=\"0 0 68.493 71.854\"><defs><clipPath id=\"clip-path\"><rect id=\"Rectangle_661\" data-name=\"Rectangle 661\" width=\"68.493\" height=\"71.854\" transform=\"translate(0 0)\" fill=\"none\"/></clipPath></defs><g id=\"Group_767\" data-name=\"Group 767\" transform=\"translate(0 0)\"><g id=\"Group_766\" data-name=\"Group 766\" clip-path=\"url(#clip-path)\"><path id=\"Path_109\" data-name=\"Path 109\" d=\"M32.754,1.119v0a1.557,1.557,0,0,1,2.987,0v0A11.315,11.315,0,0,0,53.5,6.889l0,0a1.557,1.557,0,0,1,2.416,1.755v.005a11.316,11.316,0,0,0,10.975,15.1h0a1.557,1.557,0,0,1,.922,2.84h0a11.317,11.317,0,0,0,0,18.672h0a1.556,1.556,0,0,1-.922,2.839h0a11.317,11.317,0,0,0-10.975,15.1v0A1.557,1.557,0,0,1,53.5,64.966a11.316,11.316,0,0,0-17.758,5.767v0a1.557,1.557,0,0,1-2.987,0v0a11.317,11.317,0,0,0-17.759-5.769h0a1.556,1.556,0,0,1-2.415-1.755v0A11.318,11.318,0,0,0,1.6,48.1h0a1.556,1.556,0,0,1-.922-2.839h0a11.317,11.317,0,0,0,0-18.672h0a1.556,1.556,0,0,1,.922-2.84h0A11.317,11.317,0,0,0,12.58,8.647l0-.005a1.556,1.556,0,0,1,2.415-1.755l0,0a11.316,11.316,0,0,0,17.757-5.77\" fill=\"#009639\"/></g></g></svg>"
}, {
  "label": "Lehti",
  "value": "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 69.068 69.069\"><path d=\"M51.945,59.884A63.928,63.928,0,0,1,37.967,39.121a.885.885,0,0,1,1.154-1.154A63.944,63.944,0,0,1,59.884,51.945a66.237,66.237,0,0,1,7.177,8.485.886.886,0,0,0,1.6-.409A53.42,53.42,0,0,0,2.7,1.588,1.525,1.525,0,0,0,1.589,2.7,53.418,53.418,0,0,0,60.021,68.66a.886.886,0,0,0,.409-1.6,66.305,66.305,0,0,1-8.485-7.177\" fill=\"#009639\"/></svg>"
}, {
  "label": "Koti",
  "value": "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 69.832 70.582\"><path d=\"M69.014,34.027,36.995.882a2.892,2.892,0,0,0-4.159,0L19.977,14.194a1.612,1.612,0,0,1-2.771-1.12V9.907a2.891,2.891,0,0,0-2.892-2.891H10.341A2.891,2.891,0,0,0,7.449,9.907V25.994A2.893,2.893,0,0,1,6.637,28L.818,34.027a2.891,2.891,0,0,0,2.079,4.9H4.558a2.891,2.891,0,0,1,2.891,2.892V67.691a2.891,2.891,0,0,0,2.892,2.891h49.15a2.891,2.891,0,0,0,2.891-2.891V41.819a2.892,2.892,0,0,1,2.892-2.892h1.66a2.891,2.891,0,0,0,2.08-4.9\" fill=\"#009639\"/></svg>"
}, {
  "label": "Kilpi",
  "value": "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 63.62 74.125\"><path d=\"M1.246,3.719A1.658,1.658,0,0,0,0,5.324V42.257c0,16.7,4.43,21.835,30.793,31.684a2.906,2.906,0,0,0,2.034,0C59.189,64.092,63.62,58.959,63.62,42.257V5.359a1.659,1.659,0,0,0-1.287-1.614C41.117-1.169,20.73-1.319,1.246,3.719\" fill=\"#009639\"/></svg>"
}, {
  "label": "Syd채n",
  "value": "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 81.985 68.583\"><path d=\"M42.72,17.44a1.807,1.807,0,0,1-3.52,0,26.852,26.852,0,0,0-2.759-7.61A19.986,19.986,0,0,0,19.412,0,19.387,19.387,0,0,0,6.271,5.014a19.718,19.718,0,0,0-1.233,27.6C15.414,44.235,32.96,42.23,39.1,67.211a1.807,1.807,0,0,0,3.514-.023C48.524,42.272,67.5,43.686,77.3,32.135A19.415,19.415,0,0,0,62.51,0h0A19.893,19.893,0,0,0,45.481,9.831,27.249,27.249,0,0,0,42.72,17.44\" fill=\"#009639\"/></svg>"
}, {
  "label": "Puu",
  "value": "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 76.573 66.015\"><path d=\"M25.588,46.374C18.575,54.19,7.612,60.149.8,63.36A1.394,1.394,0,0,0,1.4,66.015H75.177a1.394,1.394,0,0,0,.594-2.655C68.962,60.149,58,54.191,50.986,46.375a.893.893,0,0,1,.917-1.451,84.293,84.293,0,0,0,16.943,3.038,1.394,1.394,0,0,0,.818-2.589C63.294,41.6,52.592,34.659,48.635,28.488a.893.893,0,0,1,.965-1.349,54.018,54.018,0,0,0,7.815,1.3,1.4,1.4,0,0,0,.944-2.522c-8.438-6.04-14.854-15.3-18.782-25.052A1.393,1.393,0,0,0,37,.869c-3.928,9.748-10.343,19.012-18.782,25.052a1.4,1.4,0,0,0,.944,2.523,54.106,54.106,0,0,0,7.815-1.305.893.893,0,0,1,.966,1.349C23.981,34.659,13.28,41.6,6.91,45.371a1.394,1.394,0,0,0,.818,2.589,84.235,84.235,0,0,0,16.943-3.037.893.893,0,0,1,.917,1.451\"/></svg>"
}, {
  "label": "Kirja",
  "value": "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 77.578 66.315\"><path d=\"M39.63,18.361C42.394,8.067,52.1.29,76.181,0a1.379,1.379,0,0,1,1.4,1.377v44.07a1.377,1.377,0,0,1-1.36,1.377c-24.576.281-33.335,8.223-34,18.215a1.372,1.372,0,0,1-1.372,1.276H36.736a1.372,1.372,0,0,1-1.372-1.276c-.67-9.992-9.428-17.934-34-18.215A1.376,1.376,0,0,1,0,45.447V1.377A1.379,1.379,0,0,1,1.4,0C25.487.29,35.418,7.975,38.078,18.346a.8.8,0,0,0,1.552.015\"/></svg>"
}, {
  "label": "Chat",
  "value": "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 83.74 59.496\"><path d=\"M61.342,47.757c12.667-3.685,22.4-9.185,22.4-20.5C83.74,7.779,62.458,0,41.87,0S0,7.779,0,27.257C0,40.29,9.771,48.047,22,52.512c10.4,3.8,28.149,6.543,45.822,6.984a.974.974,0,0,0,.376-1.9c-9.235-1.976-12.308-3.458-12.308-5.971,0-2.1,1.942-2.828,5.52-3.864Z\"/></svg>"
}, {
  "label": "Aalto",
  "value": "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 69.737 65.853\"><path d=\"M0,43.5A43.3,43.3,0,0,1,33.458,1.235,48.433,48.433,0,0,1,44.314,0C56.523,0,69.737,8.1,69.737,20.058a13.182,13.182,0,0,1-1.98,6.95,1.372,1.372,0,0,1-2.4-.095c-1.618-3.167-5.547-5.556-10.174-5.556-8.837,0-13.641,8.7-13.641,15.5,0,13.653,9.284,24.964,24.2,29H.006Z\"/></svg>"
}, {
  "label": "Sieni",
  "value": "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 67.798 71.712\"><path d=\"M33.9,0C13.427,0,0,13.579,0,27.4c0,8.489,5.858,14.15,12.514,14.15a13.769,13.769,0,0,0,6.624-1.492c2.084-1.129,4.524-1.443,6.11.488a4.363,4.363,0,0,1,.274,4.651,33.636,33.636,0,0,0-4.087,14.979c0,7.017,4.155,11.54,12.464,11.54s12.464-4.523,12.464-11.54c0-3.975-1.227-7.761-2.553-11.464-1.2-3.343-2.427-6.972.083-8.932,1.794-1.4,3.709-.536,5.308.5,1.7,1.1,4.119,1.274,6.083,1.274,6.656,0,12.514-5.661,12.514-14.15C67.8,13.579,54.371,0,33.9,0\"/></svg>"
}, {
  "label": "info",
  "value": "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 48 48\"><path d=\"M 24 3 C 12.413858 3 3 12.413866 3 24 C 3 35.586134 12.413858 45 24 45 C 35.586142 45 45 35.586134 45 24 C 45 12.413866 35.586142 3 24 3 z M 24 5 C 34.505263 5 43 13.494744 43 24 C 43 34.505256 34.505263 43 24 43 C 13.494737 43 5 34.505256 5 24 C 5 13.494744 13.494737 5 24 5 z M 24 12.185547 C 23.159 12.185547 22.474609 12.863313 22.474609 13.695312 C 22.474609 14.535312 23.159 15.220703 24 15.220703 C 24.85 15.220703 25.541016 14.535312 25.541016 13.695312 C 25.541016 12.863312 24.85 12.185547 24 12.185547 z M 24 17.935547 C 23.305 17.935547 22.818359 18.454312 22.818359 19.195312 L 22.818359 33.757812 C 22.818359 34.498812 23.304 35.017578 24 35.017578 C 24.696 35.017578 25.181641 34.498813 25.181641 33.757812 L 25.181641 19.193359 C 25.181641 18.452359 24.695 17.935547 24 17.935547 z\"/></svg>"
}];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (svgOptionsV);

/***/ }),

/***/ "./src/blocks/artcloud-hero/style.scss":
/*!*********************************************!*\
  !*** ./src/blocks/artcloud-hero/style.scss ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "react":
/*!************************!*\
  !*** external "React" ***!
  \************************/
/***/ ((module) => {

module.exports = window["React"];

/***/ }),

/***/ "@wordpress/block-editor":
/*!*************************************!*\
  !*** external ["wp","blockEditor"] ***!
  \*************************************/
/***/ ((module) => {

module.exports = window["wp"]["blockEditor"];

/***/ }),

/***/ "@wordpress/blocks":
/*!********************************!*\
  !*** external ["wp","blocks"] ***!
  \********************************/
/***/ ((module) => {

module.exports = window["wp"]["blocks"];

/***/ }),

/***/ "@wordpress/components":
/*!************************************!*\
  !*** external ["wp","components"] ***!
  \************************************/
/***/ ((module) => {

module.exports = window["wp"]["components"];

/***/ }),

/***/ "@wordpress/data":
/*!******************************!*\
  !*** external ["wp","data"] ***!
  \******************************/
/***/ ((module) => {

module.exports = window["wp"]["data"];

/***/ }),

/***/ "@wordpress/element":
/*!*********************************!*\
  !*** external ["wp","element"] ***!
  \*********************************/
/***/ ((module) => {

module.exports = window["wp"]["element"];

/***/ }),

/***/ "@wordpress/i18n":
/*!******************************!*\
  !*** external ["wp","i18n"] ***!
  \******************************/
/***/ ((module) => {

module.exports = window["wp"]["i18n"];

/***/ }),

/***/ "./src/blocks/artcloud-hero/block.json":
/*!*********************************************!*\
  !*** ./src/blocks/artcloud-hero/block.json ***!
  \*********************************************/
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$schema":"https://raw.githubusercontent.com/WordPress/gutenberg/trunk/schemas/json/block.json","apiVersion":3,"name":"artcloud-blocks/artcloud-hero","version":"1.0.0","title":"ArtCloud Vihreät Hero","category":"artcloud-blocks","description":"Create a new hero block","keywords":["hero","box"],"supports":{"align":["wide","full"],"html":false},"textdomain":"artcloud-blocks","editorScript":"file:./index.js","editorStyle":"file:./index.css","style":"file:./style-index.css","attributes":{"title":{"type":"string"},"selectedSvg":{"type":"string","default":""},"selectedSvgV":{"type":"string","default":"<svg xmlns=\\"http://www.w3.org/2000/svg\\" xmlns:xlink=\\"http://www.w3.org/1999/xlink\\" width=\\"68.493\\" height=\\"71.854\\" viewBox=\\"0 0 68.493 71.854\\"><defs><clipPath id=\\"clip-path\\"><rect id=\\"Rectangle_661\\" data-name=\\"Rectangle 661\\" width=\\"68.493\\" height=\\"71.854\\" transform=\\"translate(0 0)\\" fill=\\"none\\"/></clipPath></defs><g id=\\"Group_767\\" data-name=\\"Group 767\\" transform=\\"translate(0 0)\\"><g id=\\"Group_766\\" data-name=\\"Group 766\\" clip-path=\\"url(#clip-path)\\"><path id=\\"Path_109\\" data-name=\\"Path 109\\" d=\\"M32.754,1.119v0a1.557,1.557,0,0,1,2.987,0v0A11.315,11.315,0,0,0,53.5,6.889l0,0a1.557,1.557,0,0,1,2.416,1.755v.005a11.316,11.316,0,0,0,10.975,15.1h0a1.557,1.557,0,0,1,.922,2.84h0a11.317,11.317,0,0,0,0,18.672h0a1.556,1.556,0,0,1-.922,2.839h0a11.317,11.317,0,0,0-10.975,15.1v0A1.557,1.557,0,0,1,53.5,64.966a11.316,11.316,0,0,0-17.758,5.767v0a1.557,1.557,0,0,1-2.987,0v0a11.317,11.317,0,0,0-17.759-5.769h0a1.556,1.556,0,0,1-2.415-1.755v0A11.318,11.318,0,0,0,1.6,48.1h0a1.556,1.556,0,0,1-.922-2.839h0a11.317,11.317,0,0,0,0-18.672h0a1.556,1.556,0,0,1,.922-2.84h0A11.317,11.317,0,0,0,12.58,8.647l0-.005a1.556,1.556,0,0,1,2.415-1.755l0,0a11.316,11.316,0,0,0,17.757-5.77\\" fill=\\"#009639\\"/></g></g></svg>"},"selectedSvgA":{"type":"string","default":"<svg id=\\"Layer_2\\" xmlns=\\"http://www.w3.org/2000/svg\\" viewBox=\\"0 0 57.65 57.65\\"><defs><style>.cls-1{stroke-width:0px;}</style></defs><g id=\\"Layer_1-2\\"><path class=\\"cls-1\\" d=\\"m32.47,2.76l1.59,5.68c.66,2.36,3.36,3.48,5.49,2.28l5.14-2.89c3.33-1.87,7.02,1.82,5.15,5.15l-2.89,5.14c-1.2,2.14-.08,4.83,2.28,5.49l5.68,1.59c3.68,1.03,3.68,6.25,0,7.28l-5.68,1.59c-2.36.66-3.48,3.36-2.28,5.49l2.89,5.14c1.87,3.33-1.82,7.02-5.15,5.15l-5.14-2.89c-2.14-1.2-4.83-.08-5.49,2.28l-1.59,5.68c-1.03,3.68-6.25,3.68-7.28,0l-1.59-5.68c-.66-2.36-3.36-3.48-5.49-2.28l-5.14,2.89c-3.33,1.87-7.02-1.82-5.15-5.15l2.89-5.14c1.2-2.14.08-4.83-2.28-5.49l-5.68-1.59c-3.68-1.03-3.68-6.25,0-7.28l5.68-1.59c2.36-.66,3.48-3.36,2.28-5.49l-2.89-5.14c-1.87-3.33,1.82-7.02,5.15-5.15l5.14,2.89c2.14,1.2,4.83.08,5.49-2.28l1.59-5.68c1.03-3.68,6.25-3.68,7.28,0Z\\" /></g></svg>"},"svgOptions":{"type":"object","default":{}},"description":{"type":"string"},"alignment":{"type":"string","default":"left"},"backgroundColor":{"type":"string"},"textColor":{"type":"string"},"backgroundImage":{"type":"string","default":""}}}');

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = __webpack_modules__;
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/chunk loaded */
/******/ 	(() => {
/******/ 		var deferred = [];
/******/ 		__webpack_require__.O = (result, chunkIds, fn, priority) => {
/******/ 			if(chunkIds) {
/******/ 				priority = priority || 0;
/******/ 				for(var i = deferred.length; i > 0 && deferred[i - 1][2] > priority; i--) deferred[i] = deferred[i - 1];
/******/ 				deferred[i] = [chunkIds, fn, priority];
/******/ 				return;
/******/ 			}
/******/ 			var notFulfilled = Infinity;
/******/ 			for (var i = 0; i < deferred.length; i++) {
/******/ 				var [chunkIds, fn, priority] = deferred[i];
/******/ 				var fulfilled = true;
/******/ 				for (var j = 0; j < chunkIds.length; j++) {
/******/ 					if ((priority & 1 === 0 || notFulfilled >= priority) && Object.keys(__webpack_require__.O).every((key) => (__webpack_require__.O[key](chunkIds[j])))) {
/******/ 						chunkIds.splice(j--, 1);
/******/ 					} else {
/******/ 						fulfilled = false;
/******/ 						if(priority < notFulfilled) notFulfilled = priority;
/******/ 					}
/******/ 				}
/******/ 				if(fulfilled) {
/******/ 					deferred.splice(i--, 1)
/******/ 					var r = fn();
/******/ 					if (r !== undefined) result = r;
/******/ 				}
/******/ 			}
/******/ 			return result;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/jsonp chunk loading */
/******/ 	(() => {
/******/ 		// no baseURI
/******/ 		
/******/ 		// object to store loaded and loading chunks
/******/ 		// undefined = chunk not loaded, null = chunk preloaded/prefetched
/******/ 		// [resolve, reject, Promise] = chunk loading, 0 = chunk loaded
/******/ 		var installedChunks = {
/******/ 			"blocks/artcloud-hero/index": 0,
/******/ 			"blocks/artcloud-hero/style-index": 0
/******/ 		};
/******/ 		
/******/ 		// no chunk on demand loading
/******/ 		
/******/ 		// no prefetching
/******/ 		
/******/ 		// no preloaded
/******/ 		
/******/ 		// no HMR
/******/ 		
/******/ 		// no HMR manifest
/******/ 		
/******/ 		__webpack_require__.O.j = (chunkId) => (installedChunks[chunkId] === 0);
/******/ 		
/******/ 		// install a JSONP callback for chunk loading
/******/ 		var webpackJsonpCallback = (parentChunkLoadingFunction, data) => {
/******/ 			var [chunkIds, moreModules, runtime] = data;
/******/ 			// add "moreModules" to the modules object,
/******/ 			// then flag all "chunkIds" as loaded and fire callback
/******/ 			var moduleId, chunkId, i = 0;
/******/ 			if(chunkIds.some((id) => (installedChunks[id] !== 0))) {
/******/ 				for(moduleId in moreModules) {
/******/ 					if(__webpack_require__.o(moreModules, moduleId)) {
/******/ 						__webpack_require__.m[moduleId] = moreModules[moduleId];
/******/ 					}
/******/ 				}
/******/ 				if(runtime) var result = runtime(__webpack_require__);
/******/ 			}
/******/ 			if(parentChunkLoadingFunction) parentChunkLoadingFunction(data);
/******/ 			for(;i < chunkIds.length; i++) {
/******/ 				chunkId = chunkIds[i];
/******/ 				if(__webpack_require__.o(installedChunks, chunkId) && installedChunks[chunkId]) {
/******/ 					installedChunks[chunkId][0]();
/******/ 				}
/******/ 				installedChunks[chunkId] = 0;
/******/ 			}
/******/ 			return __webpack_require__.O(result);
/******/ 		}
/******/ 		
/******/ 		var chunkLoadingGlobal = globalThis["webpackChunkartcloud_blocks"] = globalThis["webpackChunkartcloud_blocks"] || [];
/******/ 		chunkLoadingGlobal.forEach(webpackJsonpCallback.bind(null, 0));
/******/ 		chunkLoadingGlobal.push = webpackJsonpCallback.bind(null, chunkLoadingGlobal.push.bind(chunkLoadingGlobal));
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module depends on other loaded chunks and execution need to be delayed
/******/ 	var __webpack_exports__ = __webpack_require__.O(undefined, ["blocks/artcloud-hero/style-index"], () => (__webpack_require__("./src/blocks/artcloud-hero/index.js")))
/******/ 	__webpack_exports__ = __webpack_require__.O(__webpack_exports__);
/******/ 	
/******/ })()
;
//# sourceMappingURL=index.js.map