/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/blocks/artcloud-authors/edit.js":
/*!*********************************************!*\
  !*** ./src/blocks/artcloud-authors/edit.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Edit)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _editor_scss__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./editor.scss */ "./src/blocks/artcloud-authors/editor.scss");







function Edit({
  attributes,
  setAttributes
}) {
  const {
    numberOfItems,
    title,
    displayAuthorImage,
    displayDescription,
    displayDateAuthor,
    postType,
    categories,
    selectedAuthors,
    textColor,
    backgroundColor,
    btnBackgroundColor,
    btnTextColor
  } = attributes;
  const postTypes = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => {
    return select('core').getPostTypes();
  }, []);
  const catIds = categories && categories.length > 0 ? categories.map(cat => cat.id) : [];
  const postTypeTaxonomy = postTypes && postTypes.length ? postTypes.find(type => type.slug === postType)?.taxonomies[0] || 'category' : '';
  // const authorIds = selectedAuthors.map((author) => author.id).filter(Boolean);
  const items = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => {
    const itemArgs = {
      per_page: numberOfItems,
      _embed: true
    };

    // Set categories based on postType
    postType === 'post' ? itemArgs.categories = catIds : itemArgs[postTypeTaxonomy] = catIds;

    // Map author names to IDs
    const authorIds = selectedAuthors.map(author => author.id).filter(Boolean);

    // Set author directly in itemArgs
    if (authorIds.length > 0) {
      itemArgs.author = authorIds;
    }
    return select('core').getEntityRecords('postType', postType, itemArgs);
  }, [postType, catIds, postTypeTaxonomy, numberOfItems, selectedAuthors]);
  const allCats = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => {
    return postTypeTaxonomy ? select('core').getEntityRecords('taxonomy', postTypeTaxonomy, {
      per_page: -1
    }) : [];
  }, [postTypeTaxonomy]);
  const catSuggestions = {};
  if (allCats) {
    for (let i = 0; i < allCats.length; i++) {
      const cat = allCats[i];
      catSuggestions[cat.name] = cat;
    }
  }
  const onCategoryChange = values => {
    const hasNoSuggestions = values.some(value => typeof value === 'string' && !catSuggestions[value]);
    if (hasNoSuggestions) return;
    const updatesCats = values.map(token => {
      return typeof token === 'string' ? catSuggestions[token] : token;
    });
    setAttributes({
      categories: updatesCats
    });
  };
  const allAuthors = wp.data.select('core').getEntityRecords('root', 'user');

  // Your onSelectAuthors function
  const onSelectAuthors = selected => {
    const authorObjs = selected.map(author => {
      const foundAuthor = allAuthors.find(a => a.name === author);
      return foundAuthor ? foundAuthor : {
        id: null,
        name: author
      };
    });
    setAttributes({
      selectedAuthors: authorObjs
    });
  };
  const onChangeBackgroundColor = newBgColor => {
    setAttributes({
      backgroundColor: newBgColor
    });
  };
  const onChangeTitle = value => {
    setAttributes({
      title: value
    });
  };
  const onChangeTextColor = newTextColor => {
    setAttributes({
      textColor: newTextColor
    });
  };
  const onChangebtnTextColor = newTextColor => {
    setAttributes({
      btnTextColor: newTextColor
    });
  };
  const onChangeBtnBackgroundColor = newBgColor => {
    setAttributes({
      btnBackgroundColor: newBgColor
    });
  };
  const onPostTypeChange = value => {
    setAttributes({
      postType: value
    });
    setAttributes({
      categories: []
    });
  };
  const displayImageChange = value => {
    setAttributes({
      displayAuthorImage: value
    });
  };
  const displayDateAuthorChange = value => {
    setAttributes({
      displayDateAuthor: value
    });
  };
  const displayDescriptionChange = value => {
    setAttributes({
      displayDescription: value
    });
  };
  const onNumberOfItemsChange = value => {
    setAttributes({
      numberOfItems: value
    });
  };
  const excludedSlugs = ["attachment", "nav_menu_item", "page", "team", "product", "event", "wp_block", "wp_template", "wp_template_part", "wp_navigation", "wp_font_face", "wp_font_family"];
  const sortedItems = (items || []).sort((a, b) => a.title.rendered.localeCompare(b.title.rendered));
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    ...(0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.useBlockProps)()
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.InspectorControls, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.PanelBody, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ToggleControl, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Display Image', 'artcloud-blocks'),
    checked: displayAuthorImage,
    onChange: displayImageChange
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ToggleControl, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Display Content', 'artcloud-blocks'),
    checked: displayDescription,
    onChange: displayDescriptionChange
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ToggleControl, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Display Date & Author', 'artcloud-blocks'),
    checked: displayDateAuthor,
    onChange: displayDateAuthorChange
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.SelectControl, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Select Post Type', 'artcloud-blocks'),
    value: postType,
    options: postTypes ? postTypes.filter(type => !excludedSlugs.includes(type.slug)).map(type => ({
      label: type.name,
      value: type.slug
    })) : [],
    onChange: onPostTypeChange
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.QueryControls, {
    categorySuggestions: catSuggestions,
    selectedCategories: categories,
    onCategoryChange: onCategoryChange,
    numberOfItems: numberOfItems,
    onNumberOfItemsChange: onNumberOfItemsChange
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.FormTokenField, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Select authors', 'artcloud-blocks'),
    value: selectedAuthors.map(authorObj => authorObj.name),
    suggestions: (allAuthors || []).map(author => author.name),
    onChange: onSelectAuthors
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.PanelColorSettings, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Color Settings', 'artcloud-blocks'),
    icon: "admin-appearance",
    initialOpen: true,
    colorSettings: [{
      value: backgroundColor,
      onChange: onChangeBackgroundColor,
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Background Color', 'artcloud-blocks')
    }, {
      value: textColor,
      onChange: onChangeTextColor,
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Text Color', 'artcloud-blocks')
    }, {
      value: btnBackgroundColor,
      onChange: onChangeBtnBackgroundColor,
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Button BG Color', 'artcloud-blocks')
    }, {
      value: btnTextColor,
      onChange: onChangebtnTextColor,
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('ButtonText Color', 'artcloud-blocks')
    }]
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.ContrastChecker, {
    textColor: textColor,
    backgroundColor: backgroundColor
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    ...(0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.useBlockProps)()
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.RichText, {
    tagName: "h1",
    style: {
      color: btnBackgroundColor
    },
    className: "post-block-title",
    placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Enter title', 'artcloud-blocks'),
    value: title,
    onChange: onChangeTitle,
    allowedFormats: []
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "row"
  }, sortedItems.length > 0 ? sortedItems.map(post => {
    var _post$_embedded$autho, _post$_embedded$autho2;
    const authorName = (_post$_embedded$autho = post?._embedded?.author?.[0]?.name) !== null && _post$_embedded$autho !== void 0 ? _post$_embedded$autho : '';
    const authorImage = (_post$_embedded$autho2 = post?._embedded?.author?.[0]?.avatar_urls['96']) !== null && _post$_embedded$autho2 !== void 0 ? _post$_embedded$autho2 : '';
    const postContent = post.excerpt.rendered;
    const postExcerpt = postContent.split(' ').slice(0, 8).join(' ');
    const postDate = new Date(post.date);
    const options = {
      day: 'numeric',
      month: 'numeric',
      year: 'numeric'
    };
    const formattedDateTime = postDate.toLocaleDateString('fi-FI', options).replace(/\//g, ' ').replace(',', '');
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "artcloud-item col-4"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "artcloud-postImg"
    }, displayAuthorImage && authorImage && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
      src: authorImage,
      alt: authorName.alt_text
    })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "artcloud-content",
      style: {
        backgroundColor: backgroundColor,
        color: textColor
      }
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "artcloud-date-author"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      style: {
        color: textColor
      }
    }, displayDateAuthor && formattedDateTime && formattedDateTime), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h6", {
      style: {
        color: textColor
      }
    }, displayDateAuthor && authorName && authorName, " ")), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.RawHTML, null, displayDescription && postExcerpt && postExcerpt), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
      style: {
        backgroundColor: btnBackgroundColor,
        color: btnTextColor
      },
      className: "wp-block-post-excerpt__more-link",
      href: post.link
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Lue', 'artcloud-blocks'))));
  }) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "artcloud-item col-12"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('No posts found for the selected author.', 'artcloud-blocks'))))));
}

/***/ }),

/***/ "./src/blocks/artcloud-authors/index.js":
/*!**********************************************!*\
  !*** ./src/blocks/artcloud-authors/index.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./style.scss */ "./src/blocks/artcloud-authors/style.scss");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _edit__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./edit */ "./src/blocks/artcloud-authors/edit.js");
/* harmony import */ var _save__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./save */ "./src/blocks/artcloud-authors/save.js");
/* harmony import */ var _block_json__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./block.json */ "./src/blocks/artcloud-authors/block.json");







const blogikirjoittajatIcon = {
  src: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    id: "Layer_2",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20.82 25.25"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("style", null, `.cls-1{fill:var(--wp--preset--color--white);stroke-width:0px;}`)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
    id: "Layer_1-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    class: "cls-1",
    d: "m20.8,19.43c-.77-3.64-5.5-5-7.34-5.4v-.88c1.26-.79,2.11-2.17,2.16-3.75.79-.32,1.35-1.1,1.35-2s-.56-1.68-1.35-2v-.8c0-2.54-2.07-4.61-4.61-4.61h-1.2c-2.54,0-4.61,2.07-4.61,4.61v.62c-.84.3-1.44,1.1-1.44,2.04s.6,1.74,1.44,2.04c.01,1.63.87,3.05,2.16,3.86v.88c-1.85.4-6.57,1.76-7.34,5.4-.01.06-.02.12-.02.18v4.78c0,.47.38.85.85.85h19.11c.47,0,.85-.38.85-.85v-4.78c0-.06,0-.12-.02-.18ZM9.81,1.7h1.2c1.6,0,2.9,1.3,2.9,2.9v.12c-.57-.33-1.32-.88-1.59-1.19-.03-.23-.15-.44-.36-.59-.39-.27-.92-.17-1.18.21-.07.1-.18.31-.17.59h-.02s0-.02.01-.05c0,.01-.47,1.16-3.69,1.09v-.18c0-1.6,1.3-2.9,2.9-2.9Zm-2.9,4.79c.08,0,.17,0,.25,0,2.51,0,3.79-.69,4.44-1.32.21.18.46.37.72.55.44.31.88.57,1.24.73.13.06.24.1.36.14v2.67c0,1.07-.58,2-1.44,2.5-.17.03-.32.1-.45.21-.32.12-.66.19-1.02.19h-1.2c-.36,0-.7-.07-1.02-.19-.12-.11-.28-.19-.45-.21-.86-.5-1.44-1.44-1.44-2.5v-2.77Zm2.9,7.38h1.2c.25,0,.5-.02.74-.06v.6l-1.3,1.37-1.39-1.39v-.58c.24.04.49.06.74.06Zm9.31,9.67H1.7v-3.84c.39-1.61,2.08-2.63,3.44-3.2,1.12-.47,2.21-.73,2.78-.85l1.94,1.94c.16.16.38.25.6.25,0,0,0,0,.01,0,.23,0,.45-.1.61-.27l1.82-1.92c.58.12,1.66.37,2.77.84,1.36.57,3.05,1.59,3.44,3.2v3.84Z"
  }))),
  background: 'var(--wp--preset--color--primary)',
  foreground: 'var(--wp--preset--color--white)'
};
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)(_block_json__WEBPACK_IMPORTED_MODULE_6__.name, {
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Artcloud Authors Block', 'artcloud-blocks'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Display posts and events authors block', 'artcloud-blocks'),
  icon: blogikirjoittajatIcon,
  edit: _edit__WEBPACK_IMPORTED_MODULE_4__["default"],
  save: _save__WEBPACK_IMPORTED_MODULE_5__["default"]
});

/***/ }),

/***/ "./src/blocks/artcloud-authors/save.js":
/*!*********************************************!*\
  !*** ./src/blocks/artcloud-authors/save.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ save)
/* harmony export */ });
function save() {
  return null;
}

/***/ }),

/***/ "./src/blocks/artcloud-authors/editor.scss":
/*!*************************************************!*\
  !*** ./src/blocks/artcloud-authors/editor.scss ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./src/blocks/artcloud-authors/style.scss":
/*!************************************************!*\
  !*** ./src/blocks/artcloud-authors/style.scss ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "react":
/*!************************!*\
  !*** external "React" ***!
  \************************/
/***/ ((module) => {

module.exports = window["React"];

/***/ }),

/***/ "@wordpress/block-editor":
/*!*************************************!*\
  !*** external ["wp","blockEditor"] ***!
  \*************************************/
/***/ ((module) => {

module.exports = window["wp"]["blockEditor"];

/***/ }),

/***/ "@wordpress/blocks":
/*!********************************!*\
  !*** external ["wp","blocks"] ***!
  \********************************/
/***/ ((module) => {

module.exports = window["wp"]["blocks"];

/***/ }),

/***/ "@wordpress/components":
/*!************************************!*\
  !*** external ["wp","components"] ***!
  \************************************/
/***/ ((module) => {

module.exports = window["wp"]["components"];

/***/ }),

/***/ "@wordpress/data":
/*!******************************!*\
  !*** external ["wp","data"] ***!
  \******************************/
/***/ ((module) => {

module.exports = window["wp"]["data"];

/***/ }),

/***/ "@wordpress/element":
/*!*********************************!*\
  !*** external ["wp","element"] ***!
  \*********************************/
/***/ ((module) => {

module.exports = window["wp"]["element"];

/***/ }),

/***/ "@wordpress/i18n":
/*!******************************!*\
  !*** external ["wp","i18n"] ***!
  \******************************/
/***/ ((module) => {

module.exports = window["wp"]["i18n"];

/***/ }),

/***/ "./src/blocks/artcloud-authors/block.json":
/*!************************************************!*\
  !*** ./src/blocks/artcloud-authors/block.json ***!
  \************************************************/
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$schema":"https://raw.githubusercontent.com/WordPress/gutenberg/trunk/schemas/json/block.json","apiVersion":3,"name":"artcloud-blocks/artcloud-authors","version":"1.0.0","title":"ArtCloud Authors Block","category":"artcloud-blocks","description":"Dynamic authors block","keywords":["product","grid"],"supports":{"html":false},"textdomain":"artcloud-blocks","editorScript":"file:./index.js","editorStyle":"file:./index.css","style":"file:./style-index.css","attributes":{"title":{"type":"string","default":"Suosittuja blogeja"},"numberOfItems":{"type":"number","default":3},"displayAuthorImage":{"type":"boolean","default":true},"displayDescription":{"type":"boolean","default":true},"displayDateAuthor":{"type":"boolean","default":true},"postType":{"type":"string","default":"post"},"selectedAuthors":{"type":"array","default":[]},"backgroundColor":{"type":"string","default":"var(--wp--preset--color--yellow-green)"},"textColor":{"type":"string","default":"#000000"},"btnBackgroundColor":{"type":"string","default":"var(--wp--preset--color--primary)"},"btnTextColor":{"type":"string"}}}');

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = __webpack_modules__;
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/chunk loaded */
/******/ 	(() => {
/******/ 		var deferred = [];
/******/ 		__webpack_require__.O = (result, chunkIds, fn, priority) => {
/******/ 			if(chunkIds) {
/******/ 				priority = priority || 0;
/******/ 				for(var i = deferred.length; i > 0 && deferred[i - 1][2] > priority; i--) deferred[i] = deferred[i - 1];
/******/ 				deferred[i] = [chunkIds, fn, priority];
/******/ 				return;
/******/ 			}
/******/ 			var notFulfilled = Infinity;
/******/ 			for (var i = 0; i < deferred.length; i++) {
/******/ 				var [chunkIds, fn, priority] = deferred[i];
/******/ 				var fulfilled = true;
/******/ 				for (var j = 0; j < chunkIds.length; j++) {
/******/ 					if ((priority & 1 === 0 || notFulfilled >= priority) && Object.keys(__webpack_require__.O).every((key) => (__webpack_require__.O[key](chunkIds[j])))) {
/******/ 						chunkIds.splice(j--, 1);
/******/ 					} else {
/******/ 						fulfilled = false;
/******/ 						if(priority < notFulfilled) notFulfilled = priority;
/******/ 					}
/******/ 				}
/******/ 				if(fulfilled) {
/******/ 					deferred.splice(i--, 1)
/******/ 					var r = fn();
/******/ 					if (r !== undefined) result = r;
/******/ 				}
/******/ 			}
/******/ 			return result;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/jsonp chunk loading */
/******/ 	(() => {
/******/ 		// no baseURI
/******/ 		
/******/ 		// object to store loaded and loading chunks
/******/ 		// undefined = chunk not loaded, null = chunk preloaded/prefetched
/******/ 		// [resolve, reject, Promise] = chunk loading, 0 = chunk loaded
/******/ 		var installedChunks = {
/******/ 			"blocks/artcloud-authors/index": 0,
/******/ 			"blocks/artcloud-authors/style-index": 0
/******/ 		};
/******/ 		
/******/ 		// no chunk on demand loading
/******/ 		
/******/ 		// no prefetching
/******/ 		
/******/ 		// no preloaded
/******/ 		
/******/ 		// no HMR
/******/ 		
/******/ 		// no HMR manifest
/******/ 		
/******/ 		__webpack_require__.O.j = (chunkId) => (installedChunks[chunkId] === 0);
/******/ 		
/******/ 		// install a JSONP callback for chunk loading
/******/ 		var webpackJsonpCallback = (parentChunkLoadingFunction, data) => {
/******/ 			var [chunkIds, moreModules, runtime] = data;
/******/ 			// add "moreModules" to the modules object,
/******/ 			// then flag all "chunkIds" as loaded and fire callback
/******/ 			var moduleId, chunkId, i = 0;
/******/ 			if(chunkIds.some((id) => (installedChunks[id] !== 0))) {
/******/ 				for(moduleId in moreModules) {
/******/ 					if(__webpack_require__.o(moreModules, moduleId)) {
/******/ 						__webpack_require__.m[moduleId] = moreModules[moduleId];
/******/ 					}
/******/ 				}
/******/ 				if(runtime) var result = runtime(__webpack_require__);
/******/ 			}
/******/ 			if(parentChunkLoadingFunction) parentChunkLoadingFunction(data);
/******/ 			for(;i < chunkIds.length; i++) {
/******/ 				chunkId = chunkIds[i];
/******/ 				if(__webpack_require__.o(installedChunks, chunkId) && installedChunks[chunkId]) {
/******/ 					installedChunks[chunkId][0]();
/******/ 				}
/******/ 				installedChunks[chunkId] = 0;
/******/ 			}
/******/ 			return __webpack_require__.O(result);
/******/ 		}
/******/ 		
/******/ 		var chunkLoadingGlobal = globalThis["webpackChunkartcloud_blocks"] = globalThis["webpackChunkartcloud_blocks"] || [];
/******/ 		chunkLoadingGlobal.forEach(webpackJsonpCallback.bind(null, 0));
/******/ 		chunkLoadingGlobal.push = webpackJsonpCallback.bind(null, chunkLoadingGlobal.push.bind(chunkLoadingGlobal));
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module depends on other loaded chunks and execution need to be delayed
/******/ 	var __webpack_exports__ = __webpack_require__.O(undefined, ["blocks/artcloud-authors/style-index"], () => (__webpack_require__("./src/blocks/artcloud-authors/index.js")))
/******/ 	__webpack_exports__ = __webpack_require__.O(__webpack_exports__);
/******/ 	
/******/ })()
;
//# sourceMappingURL=index.js.map