jQuery(document).ready(function ($) {
	$("#load_more_posts-style1").on("click", function (e) {
		e.preventDefault();
		let offset = $(this).data("offset") || 3;
		let attributes = $(this).data("attributes");
		$(this).html("Ladataan..");
		load_posts('#load_more_posts-style1', 'style1', offset, attributes);
	});
	$("#load_more_posts-style2").on("click", function (e) {
		e.preventDefault();
		let offset = $(this).data("offset") || 3;
		let attributes = $(this).data("attributes");
		$(this).html("Ladataan..");
		load_posts('#load_more_posts-style2', 'style2', offset, attributes);
	});

	function load_posts(loadBtnId, styleId, offset, attributes) {
		fetch(`../wp-json/wp/v2/posts?per_page=3&offset=${offset}&order=${attributes.order}&orderby=${attributes.orderBy}`)
			.then((response) => response.json())
			.then((data) => {
				data.forEach((post) => {
					//
					function formatDate(isoDate) {
						var parts = isoDate.split("T")[0].split("-");
						var formattedDate = parts[2] + "." + parts[1] + "." + parts[0];
						return formattedDate;
					}
					var isoDate = post.date;
					var style1Date = formatDate(isoDate);

					function formatDateTime(isoDateTime) {
						var parts = isoDateTime.split("T");
						var dateParts = parts[0].split("-");
						var timeParts = parts[1].split(":");
						var formattedDate = dateParts[2] + "." + dateParts[1] + "." + dateParts[0];
						var formattedTime = timeParts[0] + ":" + timeParts[1] + ":" + timeParts[2];
						return formattedDate + " " + formattedTime;
					}
					var isoDateTime = post.date;
					var style2DateTime = formatDateTime(isoDateTime);
					//
					let style1Content = post.content.rendered.split(" ").slice(0, 8).join(" ") + "...";
					let style2Content = post.content.rendered.split(" ").slice(0, 25).join(" ") + "...";
					let defaultImagePath = window.location.origin + '/wp-content/plugins/artcloud-blocks/assets/img/default-image.jpg';
					let defaultImage = `<img width="300" height="183" src="${defaultImagePath}" class="attachment-medium size-medium wp-post-image" alt="" decoding="async" loading="lazy" />`
					$('#loadPost-' + styleId + ' .row').append(`
                    <div class="col-4">
                    <div class ="artcloud-item">
                    ${attributes.displayFeaturedImage ? `<div class="artcloud-postImg">${post.featuredImage ? post.featuredImage : defaultImage}</div>` : ''}
                    <div class="artcloud-content">
					${attributes.displayDateAuthor ? `<h6 style="color:${attributes.textColor}">
						${styleId === 'style1' ? style1Date + ' | ' + post.authorName : style2DateTime + ' | ' + post.authorName}</h6>` : ''}
                    <a href="${post.link}"><h3 style="color:${attributes.textColor}">${post.title.rendered}</h3></a>
                    ${attributes.displayDescription ? `${styleId === 'style1' ? `<p style="color:${attributes.textColor}">${style1Content}</p>` : `<p style="color:${attributes.textColor}">${style2Content}</p>`}` : ''}
						${styleId === 'style1' ? `<a style="background-color:${attributes.btnBackgroundColor};color:${attributes.btnTextColor}" href="${post.link}" class="item-btns wp-block-post-excerpt__more-link">Lue lisää</a>` : ''}
						</div></div></div>`);
				});
				offset += 3;
				$(loadBtnId).data("offset", offset);
				$(loadBtnId).html("Näytä lisää");
				if (data.length < 3) {
					$(loadBtnId).css("display", "none");
				}
			})
			.catch((error) => {
				console.error(error);
			});
	};
});
