import { registerBlockType } from '@wordpress/blocks';
import './style.scss';
import { __ } from '@wordpress/i18n';
import Edit from './edit';
import save from './save';
import metadata from './block.json';

const iconPosts = {
    src: (
        <svg id="Layer_2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 29.91 28.91">
            <defs>
                <style>{`.cls-1{fill:var(--wp--preset--color--white);stroke-width:0px;}`}</style>
            </defs>
            <g id="Layer_1-2">
                <path class="cls-1" d="m23.49,15.03H6.08c-.39,0-.71.32-.71.71s.32.71.71.71h17.42c.39,0,.71-.32.71-.71s-.32-.71-.71-.71Z"/>
                <path class="cls-1" d="m23.49,19.18H6.08c-.39,0-.71.32-.71.71s.32.71.71.71h17.42c.39,0,.71-.32.71-.71s-.32-.71-.71-.71Z"/>
                <path class="cls-1" d="m9.01,22.91h-2.94c-.39,0-.71.32-.71.71s.32.71.71.71h2.94c.39,0,.71-.32.71-.71s-.32-.71-.71-.71Z"/>
                <path class="cls-1" d="m29.2,0H.71c-.39,0-.71.32-.71.71v27.49c0,.39.32.71.71.71h28.49c.39,0,.71-.32.71-.71V.71c0-.39-.32-.71-.71-.71Zm-.71,1.42v9.55c-.11-.07-.23-.12-.37-.12H1.42V1.42h27.07ZM1.42,27.49v-15.22h26.71c.14,0,.26-.05.37-.12v15.33H1.42Z"/>
            </g>
        </svg>
    ),
    background: 'var(--wp--preset--color--primary)',
    foreground: 'var(--wp--preset--color--white)'
};

registerBlockType(metadata.name, {
    title: __('Artcloud Posts Block', 'artcloud-blocks'),
    description: __('Show posts and events', 'artcloud-blocks'),
    icon: iconPosts,
    edit: Edit,
    save: save,
});
