/* eslint-disable react/jsx-no-target-blank */
/* eslint-disable no-shadow */
/* eslint-disable @wordpress/no-unsafe-wp-apis */
const { Fragment } = wp.element;
import {
	InnerBlocks,
	InspectorControls,
	RichText,
	useBlockProps,
} from '@wordpress/block-editor';
import {
	ColorPalette,
	PanelBody,
	RangeControl,
	SelectControl,
	ToggleControl,
	__experimentalBoxControl as BoxControl,
	__experimentalBorderControl as BorderControl,
	TextControl,
} from '@wordpress/components';
const { __ } = wp.i18n;

import colors from '../colors';
import icons from './icons';
import tags from '../tags';

// include editor styles
import './editor.scss';

const iconPositions = [
	{
		label: 'Left',
		value: 'artcloud-blocks_left_icon',
	},
	{
		label: 'Right',
		value: 'artcloud-blocks_right_icon',
	},
];

const Edit = ({ attributes, setAttributes, clientId }) => {
	const {
		uniqueId,
		makeActive,
		border,
		margins,
		paddings,
		borderRadius,
		heading,
		headingTag,
		headingColor,
		showIcon,
		iconClass,
		iconPosition,
		iconColor,
		iconBackground,
		headerBg,
		bodyBg,
		id,
		linkedPhase,
		link,
		tab,
		disablePhase,
	} = attributes;

	// set unique ID
	setAttributes({
		uniqueId: clientId.slice(0, 8),
	});

	return (
		<Fragment>
			<InspectorControls>
				<PanelBody
					initialOpen={false}
					title={__('Phase ID', 'artcloud-blocks')}
				>
					<TextControl
						label={__(
							'Set Phase ID',
							'artcloud-blocks'
						)}
						value={id}
						onChange={(id) => setAttributes({ id })}
					/>
				</PanelBody>
				<PanelBody
					initialOpen={false}
					title={__('Phase Status', 'artcloud-blocks')}
				>
					{linkedPhase !== true && (
						<ToggleControl
							label={__(
								'Make it Active on Load',
								'artcloud-blocks'
							)}
							checked={makeActive}
							onChange={() =>
								setAttributes({ makeActive: !makeActive })
							}
						/>
					)}
					{linkedPhase !== true && (
						<ToggleControl
							label={__(
								'Make it a Disable Phase?',
								'artcloud-blocks'
							)}
							checked={disablePhase}
							onChange={() =>
								setAttributes({
									disablePhase: !disablePhase,
								})
							}
							help={__(
								'No click event works. This feature is for the frontend only!',
								'artcloud-blocks'
							)}
						/>
					)}
					<ToggleControl
						label={__(
							'Turn it into a Linked Phase?',
							'artcloud-blocks'
						)}
						checked={linkedPhase}
						onChange={() =>
							setAttributes({ linkedPhase: !linkedPhase })
						}
						help={__(
							'Linked Phase disable the Phase Body and open the link when it is clicked.',
							'artcloud-blocks'
						)}
					/>
					{linkedPhase && (
						<Fragment>
							<TextControl
								label={__(
									'Link URL',
									'artcloud-blocks'
								)}
								value={link}
								onChange={(link) => setAttributes({ link })}
							/>
							<ToggleControl
								label={__(
									'Open in new tab?',
									'artcloud-blocks'
								)}
								checked={tab}
								onChange={() =>
									setAttributes({
										tab: !tab,
									})
								}
							/>
						</Fragment>
					)}
				</PanelBody>
				<PanelBody
					initialOpen={false}
					title={__('Phase Settings', 'artcloud-blocks')}
				>
					<BoxControl
						values={margins}
						label={__(
							'Phase Margin',
							'artcloud-blocks'
						)}
						sides={['top', 'bottom']}
						units={[]}
						allowReset={false}
						onChange={(newValue) =>
							setAttributes({
								...margins,
								margins: {
									top: newValue.top,
									bottom: newValue.bottom,
								},
							})
						}
					/>
					<div className="aa-custom-spacer"></div>
					<BoxControl
						values={paddings}
						label={__(
							'Content Padding',
							'artcloud-blocks'
						)}
						sides={['horizontal', 'vertical']}
						units={[]}
						splitOnAxis={true}
						allowReset={false}
						onChange={(newValue) =>
							setAttributes({
								...paddings,
								paddings: {
									top: newValue.top,
									left: newValue.left,
									right: newValue.right,
									bottom: newValue.bottom,
								},
							})
						}
					/>
					<div className="aa-custom-spacer"></div>
					<BorderControl
						colors={colors}
						label={__(
							'Set Phase Border',
							'artcloud-blocks'
						)}
						onChange={(value) => setAttributes({ border: value })}
						value={border}
						withSlider={true}
					/>
					<div className="aa-custom-spacer"></div>
					<RangeControl
						label={__('Border Radius', 'artcloud-blocks')}
						value={borderRadius}
						onChange={(borderRadius) =>
							setAttributes({ borderRadius })
						}
						min={0}
						max={50}
					/>
				</PanelBody>
				<PanelBody
					initialOpen={false}
					title={__('Phase Head', 'artcloud-blocks')}
				>
					<p className="artcloud-blocks__label">
						{__('Header Color', 'artcloud-blocks')}
					</p>
					<ColorPalette
						colors={colors}
						value={headingColor}
						onChange={(headingColor) =>
							setAttributes({ headingColor })
						}
					/>
					<p className="artcloud-blocks__label">
						{__('Header Background', 'artcloud-blocks')}
					</p>
					<ColorPalette
						colors={colors}
						value={headerBg}
						onChange={(headerBg) => setAttributes({ headerBg })}
					/>
					<SelectControl
						label={__(
							'Select Heading Tag',
							'artcloud-blocks'
						)}
						options={tags}
						onChange={(headingTag) => setAttributes({ headingTag })}
						value={headingTag}
					/>
				</PanelBody>
				<PanelBody
					title={__('Phase Icon', 'artcloud-blocks')}
					initialOpen={false}
				>
					<ToggleControl
						label={__('Show Icon', 'artcloud-blocks')}
						checked={showIcon}
						onChange={() => setAttributes({ showIcon: !showIcon })}
					/>
					{showIcon && (
						<Fragment>
							<SelectControl
								label={__(
									'Select Icon Type',
									'artcloud-blocks'
								)}
								options={icons}
								onChange={(iconClass) => {
									setAttributes({ iconClass });
								}}
								value={iconClass}
							/>
							<SelectControl
								label={__(
									'Icon Position',
									'artcloud-blocks'
								)}
								options={iconPositions}
								onChange={(iconPosition) => {
									setAttributes({ iconPosition });
								}}
								value={iconPosition}
							/>
							<p className="artcloud-blocks__label">
								{__('Icon Color', 'artcloud-blocks')}
							</p>
							<ColorPalette
								colors={colors}
								value={iconColor}
								onChange={(iconColor) =>
									setAttributes({ iconColor })
								}
							/>
							<p className="artcloud-blocks__label">
								{__(
									'Icon Background',
									'artcloud-blocks'
								)}
							</p>
							<ColorPalette
								colors={colors}
								value={iconBackground}
								onChange={(iconBackground) =>
									setAttributes({ iconBackground })
								}
							/>
						</Fragment>
					)}
				</PanelBody>
				<PanelBody
					title={__('Phase Body', 'artcloud-blocks')}
					initialOpen={false}
				>
					<p className="artcloud-blocks__label">
						{__('Background Color', 'artcloud-blocks')}
					</p>
					<ColorPalette
						colors={colors}
						value={bodyBg}
						onChange={(bodyBg) => setAttributes({ bodyBg })}
					/>
				</PanelBody>
			</InspectorControls>
			<div
				{...useBlockProps({
					className: `artcloud-blocks__phase_container ${
						makeActive
							? `active__phase_container_${uniqueId}`
							: ''
					}`,
				})}
				style={{
					border: `${border.width} ${border.style} ${border.color}`,
					marginTop: `${margins.top}`,
					marginBottom: `${margins.bottom}`,
					borderRadius: `${borderRadius}px`,
				}}
				id={id !== '' ? id : ''}
			>
				{linkedPhase ? (
					<Fragment>
						<a
							href={link}
							target={tab ? '_blank' : '_self'}
							rel={tab ? 'noopener noreferrer' : 'noopener'}
							className="artcloud-blocks__phase_link"
						>
							<div
								className={`artcloud-blocks__phase_head ${iconPosition}`}
								style={{
									color: headingColor
										? headingColor
										: '#333333',
									backgroundColor: headerBg
										? headerBg
										: 'transparent',
									padding: `${paddings.top} ${paddings.left} ${paddings.bottom} ${paddings.right}`,
								}}
							>
								<div
									className={`artcloud-blocks__phase_heading ${iconPosition}`}
								>
									<RichText
										tagName={headingTag}
										value={heading}
										className="artcloud-blocks__phase_title"
										onChange={(heading) =>
											setAttributes({ heading })
										}
										style={{
											margin: 0,
											color: headingColor
												? headingColor
												: '#333333',
										}}
									/>
								</div>
								{showIcon && (
									<div
										className={`artcloud-blocks__phase_icon`}
										style={{
											color: iconColor
												? iconColor
												: '#333333',
											backgroundColor: iconBackground
												? iconBackground
												: 'transparent',
										}}
									>
										<span
											className={`artcloud-blocks__icon dashicons dashicons-${iconClass}`}
										></span>
									</div>
								)}
							</div>
						</a>
					</Fragment>
				) : (
					<Fragment>
						<div
							className={`artcloud-blocks__phase_head ${iconPosition}`}
							style={{
								color: headingColor ? headingColor : '#333333',
								backgroundColor: headerBg
									? headerBg
									: 'transparent',
								padding: `${paddings.top} ${paddings.left} ${paddings.bottom} ${paddings.right}`,
							}}
						>
							<div
								className={`artcloud-blocks__phase_heading ${iconPosition}`}
							>
								<RichText
									tagName={headingTag}
									value={heading}
									className="artcloud-blocks__phase_title"
									onChange={(heading) =>
										setAttributes({ heading })
									}
									style={{
										margin: 0,
										color: headingColor
											? headingColor
											: '#333333',
									}}
								/>
							</div>
							{showIcon && (
								<div
									className={`artcloud-blocks__phase_icon`}
									style={{
										color: iconColor
											? iconColor
											: '#333333',
										backgroundColor: iconBackground
											? iconBackground
											: 'transparent',
									}}
								>
									<span
										className={`artcloud-blocks__icon dashicons dashicons-${iconClass}`}
									></span>
								</div>
							)}
						</div>
						<div
							className={`artcloud-blocks__phase_body ${
								makeActive
									? `active__phase_${uniqueId}`
									: ''
							}`}
							role="region"
							style={{
								backgroundColor: bodyBg
									? bodyBg
									: 'transparent',
								borderTop: `${border.width} ${border.style} ${border.color}`,
								padding: `${paddings.top} ${paddings.left} ${paddings.bottom} ${paddings.right}`,
							}}
						>
							<InnerBlocks
								allowedBlocks={true}
								template={[
									[
										'core/paragraph',
										{
											placeholder:
												'Write your content or add any block here...',
										},
									],
								]}
							/>
						</div>
					</Fragment>
				)}
			</div>
		</Fragment>
	);
};
export default Edit;
