<?php
// Register REST API fields for a custom post type
function artcloud_people_register_custom_post_meta_fields()
{
    // Replace 'your_post_type' with the actual name of your custom post type
    $post_type = 'person';
    // Define the callback function to retrieve and sanitize the custom fields
    $get_callback = function ($object, $field_name, $request) {
        $post_id = $object['id'];
        $people_title = get_post_meta($post_id, '_people_title', true);
        $people_phone = get_post_meta($post_id, '_people_phone', true);
        $people_email = get_post_meta($post_id, '_people_email', true);
        $people_city = get_post_meta($post_id, '_people_city', true);
        $rank_number = get_post_meta($post_id, '_rank_number', true);
        $home = get_post_meta($post_id, '_homepage_url', true);
        $twitter = get_post_meta($post_id, '_twitter_url', true);
        $facebook = get_post_meta($post_id, '_facebook_url', true);
        $linkedin = get_post_meta($post_id, '_linkedin_url', true);
        $instagram = get_post_meta($post_id, '_intagram_url', true);
        $data = array(
            'people_title'  => $people_title,
            'people_phone'  => $people_phone,
            'people_email'  => $people_email,
            'people_city'   => $people_city,
            'rank_number'   => $rank_number,
            'home'          => $home,
            'twitter'       => $twitter,
            'facebook'      => $facebook,
            'linkedin'      => $linkedin,
            'instagram'     => $instagram,
        );
        return $data;
    };
    // Register the REST API field for the custom post type
    register_rest_field($post_type, 'person_meta_fields', array(
        'get_callback'    => $get_callback,
        'schema'          => null,
    ));
}
// Hook into the rest_api_init action
add_action('rest_api_init', 'artcloud_people_register_custom_post_meta_fields');
function register_group_term_meta()
{
    register_rest_field('group', 'rank_information', array(
        'get_callback'    => 'get_group_term_meta',
        'update_callback' => null,
        'schema'          => null,
    ));
}
function get_group_term_meta($object, $field_name, $request)
{
    return get_term_meta($object['id'], $field_name, true);
}
add_action('rest_api_init', 'register_group_term_meta');
function register_save_rank_information_endpoint()
{
    register_rest_route('persons_info/v1', '/save_rank_information/', array(
        'methods'             => 'POST',
        'callback'            => 'handle_save_rank_information',
        'permission_callback' => '__return_true', // Adjust permission callback as needed
    ));
}
function handle_save_rank_information($request)
{
    // Extract data from the request
    $term_id = (int) $request->get_param('term_id');
    $rank_information = $request->get_param('rank_information');
    // Save the term meta
    update_term_meta($term_id, 'rank_information', maybe_serialize($rank_information));
    // Return a response if needed
    return new WP_REST_Response('Term meta saved successfully', 200);
}
add_action('rest_api_init', 'register_save_rank_information_endpoint');

//get latest board members
add_action('rest_api_init', function () {
    register_rest_route('persons_info/v1', '/get_posts_by_category/', array(
        'methods'  => 'GET',
        'callback' => 'get_posts_by_category',
    ));
});

function get_posts_by_category($data) {
    $term_id = $data['term_id'];

    $args = array(
        'post_type'      => 'person',
        'posts_per_page' => -1,
        'tax_query'      => array(
            array(
                'taxonomy' => 'group',
                'field'    => 'id',
                'terms'    => $term_id,
            ),
        ),
    );

    $posts = get_posts($args);

    return rest_ensure_response($posts);
}

// Update person data
add_action('wp_ajax_update_person_data', 'update_person_data');
add_action('wp_ajax_nopriv_update_person_data', 'update_person_data');
function update_person_data() {
  $person_meta_fields = isset($_POST['data']) ? $_POST['data'] : array();
  $post_id = $person_meta_fields['post_id'];
  foreach ($person_meta_fields as $key => $value) {
    update_post_meta($post_id, $key, $value);
  }
  wp_send_json_success('Person data updated successfully.');
  wp_die();
}
