<?php
require_once('artcloud-peoples-rest-api.php');
global $social_icon_svg;
$social_icon_svg = array(
	'home' => '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="17.922" height="17.922" viewBox="0 0 17.922 17.922">
    <defs>
      <clipPath id="clip-path">
        <rect id="Rectangle_649" data-name="Rectangle 649" width="10.319" height="10.43" fill="#fff"/>
      </clipPath>
    </defs>
    <g id="Group_829" data-name="Group 829" transform="translate(-276 -548)">
      <path id="Subtraction_18" data-name="Subtraction 18" d="M16.933,0H.988A.989.989,0,0,0,0,.989V16.934a.989.989,0,0,0,.989.988H16.933a.989.989,0,0,0,.989-.989h0V.988A.989.989,0,0,0,16.933,0Zm0,0" transform="translate(276 548)" fill="var(--wp--preset--color--primary)"/>
      <g id="Group_741" data-name="Group 741" transform="translate(280 552)">
        <g id="Group_740" data-name="Group 740" clip-path="url(#clip-path)">
          <path id="Path_85" data-name="Path 85" d="M10.2,5.028,5.467.13a.427.427,0,0,0-.615,0L2.952,2.1a.238.238,0,0,1-.409-.166V1.464a.427.427,0,0,0-.427-.427H1.528a.427.427,0,0,0-.427.427V3.841a.428.428,0,0,1-.12.3l-.86.89a.427.427,0,0,0,.307.724H.673A.427.427,0,0,1,1.1,6.18V10a.427.427,0,0,0,.427.427H8.791A.427.427,0,0,0,9.218,10V6.18a.427.427,0,0,1,.427-.427h.245a.427.427,0,0,0,.307-.724" transform="translate(0 0)" fill="#fff"/>
        </g>
      </g>
    </g>
  </svg>',
	'linkedin' => '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="17.922" height="17.922" viewBox="0 0 17.922 17.922">
	<defs>
	  <clipPath id="clip-path">
		<rect id="Rectangle_871" data-name="Rectangle 871" width="1.433" height="9.358" fill="#fff"/>
	  </clipPath>
	</defs>
	<g id="Group_828" data-name="Group 828" transform="translate(-302 -548)">
	  <path id="Subtraction_19" data-name="Subtraction 19" d="M16.933,0H.988A.989.989,0,0,0,0,.989V16.934a.989.989,0,0,0,.989.988H16.933a.989.989,0,0,0,.989-.989h0V.988A.989.989,0,0,0,16.933,0Zm0,0" transform="translate(302 548)" fill="var(--wp--preset--color--primary)"/>
	  <g id="Group_827" data-name="Group 827" transform="translate(310 552)">
		<g id="Group_826" data-name="Group 826" clip-path="url(#clip-path)">
		  <path id="Path_285" data-name="Path 285" d="M1.687,36A.686.686,0,0,0,1,36.684v5.808a.686.686,0,0,0,1.372,0V36.684A.686.686,0,0,0,1.687,36" transform="translate(-0.94 -33.82)" fill="#fff"/>
		  <path id="Path_286" data-name="Path 286" d="M.053.948a.694.694,0,0,0,.063.119.717.717,0,0,0,.085.1.645.645,0,0,0,.1.085.719.719,0,0,0,.118.064.682.682,0,0,0,.129.039.666.666,0,0,0,.268,0A.69.69,0,0,0,.949,1.32a.719.719,0,0,0,.118-.064.62.62,0,0,0,.1-.085.69.69,0,0,0,.2-.485A.718.718,0,0,0,1.359.552.732.732,0,0,0,1.32.424.7.7,0,0,0,1.257.3.714.714,0,0,0,1.171.2a.654.654,0,0,0-.1-.085A.669.669,0,0,0,.949.053.692.692,0,0,0,.82.013.665.665,0,0,0,.686,0,.692.692,0,0,0,.2.2.714.714,0,0,0,.116.3.742.742,0,0,0,.053.424.732.732,0,0,0,.013.552a.682.682,0,0,0,0,.268A.716.716,0,0,0,.053.948" fill="#fff"/>
		</g>
	  </g>
	</g>
  </svg>',
	'instagram' => '<svg xmlns="http://www.w3.org/2000/svg" width="17.922" height="17.926" viewBox="0 0 17.922 17.926">
  <path id="Subtraction_13" data-name="Subtraction 13" d="M8.983,17.926h0a52.049,52.049,0,0,1-6.043-.215A3.426,3.426,0,0,1,.3,15.1a16.182,16.182,0,0,1-.276-4.5c.013-.507.027-1.081.027-1.637,0-.736-.007-1.4-.013-1.989V6.933C0,3.777-.01,2.47,1.169,1.245A3.392,3.392,0,0,1,3.045.216,17.743,17.743,0,0,1,6.517,0C7.1,0,7.747.005,8.493.012l.321,0c.954.008,1.9.014,2.981.014h.1a16.612,16.612,0,0,1,2.613.079l.023,0a3.846,3.846,0,0,1,2.3,1.154A4.233,4.233,0,0,1,17.9,3.9c.023.28.024,9.83,0,10.117a4.336,4.336,0,0,1-.935,2.49,3.671,3.671,0,0,1-1.926,1.2A51.958,51.958,0,0,1,8.983,17.926Zm0-2.581c.227,0,.458,0,.681,0s.451,0,.675,0c2.11,0,4.072-.175,4.895-2.285a10.519,10.519,0,0,0,.348-3.66c0-.213,0-.434,0-.662,0-.255,0-.5,0-.717.012-2.195.02-3.645-1.11-4.774-1.032-1.031-2.4-1.113-4.073-1.113l-.659,0h0c-.244,0-.495,0-.754,0-.218,0-.439,0-.652,0s-.424,0-.633,0a9.34,9.34,0,0,0-3,.349A3.145,3.145,0,0,0,2.735,4.424a10.528,10.528,0,0,0-.348,3.671q0,.314,0,.651,0,.274,0,.544a11.615,11.615,0,0,0,.348,3.778A3.142,3.142,0,0,0,4.7,15a9.339,9.339,0,0,0,3,.349c.209,0,.424,0,.632,0h0C8.55,15.347,8.768,15.345,8.985,15.345Zm1.5-1.181c-.232,0-.465,0-.713-.005s-.516-.006-.781-.006c-5.257,0-5.408-.152-5.408-5.41,0-2.7.11-4.016.759-4.7s1.773-.708,4.058-.71h.119c.33,0,.641,0,.941-.006.323,0,.628-.006.912-.006a11.1,11.1,0,0,1,1.982.126,2.23,2.23,0,0,1,1.251.613c.89.932.953,3.02.756,7.348C14.24,13.961,12.605,14.164,10.481,14.164ZM8.986,5.358a3.388,3.388,0,1,0,3.387,3.388A3.392,3.392,0,0,0,8.986,5.358Zm3.522-.926a.792.792,0,1,0,.791.792A.793.793,0,0,0,12.508,4.432ZM8.986,10.946a2.106,2.106,0,0,1-1.636-.688,2.368,2.368,0,0,1,0-3.024,2.108,2.108,0,0,1,1.637-.687,2.107,2.107,0,0,1,1.636.688,2.368,2.368,0,0,1,0,3.024A2.108,2.108,0,0,1,8.986,10.946Z" fill="var(--wp--preset--color--primary)"/>
 </svg>',
	'twitter' => '<svg xmlns="http://www.w3.org/2000/svg" width="17.537" height="17.922" viewBox="0 0 17.537 17.922">
  <path id="logo" d="M10.437,7.589,16.965,0H15.418L9.75,6.589,5.222,0H0L6.847,9.964,0,17.922H1.547l5.986-6.959,4.781,6.959h5.222l-7.1-10.333ZM8.318,10.052,7.624,9.06,2.1,1.165H4.481L8.935,7.536l.694.992,5.79,8.282H13.043L8.318,10.052Z" fill="var(--wp--preset--color--primary)"/>
 </svg>',
	'facebook' => '<svg xmlns="http://www.w3.org/2000/svg" width="17.922" height="17.922" viewBox="0 0 17.922 17.922">
  <path id="Subtraction_12" data-name="Subtraction 12" d="M9.573,17.922H.99A.99.99,0,0,1,0,16.934V.989A.991.991,0,0,1,.988,0H16.933a.99.99,0,0,1,.989.989V16.933a.99.99,0,0,1-.988.989h-4.56V10.991H14.71l.35-2.713H12.374V6.551c0-.791.228-1.318,1.341-1.318h1.424V2.813a19.251,19.251,0,0,0-2.087-.106,3.48,3.48,0,0,0-2.514.92,3.628,3.628,0,0,0-.965,2.656v2H7.246v2.713H9.573v6.931Z" fill="var(--wp--preset--color--primary)"/>
 </svg>',
);

function artcloud_peoples_render($attributes)
{
	global $social_icon_svg;
	// $args = array(
	// 	'post_type' => 'person',
	// 	'posts_per_page' => $attributes['numberOfPosts'],
	// 	'post_status' => 'publish',
	// 	'order' => $attributes['order'],
	// 	'orderby' => $attributes['orderBy'],
	// );
	// $argsAll = array(
	// 	'post_type' => 'person',
	// 	'posts_per_page' => $attributes['numberOfPosts'],
	// 	'post_status' => 'publish',
	// 	'order' => $attributes['order'],
	// 	'orderby' => $attributes['orderBy'],
	// );


	// if (isset($attributes['categories']) && !empty($attributes['categories'])) {
	// 	$category_ids = array_map(function ($category) {
	// 		return $category['id'];
	// 	}, $attributes['categories']);
	// 	if (!empty($category_ids)) {
	// 		$argsAll['tax_query'] = [
	// 			[
	// 				'taxonomy' => 'group',
	// 				'field' => 'term_id',
	// 				'terms' => $category_ids,
	// 			],
	// 		];
	// 	}
	// }

	// if (isset($attributes['categories']) && !empty($attributes['categories'])) {
	// 	$category_ids = array_map(function ($category) {
	// 		return $category['id'];
	// 	}, $attributes['categories']);

		// $selectedCategories = $attributes['checkedCategories'] ? $attributes['checkedCategories'] : $category_ids;

		// if (!empty($selectedCategories)) {
		// 	$args['tax_query'] = [
		// 		[
		// 			'taxonomy' => 'group',
		// 			'field' => 'term_id',
		// 			'terms' => $selectedCategories,
		// 		],
		// 	];
		// }
	// }
	$argsMembers = array(
		'post_type' => 'person',
		'posts_per_page' => $attributes['numberOfPosts'],
		'post_status' => 'publish',
		'order' => $attributes['order'],
		'orderby' => $attributes['orderBy'],
	);

	if (isset($attributes['categories']) && !empty($attributes['categories'])) {
		$category_ids = array_map(function ($category) {
			return $category['id'];
		}, $attributes['categories']);

		$selectedCategories = $attributes['checkedCategories'] ? $attributes['checkedCategories'] : $category_ids;

		if (!empty($selectedCategories)) {
			$argsMembers['tax_query'] = [
				[
					'taxonomy' => 'group',
					'field' => 'term_id',
					'terms' => $selectedCategories,
				],
			];
		}
		// if (!empty($category_ids)) {
		// 	$argsMembers['tax_query'] = [
		// 		[
		// 			'taxonomy' => 'group',
		// 			'field' => 'term_id',
		// 			'terms' => $category_ids,
		// 		],
		// 	];
		// }
	}
	$members = get_posts($argsMembers);
	$categoryID = $attributes['categories'] ? $attributes['categories'][0]['id'] : '';
	// $catID = $attributes['categories'] ? $attributes['categories'][0]['id'] : '';
	$serailizedrankInfo = get_term_meta($categoryID, 'rank_information', true);
	if (!empty($serailizedrankInfo)) {
		$unserializedRankInfo = unserialize($serailizedrankInfo);
		$rankInfoArray = [];
		$chunkSize = 4;
		for ($i = 0; $i < count($unserializedRankInfo); $i += $chunkSize) {
			$rankInfoArray[] = is_array($unserializedRankInfo[$i]) ? $unserializedRankInfo[$i] : array_slice($unserializedRankInfo, $i, $chunkSize);
		}
	}
	if (!empty($categoryID)) {
		$posts = '<div ' . get_block_wrapper_attributes() . '>';
		if (!empty($serailizedrankInfo)) {
			if ($attributes['categories'][0]['name']) {
				$posts .= '<h3 class="people-block-title">' . esc_html($attributes['categories'][0]['name']) . '</h3>';
			}
			if ($attributes['categories'][0]['description']) {
				$posts .= '<p class="people-block-desc">' . esc_html($attributes['categories'][0]['description']) . '</p>';
			}
			$posts .= '<div class="artcloud-select artcloud-people-wrappers">';
			$posts .= '<div class="row artcloud-search-row">';
			if (!function_exists('getNestedCategories')) {
				function getNestedCategories($child_categories, $indentation = '')
				{
					$output = [];
					if (!empty($child_categories)) {
						foreach ($child_categories as $child) {
							$termName = $child->name;
							$termID = $child->term_id;
							$child_category_ids[] = $termID;
							$output[] = [
								'id' => $termID,
								'name' => $termName,
								'indentation' => $indentation,
							];
							$nested_child_categories = get_terms(array(
								'taxonomy'   => 'group',
								'parent'     => $termID,
								'hide_empty' => true,
							));
							$nestedOutput = getNestedCategories($nested_child_categories, $indentation . '&nbsp;&nbsp;&nbsp;');
							$output = array_merge($output, $nestedOutput);
						}
					}
					return $output;
				}
			}
			$child_categories = get_terms(array(
				'taxonomy'   => 'group',
				'parent'     => $categoryID,
				'hide_empty' => true,
			));
			if ($attributes["displayDropdown"] && !empty($child_categories)) {
				$posts .= '<div class="col-6">';
				$posts .= '<div class="artcloud-select-wrapper">';
				$posts .= '<div class="artcloud-peoples-select-group">';
				$posts .= '<select name="artcloud-select" id="artcloud-select" class="components-select-control__input">';
				$posts .= '<option value="*">All Peoples</option>';

				$nestedCategoriesArray = getNestedCategories($child_categories);
				foreach ($nestedCategoriesArray as $category) {
					$posts .= '<option value="' . esc_attr($category['id']) . '">' . $category['indentation'] . esc_html($category['name']) . '</option>';
				}
				$posts .= '</select>';
				$posts .= '</div>';
				$posts .= '</div>';
				$posts .= '</div>';
			}
			if ($attributes["displaySearchOption"]) {
				$posts .= '<div class="col-6">';
				$posts .= '<div class="artcloud-search-wrapper">';
				$posts .= '<div class="artcloud-search">';
				$posts .= '<input type="text" id="search" name="search" placeholder="Hae henkilöitä"> <span>Hae</span>';
				$posts .= '</div>';
				$posts .= '</div>';
				$posts .= '</div>';
			}
			if (!$attributes["displayDropdown"] && !empty($child_categories)) {
				$posts .= '<div class="col-12">';
				$posts .= '<div class="artcloud-search-wrapper">';
				$posts .= '<div class="artcloud-tabs">';
				$posts .= '<ul class="artcloud-tabView">';
				$posts .= '<li><a href="#" class="artcloud-tabItem active" data-id="*">All</a></li>';
				$nestedCategoriesArray = getNestedCategories($child_categories);
				foreach ($nestedCategoriesArray as $category) {
					$posts .= '<li> <a href="#" class="artcloud-tabItem" data-id="' . esc_attr($category['id']) . '">' . esc_html($category['name']) . '</a></li>';
				}
				$posts .= '</ul>';
				$posts .= '</div>';
				$posts .= '</div>';
				$posts .= '</div>';
			}
			$posts .= '</div>';
			$posts .= '</div>';
			$posts .= '<hr>';
			$posts .= '<div class="row artcloud-row">';
			foreach ($members as $post) {
				$post_id = $post->ID;
				$child_category_ids = array();
				$terms = get_the_terms($post_id, 'group');
				if ($terms && !is_wp_error($terms)) {
					foreach ($terms as $term) {
						if ($term->parent) {
							$child_category_ids[] = $term->term_id;
						}
					}
				}
				// $matchfound = false;
				if (!empty($rankInfoArray) && !empty($rankInfoArray[0])) {
					foreach ($rankInfoArray as $rankInfo) {
						if (isset($rankInfo[2]) && $rankInfo[2] == $post_id) {
							// $matchfound = true;
							break;
						}
					}
				}
				$styleOrder = 99999;
				if (!empty($rankInfo)) {
					$styleOrder = ($rankInfo[2] == $post_id && !empty($rankInfo)) ? $rankInfo[0] : 1000000;
				}
				$posts .= '<div class="col-' . $attributes["selectedValue"] . " " . ($attributes["selectedValue"] === '4' || $attributes["selectedValue"] === '3' ? 'vertical' : 'horizontal') . ' peoples-filter" data-category="' . esc_attr(implode(', ', $child_category_ids)) . '" style="order:' . (isset($styleOrder) ? $styleOrder : 1000000)  . '">';
				$posts .= '<div class="artcloud-peoples-item">';
				$title = get_the_title($post);
				$title = $title ? $title : __('(No title)', 'artcloud-blocks');
				$permalink = get_permalink($post_id);
				$people_title = get_post_meta($post_id, '_people_title', true);
				$people_phone = get_post_meta($post_id, '_people_phone', true);
				$people_email = get_post_meta($post_id, '_people_email', true);
				$people_city = get_post_meta($post_id, '_people_city', true);
				$rank_number = get_post_meta($post->ID, '_rank_number', true);
				//social media link
				$home = get_post_meta($post_id, '_homepage_url', true);
				$twitter = get_post_meta($post_id, '_twitter_url', true);
				$facebook = get_post_meta($post_id, '_facebook_url', true);
				$linkedin = get_post_meta($post_id, '_linkedin_url', true);
				$instagram = get_post_meta($post_id, '_intagram_url', true);

				$posts .= '<div class="artcloud-peoples-image">';
				if ($attributes["displayFeaturedImage"] && has_post_thumbnail($post_id)) {
					$posts .= get_the_post_thumbnail($post_id, 'thumbnail');
				}
				$posts .= '</div>';
				$posts .= '<div class="artcloud-peoples-content">';
				$posts .= '<h5><a href="' . ($attributes["displayProfileLink"] ? esc_url($permalink) : '#') . '">' . $title . '</a></h5>';
				if ($attributes["displayDesignation"]) {
					if (!empty($rankInfo)) {
						$posts .= $rankInfo[2] == $post_id && !empty($rankInfo[1]) ? '<p>' . $rankInfo[1] . '</a></p>' : '';
					}
				}
				if ($attributes["displayTitle"]) {
					$posts .= !empty($people_title) ? '<p>' . $people_title . '</a></p>' : '';
				}
				if ($attributes["displayCity"]) {
					$posts .= !empty($people_city) ? '<p>' . $people_city . '</a></p>' : '';
				}
				if ($attributes["displayPhone"]) {
					$posts .= !empty($people_phone) ? '<p>' . $people_phone . '</a></p>' : '';
				}
				if ($attributes["displayEmail"]) {
					$posts .= !empty($people_email) ? '<p>' . $people_email . '</a></p>' : '';
				}
				$posts .= '<div class="social-link">';
				if ($attributes["displayHomeLink"]) {
					$posts .= !empty($home) ? '<a href="' . esc_url($home) . '">' . $social_icon_svg['home'] . '</a>' : '';
				}
				if ($attributes["displaySocialLink"]) {
					$posts .= !empty($twitter) ? '<a href="' . esc_url($twitter) . '">' . $social_icon_svg['twitter'] . '</a>' : '';
					$posts .= !empty($facebook) ? '<a href="' . esc_url($facebook) . '">' . $social_icon_svg['facebook'] . '</a>' : '';
					$posts .= !empty($linkedin) ? '<a href="' . esc_url($linkedin) . '">' . $social_icon_svg['linkedin'] . '</a>' : '';
					$posts .= !empty($instagram) ? '<a href="' . esc_url($instagram) . '">' . $social_icon_svg['instagram'] . '</a>' : '';
				}
				if ($attributes["displayRankNumber"]) {
					$posts .= !empty($rank_number) ? '<h6 class="rank_number">' . $rank_number . '</a></h6>' : '';
				}
				$posts .= '</div>';
				if ($attributes["displayVaralla"]) {
					if (!empty($rankInfo)) {
						if ($rankInfo[2] == $post_id) {
							if (isset($rankInfo[3]) && $rankInfo[3]) {
								$posts .= '<hr><div className="artcloud-peoples-name">';
								$posts .= '<h6>Varalla </h6>';
								$posts .= '<p>';
								$posts .= get_the_title($rankInfo[3]);
								$posts .= '</p>';
								$posts .= '</div>';
							}
						}
					}
				}
				$posts .= '</div>';
				$posts .= '</div>';
				$posts .= '</div>';
			}
			$posts .= '</div>';
		}
		return $posts;
	} else{
		return '<p>' . __('Person not found', 'artcloud-blocks') . '</p>';
	}
}
