jQuery(document).ready(function ($) {
    $('.peoples-filter').show();
    $('#artcloud-select').change(function () {
        var selectedCategory = $(this).val();
        filterItems(selectedCategory);
    });

    $('.artcloud-tabView li').on('click', function (e) {
        e.preventDefault();
        var selectedCategory = $(this).find('.artcloud-tabItem').data('id');
        $(this).siblings().find('.artcloud-tabItem').removeClass('active');
        $(this).find('.artcloud-tabItem').addClass('active');
        filterItemsLI(selectedCategory);
    });
    function filterItemsLI(selectedCategory) {
        if (selectedCategory === '*') {
            $('.peoples-filter').show();
        } else {
            $('.peoples-filter').hide();
            $('.peoples-filter.member').show();
                $('.peoples-filter[data-category*="' + selectedCategory + '"]').show();
        }
    }
    function filterItems(selectedCategory) {
        if (selectedCategory === '*') {
            $('.peoples-filter').show();
        } else {
            $('.peoples-filter').hide();
            $('.peoples-filter.member').show();

            // Split the selected categories into an array
            var selectedCategoriesArray = selectedCategory.split(',').map(function (item) {
                return item.trim();
            });

            // Show items if any one of the selected categories matches
            selectedCategoriesArray.forEach(function (category) {
                $('.peoples-filter[data-category*="' + category + '"]').show();
            });
        }
    }

    $('#search').on('input', function () {
        var searchValue = $(this).val().toLowerCase();
        filterItemsBySearch(searchValue);
    });
    function filterItemsBySearch(searchValue) {
        if (searchValue.trim() === '') {
            $('.peoples-filter').show();
        } else {
            $('.peoples-filter').hide();
            $('.peoples-filter.member').show();
            $('.peoples-filter:contains(' + searchValue + ')').show();
        }
    }

    jQuery.expr[':'].contains = function (a, i, m) {
        return jQuery(a).text().toUpperCase().indexOf(m[3].toUpperCase()) >= 0;
    };
});
