import { useBlockProps } from "@wordpress/block-editor";
import { useState } from "@wordpress/element";
const EditUserForm = ({  postId, closeEditModal}) => {

	const parentDiv = jQuery(`.artcloud-peoples-item.${postId}`);
	const [formData, setFormData] = useState({
		people_email: parentDiv.find('.people_email').text(),
		people_title: parentDiv.find('.people_title').text(),
		people_city: parentDiv.find('.people_city').text(),
		people_phone: parentDiv.find('.people_phone').text(),
		linkedin: parentDiv.find('a.people_linkedin').attr('href'),
		instagram: parentDiv.find('a.people_instagram').attr('href'),
		facebook: parentDiv.find('a.people_facebook').attr('href'),
		home: parentDiv.find('a.people_home').attr('href'),
		twitter: parentDiv.find('a.people_twitter').attr('href'),
		rank_number: parentDiv.find('.people_rank').text()
	});
	const handleChange = (event) => {
		const { name, value } = event.target;
		setFormData(prevFormData => ({
			...prevFormData,
			[name]: value
		}));
	};
	const savePeopleData = (event) => {
		event.preventDefault();
		const data = {
			post_id: postId,
			_people_email: formData.people_email,
			_people_title: formData.people_title,
			_people_city: formData.people_city,
			_people_phone: formData.people_phone,
			_linkedin_url: formData.linkedin,
			_instagram_url: formData.instagram,
			_facebook_url: formData.facebook,
			_home_url: formData.home,
			_twitter_url: formData.twitter,
			_rank_number: formData.rank_number
		};

		wp.ajax.post({
			url: wp.ajax.settings.url,
			action: 'update_person_data',
			data: data,
			dataType: 'json',
			success: function (response) {
				updateFormDataInDOM(postId, formData);
				closeEditModal();
			}
		});
	};

	function updateFormDataInDOM(postId, formData) {
		const parentDiv = jQuery(`.artcloud-peoples-item.${postId}`);
		const updateTextData = {
			'p.people_title': formData.people_title,
			'p.people_city': formData.people_city,
			'p.people_phone': formData.people_phone,
			'p.people_email': formData.people_email,
			'h6.people_rank': formData.rank_number
		};

		const updateHrefData = {
			'a.people_linkedin': formData.linkedin,
			'a.people_instagram': formData.instagram,
			'a.people_facebook': formData.facebook,
			'a.people_home': formData.home,
			'a.people_twitter': formData.twitter
		};

		// Update text content
		for (const selector in updateTextData) {
			parentDiv.find(selector).text(updateTextData[selector]);
		}

		// Update href attribute
		for (const selector in updateHrefData) {
			parentDiv.find(selector).attr('href', updateHrefData[selector]);
		}
	}

	return (
		<div {...useBlockProps()}>
			<div className="artcloud-row">
				<form action="" method="post" onSubmit={savePeopleData}>
					<div className="col-12">
					<label htmlFor="people_email">Email</label>
						<input type="email" name="people_email" id="people_email" value={formData.people_email} onChange={handleChange} />
					</div>
					<div className="col-12">
						<label htmlFor="people_title">Title</label>
						<input type="text" name="people_title" id="people_title" value={formData.people_title} onChange={handleChange} />
					</div>
					<div className="col-12">
						<label htmlFor="people_city">City</label>
						<input type="text" name="people_city" id="people_city" value={formData.people_city} onChange={handleChange} />
					</div>
					<div className="col-12">
						<label htmlFor="people_phone">Phone</label>
						<input type="tel" name="people_phone" id="people_phone" value={formData.people_phone} onChange={handleChange} />
					</div>
					<div className="col-12">
						<label htmlFor="linkedin">Linkedin</label>
						<input type="text" name="linkedin" id="linkedin" value={formData.linkedin} onChange={handleChange} />
					</div>
					<div className="col-12">
						<label htmlFor="instagram">Instagram</label>
						<input type="text" name="instagram" id="instagram" value={formData.instagram} onChange={handleChange} />
					</div>
					<div className="col-12">
						<label htmlFor="facebook">Facebook</label>
						<input type="text" name="facebook" id="facebook" value={formData.facebook} onChange={handleChange} />
					</div>
					<div className="col-12">
						<label htmlFor="home">Home</label>
						<input type="text" name="home" id="home" value={formData.home} onChange={handleChange} />
					</div>
					<div className="col-12">
						<label htmlFor="twitter">Twitter</label>
						<input type="text" name="twitter" id="twitter" value={formData.twitter} onChange={handleChange} />
					</div>
					<div className="col-12">
						<label htmlFor="rank_number">Rank</label>
						<input type="number" name="rank_number" id="rank_number" value={formData.rank_number} onChange={handleChange} />
					</div>
					<button className="components-button is-primary" type="submit">Save</button>
				</form>
			</div>
		</div>
	);
}

export default EditUserForm;
