import { registerBlockType } from '@wordpress/blocks';
import './style.scss';
import Edit from './edit';
import Save from './save';
import metadata from './block.json';
import { __ } from '@wordpress/i18n';

const kuvabanneriIcon = {
    src: (
        <svg id="Layer_2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 29.32 28.76">
            <g id="Layer_1-2" className="cls-1">
                <path d="m17.23,12.16h7.77c.39,0,.71-.32.71-.71s-.32-.71-.71-.71h-7.77c-.39,0-.71.32-.71.71s.32.71.71.71Z"/>
                <path d="m17.23,15.58h7.77c.39,0,.71-.32.71-.71s-.32-.71-.71-.71h-7.77c-.39,0-.71.32-.71.71s.32.71.71.71Z"/>
                <path d="m17.23,18.88h2.54c.39,0,.71-.32.71-.71s-.32-.71-.71-.71h-2.54c-.39,0-.71.32-.71.71s.32.71.71.71Z"/>
                <path d="m28.61,0H7.29c-.39,0-.71.32-.71.71v6.38H.71c-.39,0-.71.32-.71.71v13.15c0,.39.32.71.71.71h5.87v6.38c0,.39.32.71.71.71h21.33c.39,0,.71-.32.71-.71V.71c0-.39-.32-.71-.71-.71ZM1.42,8.51h11.73v11.73H1.42v-11.73Zm26.49,18.83H7.99v-5.68h5.87c.39,0,.71-.32.71-.71V7.8c0-.39-.32-.71-.71-.71h-5.87V1.42h19.91v25.92Z"/>
            </g>
        </svg>
    ),
    background: 'var(--wp--preset--color--primary)',
    foreground: 'var(--wp--preset--color--white)'
};

registerBlockType(metadata.name, {
    title: __( 'Artcloud Highlight Block', 'artcloud-blocks' ),
    description: __( 'Display single posts or events for highlight', 'artcloud-blocks' ),
    icon: kuvabanneriIcon,
    edit: Edit,
    save: Save,
});