import { registerBlockType } from '@wordpress/blocks';
import './style.scss';
import { __ } from '@wordpress/i18n';
import Edit from './edit';
import Save from './save';
import metadata from './block.json';

const heroIcon = {
	src: (
		<svg id="Layer_2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 29.95 28.64">
			<defs>
				<style>{`.cls-1{fill:var(--wp--preset--color--white);stroke-width:0px;}`}</style>
			</defs>
			<g id="Layer_1-2">
				<path className="cls-1" d="m4.79,11.39h6.07c.39,0,.71-.32.71-.71s-.32-.71-.71-.71h-6.07c-.39,0-.71.32-.71.71s.32.71.71.71Z" />
				<path className="cls-1" d="m4.79,15.35h6.07c.39,0,.71-.32.71-.71s-.32-.71-.71-.71h-6.07c-.39,0-.71.32-.71.71s.32.71.71.71Z" />
				<path className="cls-1" d="m4.79,19.23h1.31c.39,0,.71-.32.71-.71s-.32-.71-.71-.71h-1.31c-.39,0-.71.32-.71.71s.32.71.71.71Z" />
				<path className="cls-1" d="m10.24,17.81h-1.31c-.39,0-.71.32-.71.71s.32.71.71.71h1.31c.39,0,.71-.32.71-.71s-.32-.71-.71-.71Z" />
				<path className="cls-1" d="m29.24,0H0.71c-.39,0-.71.32-.71.71v27.22c0,.39.32.71.71.71h28.53c.39,0,.71-.32.71-.71V.71c0-.39-.32-.71-.71-.71Zm-.71,27.22H1.42V1.42h27.12v25.8Z" />
				<path className="cls-1" d="m15.8,19.86h8.72c.39,0,.71-.32.71-.71v-8.63c0-.39-.32-.71-.71-.71h-8.72c-.39,0-.71.32-.71.71v8.63c0,.39.32.71.71.71Zm.71-8.63h7.3v7.21h-7.3v-7.21Z" />
			</g>
		</svg>
	),
	background: 'var(--wp--preset--color--primary)',
	foreground: 'var(--wp--preset--color--white)'
};

registerBlockType(metadata.name, {
	title: __('ArtCloud Vihreät Hero', 'artcloud-blocks'),
	description: __('Hero block for fetch image, title & description', 'artcloud-blocks'),
	icon: heroIcon,
	edit: Edit,
	save: Save,
});

