import { registerBlockType } from '@wordpress/blocks';
import './style.scss';
import { __ } from '@wordpress/i18n';
/**
 * Internal dependencies
 */
import Edit from './edit';
import Save from './save';
import metadata from './block.json';

const iconComments = {
    src: (
        <svg id="Layer_2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 29.35 29.68">
            <defs>
                <style>{`.cls-1{fill:var(--wp--preset--color--white);stroke-width:0px;}`}</style>
            </defs>
            <g id="Layer_1-2">
                <path className="cls-1" d="m7.6,8.92h14.5c.39,0,.71-.32.71-.71s-.32-.71-.71-.71H7.6c-.39,0-.71.32-.71.71s.32.71.71.71Z"/>
                <path className="cls-1" d="m7.6,13.34h14.5c.39,0,.71-.32.71-.71s-.32-.71-.71-.71H7.6c-.39,0-.71.32-.71.71s.32.71.71.71Z"/>
                <path className="cls-1" d="m7.6,17.56h14.5c.39,0,.71-.32.71-.71s-.32-.71-.71-.71H7.6c-.39,0-.71.32-.71.71s.32.71.71.71Z"/>
                <path className="cls-1" d="m28.64,0H0.71c-.39,0-.71.32-.71.71v23.96c0,.39.32.71.71.71h19.25l4.09,4.09c.14.14.32.21.5.21.09,0,.18-.02.27-.05.27-.11.44-.37.44-.65v-3.59h3.39c.39,0,.71-.32.71-.71V0.71c0-.39-.32-.71-.71-.71Zm-.71,23.96h-3.39c-.39,0-.71.32-.71.71,0,.01,0,.03,0,.04,0,.01,0,.03,0,.04v2.5l-3.03-3.03c-.09-.09-.2-.14-.32-.17-.1-.05-.21-.09-.33-.09H1.42V1.42h26.52v22.55Z"/>
            </g>
        </svg>
    ),
    background: 'var(--wp--preset--color--primary)',
    foreground: 'var(--wp--preset--color--white)'
};

registerBlockType(metadata.name, {
	title: __( 'Artcloud Feedback Block', 'artcloud-blocks' ),
	description: __( 'Display feedback or quotes', 'artcloud-blocks' ),
	icon: iconComments,
	edit: Edit,
	save: Save,
});
