import { registerBlockType } from '@wordpress/blocks';
import './style.scss';
import './editor.scss';
import { __ } from '@wordpress/i18n'
import Edit from './edit';
import Save from './save';
import metadata from './block.json';

const iconCardBlock = {
    src: (
        <svg id="Layer_2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 28.76 28.76">
            <defs>
                <style>{`.cls-1{fill:var(--wp--preset--color--white);stroke-width:0px;}`}</style>
            </defs>
            <g id="Layer_1-2">
                <path className="cls-1" d="m9.01,19.29h10.58c.39,0,.71-.32.71-.71s-.32-.71-.71-.71h-10.58c-.39,0-.71.32-.71.71s.32.71.71.71Z"/>
                <path className="cls-1" d="m9.01,22.62h4.35c.39,0,.71-.32.71-.71s-.32-.71-.71-.71h-4.35c-.39,0-.71.32-.71.71s.32.71.71.71Z"/>
                <path className="cls-1" d="m9.01,15.85h10.58c.39,0,.71-.32.71-.71s-.32-.71-.71-.71h-10.58c-.39,0-.71.32-.71.71s.32.71.71.71Z"/>
                <path className="cls-1" d="m28.05,7.04H.79c-.39,0-.71.32-.71.71v20.31c0,.39.32.71.71.71h27.26c.39,0,.71-.32.71-.71V7.75c0-.39-.32-.71-.71-.71Zm-.71,20.31H1.5V8.46h25.84v18.89Z"/>
                <path className="cls-1" d="m.71,5.42h4.05c.39,0,.71-.32.71-.71V.71c0-.39-.32-.71-.71-.71H.71c-.39,0-.71.32-.71.71v4.01c0,.39.32.71.71.71ZM1.42,1.42h2.63v2.59H1.42V1.42Z"/>
            </g>
        </svg>
    ),
    background: 'var(--wp--preset--color--primary)',
    foreground: 'var(--wp--preset--color--white)'
};

registerBlockType( metadata.name, {
    title: __( 'Artcloud Card Block', 'artcloud-blocks' ),
    description: __( 'Create a new tile with title description & button', 'artcloud-blocks' ),
    icon: iconCardBlock,
    edit: Edit,
    save: Save,
} );
