import { __ } from '@wordpress/i18n';
import { InnerBlocks, useBlockProps, InspectorControls } from '@wordpress/block-editor';
import { RangeControl, PanelBody } from '@wordpress/components';
const blockColumns = [
	[
		'core/columns',
		{ className: 'artcloud_card_columns_main', overlayColor: 'pale-cyan-blue' },
		[
			[
				'core/column',
				{ className: 'artcloud_card_column', verticalAlignment: '' },
				[
					['artcloud-blocks/artcloud-icon', { className: 'artcloud-icon', textAlign: 'left' }],
					[
						'core/cover',
						{ className: 'artcloud_card_cover', overlayColor: 'primary' },
						[
							[
								'core/heading',
								{ lavel: 3, className: 'artcloud_card_heading', content: 'Teema h3' },
							],
							[
								'core/paragraph',
								{ className: 'artcloud_card_description', content: 'Excepteur sint occaecat cupidatat non proident, sunt in' },
							],
							[
								'core/button',
								{
									className: 'artcloud_card_button is-style-outline',
									text: __('Lue', 'artcloud-blocks'),
									url: '#'
								},
							],
						],
					],
				],
			],
			[
				'core/column',
				{ className: 'artcloud_card_column' },
				[
					['artcloud-blocks/artcloud-icon', { className: 'artcloud-icon', textAlign: 'left' }],
					[
						'core/cover',
						{ className: 'artcloud_card_cover', overlayColor: 'primary' },
						[
							[
								'core/heading',
								{ lavel: 3, className: 'artcloud_card_heading', content: 'Teema h3' },
							],
							[
								'core/paragraph',
								{ className: 'artcloud_card_description', content: 'Excepteur sint occaecat cupidatat non proident, sunt in' },
							],
							[
								'core/button',
								{
									className: 'artcloud_card_button is-style-outline',
									text: __('Lue', 'artcloud-blocks'),
									url: '#'
								},
							],
						],
					],
				],
			],
			[
				'core/column',
				{ className: 'artcloud_card_column' },
				[
					['artcloud-blocks/artcloud-icon', { className: 'artcloud-icon', textAlign: 'left' }],
					[
						'core/cover',
						{ className: 'artcloud_card_cover', overlayColor: 'primary' },
						[
							[
								'core/heading',
								{ lavel: 3, className: 'artcloud_card_heading', content: 'Teema h3' },
							],
							[
								'core/paragraph',
								{ className: 'artcloud_card_description', content: 'Excepteur sint occaecat cupidatat non proident, sunt in' },
							],
							[
								'core/button',
								{
									className: 'artcloud_card_button is-style-outline',
									text: __('Lue', 'artcloud-blocks'),
									url: '#'
								},
							],
						],
					],
				],
			],
		],
	],
];

const Edit = ({ attributes, setAttributes }) => {
	const { topMargin } = attributes;
	const onChangeMargin = ( value ) => {
		setAttributes( { topMargin: value } );
	}
	return (
		<div {...useBlockProps({ style: { marginTop: '-'+topMargin + 'px' } })}>
		<InspectorControls>
			<PanelBody>
				<RangeControl
					label="Set TopMargin"
					onChange={onChangeMargin}
					value={topMargin}
					min={ 1 }
					max={ 200 }
				/>
			</PanelBody>
		</InspectorControls>
			<InnerBlocks template={blockColumns} />
		</div>
	);
};
export default Edit;
