<?php

function artcloud_authors_render($attributes)
{
	$selected_post_ids = [];

	// Retrieve the post IDs for the selected titles.
	if (isset($attributes['selectedTitles']) && !empty($attributes['selectedTitles'])) {
		foreach ($attributes['selectedTitles'] as $titleObj) {
			$post_id = $titleObj['id'];
			if ($post_id) {
				$selected_post_ids[] = $post_id;
			} else {
				$post = get_page_by_title($titleObj['title'], OBJECT, $attributes['postType']);
				if ($post) {
					$selected_post_ids[] = $post->ID;
				}
			}
		}
	}

	// Set up the query to get recent posts.
	$args = array(
		'post_type' => $attributes['postType'],
		'posts_per_page' => $attributes['numberOfItems'],
		'post_status' => 'publish',
		'post__in' => $selected_post_ids, // Specify the selected post IDs for sorting.
		'orderby' => 'post__in',
	);

	// If there are selected post IDs, add them to the query args.
	if (!empty($selected_post_ids)) {
		$args['post__in'] = $selected_post_ids;
	} else {
		// Get the selected category IDs only if titles are not selected.
		if (isset($attributes['categories']) && !empty($attributes['categories'])) {
			$category_ids = array_map(function ($category) {
				return $category['id'];
			}, $attributes['categories']);

			if (!empty($category_ids)) {
				$args['tax_query'] = array(
					array(
						'taxonomy' => 'product_cat',
						'field' => 'term_id',
						'terms' => $category_ids,
					),
				);
			}
		}
	}

	// The WP query
	$query = new WP_Query($args);
	$recent_items = $query->get_posts();
	$output = '<div ' . get_block_wrapper_attributes() . '>';
	$output .= '<h1 class="post-block-title" style="color:' . !empty($attributes['btnBackgroundColor']) . '">' . esc_html($attributes['title']) . '</h1>';
	$output .= '<div class="row">';

	if (!function_exists('remove_thumbnail_suffix')) {
		function remove_thumbnail_suffix($url)
		{
			// Check if the URL contains the "-96x96" suffix
			if (strpos($url, '-96x96') !== false) {
				// Replace the "-96x96" suffix with an empty string
				$url = str_replace('-96x96', '', $url);
			}
			return $url;
		}
	}

	if (!empty($recent_items)) {
		foreach ($recent_items as $post) {
			$post_id = $post->ID;
			$post_title = get_the_title($post_id);
			$post_readmore = get_permalink($post_id);

			$post_date = '';
			$author_name = '';
			$post_date = get_the_date('d.m.Y', $post);
			$author_name = get_the_author_meta('display_name', $post->post_author);
			$post_author_id = get_post_field('post_author', $post_id); // Replace $post_id with the ID of your post
			$author_avatar_url = '';
			if ($attributes["displayAuthorImage"] && has_post_thumbnail($post_id)) {
				$author_avatar_url = remove_thumbnail_suffix(get_avatar_url($post_author_id));
			} // Replace 'medium' with your desired image size.
			$post_description = '';
			if ($attributes["displayDescription"]) {
				$post_description = get_the_excerpt($post_id);
				$post_excerpt = substr($post_description, 0, 55);
			}

			$backgroundColor = isset($attributes["backgroundColor"]) ? $attributes["backgroundColor"] : "";
			$textColor = isset($attributes["textColor"]) ? $attributes["textColor"] : "";
			$btnBackgroundColor = isset($attributes["btnBackgroundColor"]) ? $attributes["btnBackgroundColor"] : "";
			$btnTextColor = isset($attributes["btnTextColor"]) ? $attributes["btnTextColor"] : "";
			// Output the post information.
			$output .= '<div class="artcloud-item col-4">';
			$output .= '<div class="artcloud-postImg">';
			$output .= '<img src="' . esc_url($author_avatar_url) . '" alt="' . esc_attr($author_name) . '">';
			$output .= '</div>';
			$output .= '<div class="artcloud-content" style="background-color:' . $backgroundColor . '; color:' . $textColor . ';" >';
			if ($attributes["displayDateAuthor"]) {
				$output .= '<div class="artcloud-date-author"><span style="color:' . $textColor . ';">' . $post_date . '</span> <h6 style="color:' . $textColor . ';">' . $author_name . '</h6></div>';
			}
			if ($attributes["displayDescription"]) {
				$output .= '<p>' . wp_kses_post($post_excerpt) . '</p>';
			}
			$output .= '<a style="background-color:' . $btnBackgroundColor . ' ;color:' . $btnTextColor . '" href="' . esc_url($post_readmore) . '" class="wp-block-post-excerpt__more-link">' . __('Lue', 'artcloud-b') . '</a>';
			$output .= '</div>';
			$output .= '</div>';
		}
	} else {
		$output .= '<p>__("No item Selected","artcloud-blocks")</p>';
	}
	$output .= '</div>';
	$output .= '</div>';

	return $output;
}
