import { __ } from "@wordpress/i18n";
import {
	useBlockProps,
	InspectorControls,
	RichText,
	InnerBlocks
} from "@wordpress/block-editor";
import { PanelBody, RangeControl, SelectControl,ToggleControl } from "@wordpress/components";
import { useState } from "@wordpress/element";

const alertOptions = [
	{
		label: "info",
		value: "#BBDDE6",
	},
	{
		label: "success",
		value: "#bbe6bd",
	},
	{
		label: "warning",
		value: "#e6d2bb",
	},
	{
		label: "danger",
		value: "#e6bbbb",
	},
	// Add more SVG options as needed
];

const Edit = ({ attributes, setAttributes }) => {
	const {
		size,
		textAlign,
		title,
		displayAlertBox,
		description,
		selectedAlert: initialSelectedAlert,
		isDivVisible = true, // Initialize isDivVisible
	} = attributes;

	const [selectedAlert, setSelectedAlert] = useState(initialSelectedAlert);

	const onChangeAlert = (newAlert) => {
		setSelectedAlert(newAlert);
		setAttributes({ selectedAlert: newAlert });
	};

	const onChangeSize = (newSize) => {
		setAttributes({
			size: newSize,
			width: newSize,
			height: newSize,
		});
	};

	if (!size) {
		setAttributes({ size: 100 });
	}

	if (!selectedAlert) {
		setSelectedAlert(initialSelectedAlert);
	}
	const displayAlertChange = (value) => {
		setAttributes({ displayAlertBox: value });
	};
	const toggleDivVisibility = () => {
		setAttributes({ isDivVisible: !isDivVisible });
	};

	return (
		<div {...useBlockProps({ className: `artclod-alertBlock ${isDivVisible ? '' : 'hidden'}` })}>
			<InspectorControls>
				<PanelBody title={__("Notifications")} initialOpen={true}>
				<ToggleControl
						label={__('Display Alert Box', 'artcloud-blocks')}
						checked={displayAlertBox}
						onChange={displayAlertChange}
					/>
					<SelectControl
						label={__("Select Alert Type", "artcloud-blocks")}
						value={selectedAlert}
						options={alertOptions.map((option) => ({
							label: option.label,
							value: option.value,
						}))}
						onChange={onChangeAlert}
					/>
					<RangeControl
						label={__("Icon Size")}
						value={size}
						onChange={onChangeSize}
						min={1}
						max={500}
					/>
				</PanelBody>
			</InspectorControls>
			{displayAlertBox && (
				<div className="alert-main-box">
				<div className="alert-main-icon" style={{ backgroundColor: selectedAlert }}>
				<InnerBlocks template={[
					['artcloud-blocks/artcloud-icon', { className: 'has-text-align-left' }],
				]}
					templateLock="all"
				/>
				</div>
				<div className="alert-main-content">
					<RichText
						tagName="h5"
						value={title}
						allowedFormats={['core/bold', 'core/italic', 'core/color']}
						onChange={(title) => setAttributes({ title })}
						placeholder={__('Heading...')} // Display this text before any content has been added by the user
					/>
					<RichText
						tagName="p"
						value={description}
						allowedFormats={['core/bold', 'core/italic']}
						onChange={(description) => setAttributes({ description })}
						placeholder={__('Paragraph...')} // Display this text before any content has been added by the user
					/>
				</div>
				<p className='alertClose' onClick={toggleDivVisibility}>
				<svg fill="#121212" height="11px" viewBox="0 0 329.26933 329" width="11px" xmlns="http://www.w3.org/2000/svg"><path d="m194.800781 164.769531 128.210938-128.214843c8.34375-8.339844 8.34375-21.824219 0-30.164063-8.339844-8.339844-21.824219-8.339844-30.164063 0l-128.214844 128.214844-128.210937-128.214844c-8.34375-8.339844-21.824219-8.339844-30.164063 0-8.34375 8.339844-8.34375 21.824219 0 30.164063l128.210938 128.214843-128.210938 128.214844c-8.34375 8.339844-8.34375 21.824219 0 30.164063 4.15625 4.160156 9.621094 6.25 15.082032 6.25 5.460937 0 10.921875-2.089844 15.082031-6.25l128.210937-128.214844 128.214844 128.214844c4.160156 4.160156 9.621094 6.25 15.082032 6.25 5.460937 0 10.921874-2.089844 15.082031-6.25 8.34375-8.339844 8.34375-21.824219 0-30.164063zm0 0"/>
				</svg>
				</p>
			</div>
			) }
		</div>
	);
};
export { alertOptions };
export default Edit;
