jQuery(document).ready(function($) {
	const accordionButtons = $('.accordion-button');
	const accordionItems = $('.accordion-item');
  
	// Add click event listener to each accordion button
	accordionButtons.each(function(index) {
	  $(this).on('click', function() {
		// Toggle 'active' class for the clicked button and corresponding item
		$(this).toggleClass('active');
		accordionItems.eq(index).toggleClass('active');
  
		// Deactivate other buttons and items
		accordionButtons.each(function(i) {
		  if (i !== index) {
			$(this).removeClass('active');
			accordionItems.eq(i).removeClass('active');
		  }
		});
	  });
	});
  
	// By default, add 'active' class to the first item
	accordionButtons.first().addClass('active');
	accordionItems.first().addClass('active');
  });
  