/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/blocks/artcloud-icon/edit.js":
/*!******************************************!*\
  !*** ./src/blocks/artcloud-icon/edit.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _svgOptionsV_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./svgOptionsV.js */ "./src/blocks/artcloud-icon/svgOptionsV.js");
/* harmony import */ var _svgOptionsA_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./svgOptionsA.js */ "./src/blocks/artcloud-icon/svgOptionsA.js");








const Edit = ({
  attributes,
  setAttributes
}) => {
  const {
    alignment,
    size,
    fillColor,
    backgroundColor,
    textAlign,
    svgOptions,
    selectedSvg,
    selectedSvgV,
    selectedSvgA,
    selectedSvgViewBox
  } = attributes;
  const activeThemeName = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_5__.useSelect)(select => {
    return select('core').getCurrentTheme();
  }, []);
  setAttributes({
    svgOptions: activeThemeName && activeThemeName.name.rendered === 'Vihreat' ? _svgOptionsV_js__WEBPACK_IMPORTED_MODULE_6__["default"] : _svgOptionsA_js__WEBPACK_IMPORTED_MODULE_7__["default"]
  });

  // const [selectedSvg, setSelectedSvg] = useState(initialSelectedSvg);

  const onChangeBackgroundColor = newBgColor => {
    setAttributes({
      backgroundColor: newBgColor
    });
  };
  const onChangeFillColor = newFillColor => {
    setAttributes({
      fillColor: newFillColor
    });
  };
  const onChangeSvg = newSvg => {
    // setSelectedSvg(newSvg);
    setAttributes({
      selectedSvg: newSvg
    });
  };
  const onChangeSize = newSize => {
    setAttributes({
      size: newSize,
      width: newSize,
      height: newSize
    });
  };
  if (!size) {
    setAttributes({
      size: 100
    });
  }
  const defaultSvg = activeThemeName && activeThemeName.name.rendered === 'Vihreat' ? selectedSvgV : selectedSvgA;
  const selectedSvgOption = svgOptions && svgOptions.find(option => option.value === selectedSvg);
  setAttributes({
    selectedSvgViewBox: selectedSvgOption && selectedSvgOption.viewBox
  });
  console.log(selectedSvgViewBox);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
    if (!selectedSvg) {
      setAttributes({
        selectedSvg: defaultSvg
      });
    }
  }, [defaultSvg]);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    ...(0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.useBlockProps)({
      className: `align${alignment} has-text-align-${textAlign} alert-icon-svg`
    })
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.BlockControls, {
    group: "block"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.AlignmentControl, {
    value: textAlign,
    onChange: nextAlign => {
      setAttributes({
        textAlign: nextAlign
      });
    }
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.InspectorControls, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.PanelColorSettings, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Color Settings", "artcloud-blocks"),
    icon: "admin-appearance",
    initialOpen: true,
    colorSettings: [{
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Background Color", "artcloud-blocks"),
      value: backgroundColor,
      onChange: onChangeBackgroundColor
    }, {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Fill Color", "artcloud-blocks"),
      value: fillColor,
      onChange: onChangeFillColor
    }]
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelBody, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("SVG Options"),
    initialOpen: true
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.SelectControl, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Select SVG", "artcloud-blocks"),
    value: selectedSvg,
    options: svgOptions.map(option => ({
      label: option.label,
      value: option.value
    })),
    onChange: onChangeSvg
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.RangeControl, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Size"),
    value: size,
    onChange: onChangeSize,
    min: 1,
    max: 500
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    style: {
      width: `${size}px`,
      height: `${size}px`,
      fill: fillColor,
      stroke: fillColor
    },
    viewBox: selectedSvgViewBox,
    strokeWidth: "1.5",
    stroke: "currentColor",
    className: "w-6 h-6"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    strokeLinecap: "round",
    strokeLinejoin: "round",
    d: selectedSvg
  })));
};
// export { svgOptions };
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Edit);

/***/ }),

/***/ "./src/blocks/artcloud-icon/index.js":
/*!*******************************************!*\
  !*** ./src/blocks/artcloud-icon/index.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./style.scss */ "./src/blocks/artcloud-icon/style.scss");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _edit__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./edit */ "./src/blocks/artcloud-icon/edit.js");
/* harmony import */ var _save__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./save */ "./src/blocks/artcloud-icon/save.js");
/* harmony import */ var _block_json__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./block.json */ "./src/blocks/artcloud-icon/block.json");







const iconBlock = {
  src: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    id: "Layer_2",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 24.19 23.15"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("style", null, `.cls-1{fill:var(--wp--preset--color--white);stroke-width:0px;}`)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
    id: "Layer_1-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    className: "cls-1",
    d: "m24.12,8.74c-.19-.58-.7-.97-1.3-1.01l-6.85-.46L13.46.93h0c-.22-.56-.76-.93-1.36-.93s-1.14.36-1.36.93l-2.55,6.37-6.8.43c-.6.04-1.11.44-1.3,1.01-.19.58,0,1.2.46,1.58l5.27,4.4-1.69,6.6c-.15.59.07,1.2.56,1.55.26.19.56.28.86.28.27,0,.54-.08.79-.23l5.81-3.65,5.76,3.65c.51.32,1.16.3,1.65-.05.49-.36.71-.96.56-1.55l-1.68-6.65,5.25-4.35c.47-.38.65-1.01.46-1.58Zm-6.62,4.84c-.43.36-.62.95-.48,1.49l1.62,6.66-5.76-3.65c-.24-.15-.51-.23-.79-.23s-.55.08-.79.23l-5.83,3.6,1.69-6.6c.14-.55-.05-1.13-.49-1.49L1.46,9.14l6.8-.43c.56-.04,1.06-.4,1.27-.92l2.56-6.37s.04.01.04.03l2.51,6.34c.21.52.71.89,1.27.92l6.83.52-5.25,4.35Z"
  }))),
  background: 'var(--wp--preset--color--primary)',
  foreground: 'var(--wp--preset--color--white)'
};
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)(_block_json__WEBPACK_IMPORTED_MODULE_6__.name, {
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Artcloud Icon Block', 'artcloud-blocks'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Select any SVG icon to display.', 'artcloud-blocks'),
  icon: iconBlock,
  edit: _edit__WEBPACK_IMPORTED_MODULE_4__["default"],
  save: _save__WEBPACK_IMPORTED_MODULE_5__["default"]
});

/***/ }),

/***/ "./src/blocks/artcloud-icon/save.js":
/*!******************************************!*\
  !*** ./src/blocks/artcloud-icon/save.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__);


const Save = ({
  attributes
}) => {
  const {
    alignment,
    size,
    fillColor,
    selectedSvg,
    textAlign,
    selectedSvgViewBox
  } = attributes;

  // const selectedSvgOption = svgOptions && svgOptions.find((option) => option.value === selectedSvg);

  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    ..._wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.useBlockProps.save({
      style: `text-align: ${textAlign}`,
      className: `align${alignment}`
    })
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    style: {
      width: `${size}px`,
      height: `${size}px`,
      fill: fillColor,
      stroke: fillColor
    },
    viewBox: selectedSvgViewBox,
    strokeWidth: "1.5",
    stroke: "currentColor",
    className: "w-6 h-6"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    strokeLinecap: "round",
    strokeLinejoin: "round",
    d: selectedSvg
  })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Save);

/***/ }),

/***/ "./src/blocks/artcloud-icon/svgOptionsA.js":
/*!*************************************************!*\
  !*** ./src/blocks/artcloud-icon/svgOptionsA.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const svgOptionsA = [{
  label: "Abstrakti-1",
  value: "m32.47,2.76l1.59,5.68c.66,2.36,3.36,3.48,5.49,2.28l5.14-2.89c3.33-1.87,7.02,1.82,5.15,5.15l-2.89,5.14c-1.2,2.14-.08,4.83,2.28,5.49l5.68,1.59c3.68,1.03,3.68,6.25,0,7.28l-5.68,1.59c-2.36.66-3.48,3.36-2.28,5.49l2.89,5.14c1.87,3.33-1.82,7.02-5.15,5.15l-5.14-2.89c-2.14-1.2-4.83-.08-5.49,2.28l-1.59,5.68c-1.03,3.68-6.25,3.68-7.28,0l-1.59-5.68c-.66-2.36-3.36-3.48-5.49-2.28l-5.14,2.89c-3.33,1.87-7.02-1.82-5.15-5.15l2.89-5.14c1.2-2.14.08-4.83-2.28-5.49l-5.68-1.59c-3.68-1.03-3.68-6.25,0-7.28l5.68-1.59c2.36-.66,3.48-3.36,2.28-5.49l-2.89-5.14c-1.87-3.33,1.82-7.02,5.15-5.15l5.14,2.89c2.14,1.2,4.83.08,5.49-2.28l1.59-5.68c1.03-3.68,6.25-3.68,7.28,0Z",
  viewBox: "0 0 57.65 57.65"
}, {
  label: "Abstrakti-2",
  value: "m40.78,8.26h0c1.4,3.14,3.91,5.65,7.05,7.05h0c11.01,4.92,11.01,20.55,0,25.47h0c-3.14,1.4-5.65,3.91-7.05,7.05h0c-4.92,11.01-20.55,11.01-25.47,0h0c-1.4-3.14-3.91-5.65-7.05-7.05h0c-11.01-4.92-11.01-20.55,0-25.47h0c3.14-1.4,5.65-3.91,7.05-7.05h0c4.92-11.01,20.55-11.01,25.47,0Z",
  viewBox: "0 0 56.09 56.09"
}, {
  label: "Abstrakti-3",
  value: "m31.05,2.16l10.13,20.97c.08.17.17.33.28.49l13.09,19.26c1.8,2.64-.25,6.19-3.44,5.96l-23.22-1.71c-.19-.01-.37-.01-.56,0l-23.22,1.71c-3.19.23-5.24-3.32-3.44-5.96l13.09-19.26c.11-.15.2-.32.28-.49L24.17,2.16c1.39-2.88,5.49-2.88,6.88,0Z",
  viewBox: "0 0 55.23 48.84"
}, {
  label: "Kello",
  value: "m48.94,41.85c-1.65-.83-6.59-4.82-6.59-19.78,0-3.48-1-6.21-2.54-8.36-2.55-4.21-6.85-7.24-11.9-8.07,0,0,0,0,0,0,.61-.8.88-1.86.61-2.99-.3-1.26-1.33-2.27-2.59-2.55-2.3-.52-4.33,1.22-4.33,3.42,0,.8.27,1.53.72,2.12,0,0,0,0,0,0-4.12.68-7.75,2.82-10.33,5.88-2.37,2.38-4.11,5.75-4.11,10.51,0,14.96-4.93,18.95-6.59,19.78C.2,42.35,0,44.31,0,45.6c0,.65.53,1.17,1.18,1.17h14.93s0,0,0,0c.98,4.07,4.64,7.1,9,7.1s8-3.01,8.99-7.05h0s15.12,0,15.12,0c.55,0,1-.44,1-1,0-1.28-.15-3.4-1.29-3.97Z",
  viewBox: "0 0 50.22 53.87"
}, {
  label: "Kukka",
  value: "m51.21,25.4l-.23-1.27c-.53-2.88-2.81-5.11-5.7-5.59l-1.02-.17-.21-.42,1.18-2.36c1-2,.98-4.37-.06-6.35l-.02-.03c-.6-1.14-1.51-2.09-2.62-2.75l-.37-.22c-2.2-1.3-4.93-1.29-7.12.02l-1.48.89h-.22l-.57-1.99c-.75-2.62-2.95-4.56-5.64-4.97l-1.19-.18c-.11-.02-.22-.02-.32-.02-.11,0-.21,0-.32.02l-1.19.18c-2.69.41-4.89,2.35-5.64,4.97l-.57,1.99h-.22l-1.48-.89c-2.19-1.31-4.92-1.32-7.12-.02l-.36.22c-1.11.66-2.02,1.61-2.62,2.75l-.02.03c-1.04,1.98-1.07,4.35-.06,6.35l1.18,2.36-.21.42-1.06.18c-2.86.48-5.12,2.68-5.68,5.52l-.2,1.04c-.02.11-.03.22-.03.33,0,.11,0,.22.03.33l.23,1.26c.53,2.88,2.81,5.11,5.7,5.59l1.02.17.21.42-1.18,2.36c-1,2-.98,4.37.06,6.35l.02.03c.6,1.14,1.51,2.09,2.62,2.75l.37.22c2.2,1.3,4.93,1.29,7.12-.02l1.48-.89h.22l.57,1.99c.75,2.62,2.95,4.56,5.64,4.97l1.19.18s.1,0,.14.01c.09.02.19.03.28.03.08,0,.16,0,.24-.02l1.19-.18c2.69-.41,4.89-2.36,5.63-4.97l.57-1.99h.22s1.49.89,1.49.89c2.19,1.31,4.92,1.31,7.12.01l.36-.22c1.11-.66,2.01-1.61,2.61-2.75l.02-.03c1.04-1.98,1.06-4.35.06-6.35l-1.18-2.35.21-.42,1.06-.18c2.86-.48,5.12-2.69,5.67-5.53l.19-.98c.06-.22.08-.45.03-.69Z",
  viewBox: "0 0 51.24 51.17"
}, {
  label: "Puhekupla",
  value: "m51.35,0H8.62C3.88,0,0,3.88,0,8.62v27.06c0,4.74,3.88,8.62,8.62,8.62h28.89l9.84,7.75c.44.35,1.09.03,1.09-.53v-7.22h2.92c4.74,0,8.62-3.88,8.62-8.62V8.62c0-4.74-3.88-8.62-8.62-8.62Z",
  viewBox: "0 0 59.97 52.19"
}, {
  label: "Sydän",
  value: "m51.7,10.98C43.92-6.01,28.31,1.52,26.38,2.53,24.45,1.52,8.84-6.01,1.05,10.98c-6.81,14.85,21.44,33.92,25.13,36.33v.26s.07-.04.2-.13c.13.08.2.13.2.13v-.26c3.69-2.41,31.93-21.48,25.13-36.33Z",
  viewBox: "0 0 52.76 47.56"
}, {
  label: "Tähti",
  value: "m31.32,1.24l6.51,16.42c.28.71.94,1.19,1.7,1.23l17.63,1.12c1.77.11,2.5,2.34,1.13,3.47l-13.6,11.26c-.58.48-.84,1.26-.65,2l4.38,17.11c.44,1.72-1.45,3.1-2.95,2.14l-14.92-9.46c-.64-.41-1.46-.41-2.1,0l-14.92,9.46c-1.5.95-3.39-.42-2.95-2.14l4.38-17.11c.19-.74-.06-1.51-.65-2L.71,23.48c-1.37-1.13-.65-3.36,1.13-3.47l17.63-1.12c.76-.05,1.42-.53,1.7-1.23L27.68,1.24c.65-1.65,2.99-1.65,3.65,0Z",
  viewBox: "0 0 59 56.3"
}, {
  label: "Talo",
  value: "m59.22,32.18s.06-.01.09-.02c.03,0,.06-.01.08-.02.03,0,.06-.02.09-.03.03,0,.06-.02.08-.03.03-.01.05-.02.08-.04.03-.01.06-.03.08-.04.03-.01.05-.03.07-.04.03-.02.06-.03.08-.05.03-.02.05-.04.08-.06.02-.02.05-.03.07-.05.05-.04.09-.08.13-.12,0,0,0,0,0,0,0,0,0,0,0,0,.04-.04.08-.09.12-.13.02-.02.03-.04.05-.06.02-.03.04-.05.06-.08.02-.03.03-.05.05-.08.02-.03.03-.05.05-.08.01-.03.03-.05.04-.08.01-.03.03-.06.04-.08.01-.03.02-.05.03-.08.01-.03.02-.06.03-.09,0-.03.01-.05.02-.08,0-.03.02-.07.02-.1,0-.03,0-.06.01-.09,0-.03.01-.06.01-.09,0-.05,0-.1,0-.15,0,0,0-.02,0-.03s0-.02,0-.03c0-.05,0-.1,0-.15,0-.03,0-.06-.01-.09,0-.03,0-.06-.01-.09,0-.03-.02-.07-.02-.1,0-.03-.01-.05-.02-.08,0-.03-.02-.06-.03-.09,0-.03-.02-.05-.03-.08-.01-.03-.03-.06-.04-.08-.01-.03-.03-.05-.04-.08-.01-.03-.03-.05-.05-.08-.02-.03-.03-.05-.05-.08-.02-.03-.04-.05-.06-.08-.02-.02-.03-.04-.05-.07-.04-.05-.08-.09-.12-.13,0,0,0,0,0,0L31.67.54C31.31.18,30.83,0,30.36,0c-.48,0-.95.18-1.31.54L.54,29.04s0,0,0,0c-.04.04-.08.09-.12.13-.02.02-.03.04-.05.07-.02.03-.04.05-.06.08-.02.03-.03.05-.05.08-.02.03-.03.05-.05.08-.01.03-.03.05-.04.08-.01.03-.03.05-.04.08-.01.03-.02.05-.03.08-.01.03-.02.06-.03.09,0,.03-.01.05-.02.08,0,.03-.02.06-.02.1,0,.03,0,.06-.01.09,0,.03-.01.06-.01.09,0,.05,0,.1,0,.15,0,0,0,.02,0,.03s0,.02,0,.03c0,.05,0,.1,0,.15,0,.03,0,.06.01.09,0,.03,0,.06.01.09,0,.03.02.07.02.1,0,.03.01.05.02.08,0,.03.02.06.03.09,0,.03.02.05.03.08.01.03.03.06.04.08.01.03.02.05.04.08.01.03.03.05.05.08.02.03.03.05.05.08.02.03.04.06.06.08.02.02.03.04.05.06.04.05.08.09.12.13,0,0,0,0,0,0,0,0,0,0,0,0,.04.04.09.08.13.12.02.02.04.03.07.05.03.02.05.04.08.06.03.02.05.03.08.05.02.01.05.03.07.04.03.01.06.03.08.04.03.01.05.03.08.04.03.01.06.02.08.03.03.01.06.02.09.03.03,0,.06.01.08.02.03,0,.06.02.09.02.03,0,.06.01.1.01.03,0,.05,0,.08.01.06,0,.12,0,.18,0h6.27c.94,0,1.7.76,1.7,1.7v20.29c0,1.97,1.59,3.56,3.56,3.56h9.37c1.97,0,3.56-1.59,3.56-3.56v-9.48c0-.94.76-1.7,1.7-1.7h4.67c.94,0,1.7.76,1.7,1.7v9.48c0,1.97,1.59,3.56,3.56,3.56h9.37c1.97,0,3.56-1.59,3.56-3.56v-20.29c0-.94.76-1.7,1.7-1.7h6.27c.06,0,.12,0,.18,0,.03,0,.05,0,.08-.01.03,0,.07,0,.1-.01Z",
  viewBox: "0 0 60.71 57.77"
}
// Add more SVG options as needed
];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (svgOptionsA);

/***/ }),

/***/ "./src/blocks/artcloud-icon/svgOptionsV.js":
/*!*************************************************!*\
  !*** ./src/blocks/artcloud-icon/svgOptionsV.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const svgOptionsV = [{
  label: "Lehti",
  value: "M51.945,59.884A63.928,63.928,0,0,1,37.967,39.121a.885.885,0,0,1,1.154-1.154A63.944,63.944,0,0,1,59.884,51.945a66.237,66.237,0,0,1,7.177,8.485.886.886,0,0,0,1.6-.409A53.42,53.42,0,0,0,2.7,1.588,1.525,1.525,0,0,0,1.589,2.7,53.418,53.418,0,0,0,60.021,68.66a.886.886,0,0,0,.409-1.6,66.305,66.305,0,0,1-8.485-7.177",
  viewBox: "0 0 69.068 69.069"
}, {
  label: "Koti",
  value: "M69.014,34.027,36.995.882a2.892,2.892,0,0,0-4.159,0L19.977,14.194a1.612,1.612,0,0,1-2.771-1.12V9.907a2.891,2.891,0,0,0-2.892-2.891H10.341A2.891,2.891,0,0,0,7.449,9.907V25.994A2.893,2.893,0,0,1,6.637,28L.818,34.027a2.891,2.891,0,0,0,2.079,4.9H4.558a2.891,2.891,0,0,1,2.891,2.892V67.691a2.891,2.891,0,0,0,2.892,2.891h49.15a2.891,2.891,0,0,0,2.891-2.891V41.819a2.892,2.892,0,0,1,2.892-2.892h1.66a2.891,2.891,0,0,0,2.08-4.9",
  viewBox: "0 0 69.832 70.582"
}, {
  label: "Kilpi",
  value: "M1.246,3.719A1.658,1.658,0,0,0,0,5.324V42.257c0,16.7,4.43,21.835,30.793,31.684a2.906,2.906,0,0,0,2.034,0C59.189,64.092,63.62,58.959,63.62,42.257V5.359a1.659,1.659,0,0,0-1.287-1.614C41.117-1.169,20.73-1.319,1.246,3.719",
  viewBox: "0 0 63.62 74.125"
}, {
  label: "Sydän",
  value: "M42.72,17.44a1.807,1.807,0,0,1-3.52,0,26.852,26.852,0,0,0-2.759-7.61A19.986,19.986,0,0,0,19.412,0,19.387,19.387,0,0,0,6.271,5.014a19.718,19.718,0,0,0-1.233,27.6C15.414,44.235,32.96,42.23,39.1,67.211a1.807,1.807,0,0,0,3.514-.023C48.524,42.272,67.5,43.686,77.3,32.135A19.415,19.415,0,0,0,62.51,0h0A19.893,19.893,0,0,0,45.481,9.831,27.249,27.249,0,0,0,42.72,17.44",
  viewBox: "0 0 81.985 68.583"
}, {
  label: "Vihreät",
  value: "M24.036,35.159a1.412,1.412,0,0,1-.324.059,1.033,1.033,0,0,1-.826-.306.693.693,0,0,1-.153-.652,3.313,3.313,0,0,1,1-1.4,1.33,1.33,0,0,1,.812-.409.756.756,0,0,1,.565.193,1.2,1.2,0,0,1,.344.858,1.98,1.98,0,0,1-1.422,1.662m3.678-14.3a1.407,1.407,0,0,0,.3-1.592.908.908,0,0,0-.063-.1,1.47,1.47,0,0,0-1.185-.538c-.742,0-2.343.51-2.246,1.494.151,1.529,2.314,1.675,3.2.734m-.231,11.174a1.3,1.3,0,0,0-1.2,1.255c-.008.1-.014.192-.019.286a1.783,1.783,0,0,1-.4,1.285,5.847,5.847,0,0,1-.446.391,2.216,2.216,0,0,0-1.067,1.691.918.918,0,0,0,.27.691,1.44,1.44,0,0,0,1.045.324l.049,0a3.63,3.63,0,0,0,2.584-1.488,3.489,3.489,0,0,0,.656-1.764,3.869,3.869,0,0,0-.2-1.82,1.451,1.451,0,0,0-.377-.535,1.235,1.235,0,0,0-.892-.314m42.869,3.141A35.176,35.176,0,1,1,35.176,0,35.176,35.176,0,0,1,70.352,35.177M45.951,6.046A31,31,0,0,0,40.5,4.535c-4.764-.81-6.737-.232-7.639.42-1.384,1-.36,1.881-1.7,3.544-.973,1.209-.951,2.146.019,3.19a2.534,2.534,0,0,1,.422,2.78,3.647,3.647,0,0,1-1.682,1.782,30.717,30.717,0,0,1-3.767,1.413c-1.578.61-3.128,1.1-3.934.613-.627-.376-.357-1.336.248-2A24.8,24.8,0,0,0,24.328,14.1c.679-.92.7-1.862.025-2.2-.98-.491-3.7,1.04-5.456,4.254a34.6,34.6,0,0,1-1.942,2.879,10.33,10.33,0,0,1-1.54,1.3C12.5,22.358,8.931,21.57,6.8,23.762c-1.665,1.715-2.716,6.807-2.716,11.415a30.678,30.678,0,0,0,5.941,18.316,33.6,33.6,0,0,0,9.348,8.471,31.274,31.274,0,0,0,13.678,4.171c.672.03,2.1.084,2.58-.71.433-.721-.083-1.77-.24-2.089-1.084-2.187-3.654-3.16-7.039-4.393-1.9-.694-3.367-1.062-4.812-2.477a6.314,6.314,0,0,1-1.2-1.566,6.528,6.528,0,0,1-.37-4.725,6.878,6.878,0,0,1,2.983-3.737,7.948,7.948,0,0,1,4.909-.822,9.545,9.545,0,0,1,1.288.171,13.519,13.519,0,0,1,1.7.455c1.224.421,2,.795,2.568,1.035.48.2,4.125,1.6,7.313.707,1.9-.53,3.379-2.01,3.11-3.384-.236-1.209-.863-1.729-3.262-1.729-3.8,0-5.413-1.891-6.521-1.006-.835.667.229,1.937-.3,2.481a1.034,1.034,0,0,1-.823.272c-.876-.1-1.636-.968-2.415-1.85a2.777,2.777,0,0,0-2.881-.788A2.832,2.832,0,0,0,27.966,43.4c-.55.933-1.8,2.221-3.319,1.932a2.365,2.365,0,0,1-1.47-3.439,4.763,4.763,0,0,1,2.515-1.9,5.132,5.132,0,0,0,2.563-1.739c2.937-4.576,4.48-5.674,7.045-5.6a12.343,12.343,0,0,0,3.072-.157A3.589,3.589,0,0,0,40,31.72c.551-.513.7-1.261-.041-1.6-.594-.274-1.177.157-1.779.194a2.058,2.058,0,0,1-2.309-1.838c-.066-1.287,1.062-2.276,1.065-3.538,0-1.119-1.078-1.254-1.716-.465a4.6,4.6,0,0,0-.862,3.477c.205,1.561-1,3.811-3.009,3.6a3.249,3.249,0,0,1-3.089-2.826c-.143-2.333,1.731-3.1,3.3-5.759,1.968-3.334,4.3-4.452,6.55-4.59,3.194-.2,3.019,3.179,5.3,2.4,2.334-.8,3.11-3.646,2.765-9.278a4.211,4.211,0,0,1,1.033-2.879c.463-.552.765-1.79-1.255-2.566m19.64,35.547c.35-1.672.693-4.185-.633-4.406-1.5-.251-1.876,1.916-3.491,3.083-2.273,1.645-4.109,1.469-4.775,3.037-.406.954-.1,1.651-.182,3.107a5,5,0,0,1-2.057,3.942c-1.48,1.1-2.491,1.137-2.9,1.96-.444.887-.136,1.355-.061,2.636a3.288,3.288,0,0,1-.726,2.274c-1.4,1.765-2.2,2.189-2.961,3.748-.145.3-.472,1.268.084,1.742s1.709.02,2.152-.217A31.766,31.766,0,0,0,63.495,48.107a37.368,37.368,0,0,0,2.1-6.514",
  viewBox: "0 0 70.352 70.353"
}, {
  label: "Puu",
  value: "M25.588,46.374C18.575,54.19,7.612,60.149.8,63.36A1.394,1.394,0,0,0,1.4,66.015H75.177a1.394,1.394,0,0,0,.594-2.655C68.962,60.149,58,54.191,50.986,46.375a.893.893,0,0,1,.917-1.451,84.293,84.293,0,0,0,16.943,3.038,1.394,1.394,0,0,0,.818-2.589C63.294,41.6,52.592,34.659,48.635,28.488a.893.893,0,0,1,.965-1.349,54.018,54.018,0,0,0,7.815,1.3,1.4,1.4,0,0,0,.944-2.522c-8.438-6.04-14.854-15.3-18.782-25.052A1.393,1.393,0,0,0,37,.869c-3.928,9.748-10.343,19.012-18.782,25.052a1.4,1.4,0,0,0,.944,2.523,54.106,54.106,0,0,0,7.815-1.305.893.893,0,0,1,.966,1.349C23.981,34.659,13.28,41.6,6.91,45.371a1.394,1.394,0,0,0,.818,2.589,84.235,84.235,0,0,0,16.943-3.037.893.893,0,0,1,.917,1.451",
  viewBox: "0 0 76.573 66.015"
}, {
  label: "Kirja",
  value: "M39.63,18.361C42.394,8.067,52.1.29,76.181,0a1.379,1.379,0,0,1,1.4,1.377v44.07a1.377,1.377,0,0,1-1.36,1.377c-24.576.281-33.335,8.223-34,18.215a1.372,1.372,0,0,1-1.372,1.276H36.736a1.372,1.372,0,0,1-1.372-1.276c-.67-9.992-9.428-17.934-34-18.215A1.376,1.376,0,0,1,0,45.447V1.377A1.379,1.379,0,0,1,1.4,0C25.487.29,35.418,7.975,38.078,18.346a.8.8,0,0,0,1.552.015",
  viewBox: "0 0 77.578 66.315"
}, {
  label: "Chakra",
  value: "M32.754,1.119v0a1.557,1.557,0,0,1,2.987,0v0A11.315,11.315,0,0,0,53.5,6.889l0,0a1.557,1.557,0,0,1,2.416,1.755v.005a11.316,11.316,0,0,0,10.975,15.1h0a1.557,1.557,0,0,1,.922,2.84h0a11.317,11.317,0,0,0,0,18.672h0a1.556,1.556,0,0,1-.922,2.839h0a11.317,11.317,0,0,0-10.975,15.1v0A1.557,1.557,0,0,1,53.5,64.966a11.316,11.316,0,0,0-17.758,5.767v0a1.557,1.557,0,0,1-2.987,0v0a11.317,11.317,0,0,0-17.759-5.769h0a1.556,1.556,0,0,1-2.415-1.755v0A11.318,11.318,0,0,0,1.6,48.1h0a1.556,1.556,0,0,1-.922-2.839h0a11.317,11.317,0,0,0,0-18.672h0a1.556,1.556,0,0,1,.922-2.84h0A11.317,11.317,0,0,0,12.58,8.647l0-.005a1.556,1.556,0,0,1,2.415-1.755l0,0a11.316,11.316,0,0,0,17.757-5.77",
  viewBox: "0 0 68.493 71.854"
}, {
  label: "Chat",
  value: "M61.342,47.757c12.667-3.685,22.4-9.185,22.4-20.5C83.74,7.779,62.458,0,41.87,0S0,7.779,0,27.257C0,40.29,9.771,48.047,22,52.512c10.4,3.8,28.149,6.543,45.822,6.984a.974.974,0,0,0,.376-1.9c-9.235-1.976-12.308-3.458-12.308-5.971,0-2.1,1.942-2.828,5.52-3.864Z",
  viewBox: "0 0 83.74 59.496"
}, {
  label: "Aalto",
  value: "M0,43.5A43.3,43.3,0,0,1,33.458,1.235,48.433,48.433,0,0,1,44.314,0C56.523,0,69.737,8.1,69.737,20.058a13.182,13.182,0,0,1-1.98,6.95,1.372,1.372,0,0,1-2.4-.095c-1.618-3.167-5.547-5.556-10.174-5.556-8.837,0-13.641,8.7-13.641,15.5,0,13.653,9.284,24.964,24.2,29H.006Z",
  viewBox: "0 0 69.737 65.853"
}, {
  label: "Sieni",
  value: "M33.9,0C13.427,0,0,13.579,0,27.4c0,8.489,5.858,14.15,12.514,14.15a13.769,13.769,0,0,0,6.624-1.492c2.084-1.129,4.524-1.443,6.11.488a4.363,4.363,0,0,1,.274,4.651,33.636,33.636,0,0,0-4.087,14.979c0,7.017,4.155,11.54,12.464,11.54s12.464-4.523,12.464-11.54c0-3.975-1.227-7.761-2.553-11.464-1.2-3.343-2.427-6.972.083-8.932,1.794-1.4,3.709-.536,5.308.5,1.7,1.1,4.119,1.274,6.083,1.274,6.656,0,12.514-5.661,12.514-14.15C67.8,13.579,54.371,0,33.9,0",
  viewBox: "0 0 67.798 71.712"
}, {
  label: "info",
  value: "M 24 3 C 12.413858 3 3 12.413866 3 24 C 3 35.586134 12.413858 45 24 45 C 35.586142 45 45 35.586134 45 24 C 45 12.413866 35.586142 3 24 3 z M 24 5 C 34.505263 5 43 13.494744 43 24 C 43 34.505256 34.505263 43 24 43 C 13.494737 43 5 34.505256 5 24 C 5 13.494744 13.494737 5 24 5 z M 24 12.185547 C 23.159 12.185547 22.474609 12.863313 22.474609 13.695312 C 22.474609 14.535312 23.159 15.220703 24 15.220703 C 24.85 15.220703 25.541016 14.535312 25.541016 13.695312 C 25.541016 12.863312 24.85 12.185547 24 12.185547 z M 24 17.935547 C 23.305 17.935547 22.818359 18.454312 22.818359 19.195312 L 22.818359 33.757812 C 22.818359 34.498812 23.304 35.017578 24 35.017578 C 24.696 35.017578 25.181641 34.498813 25.181641 33.757812 L 25.181641 19.193359 C 25.181641 18.452359 24.695 17.935547 24 17.935547 z",
  viewBox: "0 0 48 48"
}];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (svgOptionsV);

/***/ }),

/***/ "./src/blocks/artcloud-icon/style.scss":
/*!*********************************************!*\
  !*** ./src/blocks/artcloud-icon/style.scss ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "react":
/*!************************!*\
  !*** external "React" ***!
  \************************/
/***/ ((module) => {

module.exports = window["React"];

/***/ }),

/***/ "@wordpress/block-editor":
/*!*************************************!*\
  !*** external ["wp","blockEditor"] ***!
  \*************************************/
/***/ ((module) => {

module.exports = window["wp"]["blockEditor"];

/***/ }),

/***/ "@wordpress/blocks":
/*!********************************!*\
  !*** external ["wp","blocks"] ***!
  \********************************/
/***/ ((module) => {

module.exports = window["wp"]["blocks"];

/***/ }),

/***/ "@wordpress/components":
/*!************************************!*\
  !*** external ["wp","components"] ***!
  \************************************/
/***/ ((module) => {

module.exports = window["wp"]["components"];

/***/ }),

/***/ "@wordpress/data":
/*!******************************!*\
  !*** external ["wp","data"] ***!
  \******************************/
/***/ ((module) => {

module.exports = window["wp"]["data"];

/***/ }),

/***/ "@wordpress/element":
/*!*********************************!*\
  !*** external ["wp","element"] ***!
  \*********************************/
/***/ ((module) => {

module.exports = window["wp"]["element"];

/***/ }),

/***/ "@wordpress/i18n":
/*!******************************!*\
  !*** external ["wp","i18n"] ***!
  \******************************/
/***/ ((module) => {

module.exports = window["wp"]["i18n"];

/***/ }),

/***/ "./src/blocks/artcloud-icon/block.json":
/*!*********************************************!*\
  !*** ./src/blocks/artcloud-icon/block.json ***!
  \*********************************************/
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$schema":"https://raw.githubusercontent.com/WordPress/gutenberg/trunk/schemas/json/block.json","apiVersion":3,"name":"artcloud-blocks/artcloud-icon","version":"1.0.0","title":"Artcloud Icon","category":"artcloud-blocks","description":"SVG Block, upload require svg image","keywords":["card","box","product"],"supports":{"html":false,"align":["wide","full"]},"textdomain":"artcloud-blocks","editorScript":"file:./index.js","editorStyle":"file:./index.css","style":"file:./style-index.css","attributes":{"selectedSvg":{"type":"string","default":""},"selectedSvgViewBox":{"type":"string","default":"0 0 69.068 69.069"},"selectedSvgV":{"type":"string","default":"M1.246,3.719A1.658,1.658,0,0,0,0,5.324V42.257c0,16.7,4.43,21.835,30.793,31.684a2.906,2.906,0,0,0,2.034,0C59.189,64.092,63.62,58.959,63.62,42.257V5.359a1.659,1.659,0,0,0-1.287-1.614C41.117-1.169,20.73-1.319,1.246,3.719"},"selectedSvgA":{"type":"string","default":"m31.05,2.16l10.13,20.97c.08.17.17.33.28.49l13.09,19.26c1.8,2.64-.25,6.19-3.44,5.96l-23.22-1.71c-.19-.01-.37-.01-.56,0l-23.22,1.71c-3.19.23-5.24-3.32-3.44-5.96l13.09-19.26c.11-.15.2-.32.28-.49L24.17,2.16c1.39-2.88,5.49-2.88,6.88,0Z"},"textAlign":{"type":"string","default":"center"},"alignment":{"type":"string","default":"none"},"size":{"type":"number","default":50},"fillColor":{"type":"string","default":"var(--wp--preset--color--primary)"},"backgroundColor":{"type":"string","default":""},"svgOptions":{"type":"object","default":{}}}}');

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = __webpack_modules__;
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/chunk loaded */
/******/ 	(() => {
/******/ 		var deferred = [];
/******/ 		__webpack_require__.O = (result, chunkIds, fn, priority) => {
/******/ 			if(chunkIds) {
/******/ 				priority = priority || 0;
/******/ 				for(var i = deferred.length; i > 0 && deferred[i - 1][2] > priority; i--) deferred[i] = deferred[i - 1];
/******/ 				deferred[i] = [chunkIds, fn, priority];
/******/ 				return;
/******/ 			}
/******/ 			var notFulfilled = Infinity;
/******/ 			for (var i = 0; i < deferred.length; i++) {
/******/ 				var [chunkIds, fn, priority] = deferred[i];
/******/ 				var fulfilled = true;
/******/ 				for (var j = 0; j < chunkIds.length; j++) {
/******/ 					if ((priority & 1 === 0 || notFulfilled >= priority) && Object.keys(__webpack_require__.O).every((key) => (__webpack_require__.O[key](chunkIds[j])))) {
/******/ 						chunkIds.splice(j--, 1);
/******/ 					} else {
/******/ 						fulfilled = false;
/******/ 						if(priority < notFulfilled) notFulfilled = priority;
/******/ 					}
/******/ 				}
/******/ 				if(fulfilled) {
/******/ 					deferred.splice(i--, 1)
/******/ 					var r = fn();
/******/ 					if (r !== undefined) result = r;
/******/ 				}
/******/ 			}
/******/ 			return result;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/jsonp chunk loading */
/******/ 	(() => {
/******/ 		// no baseURI
/******/ 		
/******/ 		// object to store loaded and loading chunks
/******/ 		// undefined = chunk not loaded, null = chunk preloaded/prefetched
/******/ 		// [resolve, reject, Promise] = chunk loading, 0 = chunk loaded
/******/ 		var installedChunks = {
/******/ 			"blocks/artcloud-icon/index": 0,
/******/ 			"blocks/artcloud-icon/style-index": 0
/******/ 		};
/******/ 		
/******/ 		// no chunk on demand loading
/******/ 		
/******/ 		// no prefetching
/******/ 		
/******/ 		// no preloaded
/******/ 		
/******/ 		// no HMR
/******/ 		
/******/ 		// no HMR manifest
/******/ 		
/******/ 		__webpack_require__.O.j = (chunkId) => (installedChunks[chunkId] === 0);
/******/ 		
/******/ 		// install a JSONP callback for chunk loading
/******/ 		var webpackJsonpCallback = (parentChunkLoadingFunction, data) => {
/******/ 			var [chunkIds, moreModules, runtime] = data;
/******/ 			// add "moreModules" to the modules object,
/******/ 			// then flag all "chunkIds" as loaded and fire callback
/******/ 			var moduleId, chunkId, i = 0;
/******/ 			if(chunkIds.some((id) => (installedChunks[id] !== 0))) {
/******/ 				for(moduleId in moreModules) {
/******/ 					if(__webpack_require__.o(moreModules, moduleId)) {
/******/ 						__webpack_require__.m[moduleId] = moreModules[moduleId];
/******/ 					}
/******/ 				}
/******/ 				if(runtime) var result = runtime(__webpack_require__);
/******/ 			}
/******/ 			if(parentChunkLoadingFunction) parentChunkLoadingFunction(data);
/******/ 			for(;i < chunkIds.length; i++) {
/******/ 				chunkId = chunkIds[i];
/******/ 				if(__webpack_require__.o(installedChunks, chunkId) && installedChunks[chunkId]) {
/******/ 					installedChunks[chunkId][0]();
/******/ 				}
/******/ 				installedChunks[chunkId] = 0;
/******/ 			}
/******/ 			return __webpack_require__.O(result);
/******/ 		}
/******/ 		
/******/ 		var chunkLoadingGlobal = globalThis["webpackChunkartcloud_blocks"] = globalThis["webpackChunkartcloud_blocks"] || [];
/******/ 		chunkLoadingGlobal.forEach(webpackJsonpCallback.bind(null, 0));
/******/ 		chunkLoadingGlobal.push = webpackJsonpCallback.bind(null, chunkLoadingGlobal.push.bind(chunkLoadingGlobal));
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module depends on other loaded chunks and execution need to be delayed
/******/ 	var __webpack_exports__ = __webpack_require__.O(undefined, ["blocks/artcloud-icon/style-index"], () => (__webpack_require__("./src/blocks/artcloud-icon/index.js")))
/******/ 	__webpack_exports__ = __webpack_require__.O(__webpack_exports__);
/******/ 	
/******/ })()
;
//# sourceMappingURL=index.js.map