/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/blocks/artcloud-hero/edit.js":
/*!******************************************!*\
  !*** ./src/blocks/artcloud-hero/edit.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_5__);






const ALLOWED_BLOCKS = ['core/column', 'core/cover', 'core/columns', 'core/image', 'core/button', 'core/heading', 'core/paragraph', 'core/group'];
const blockColumns = [['core/cover', {
  className: 'artcloud_hero_cover',
  overlayColor: 'yellow-green'
}, [['core/columns', {
  className: 'artcloud_hero_column_main'
}, [['core/column', {
  className: 'artcloud_hero_column_content',
  verticalAlignment: 'center'
}, [['core/heading', {
  level: 2,
  className: 'artcloud_hero_heading',
  content: 'Tässä on lyhyt sisäänheitto otsikko!'
}], ['core/paragraph', {
  className: 'artcloud_hero_description',
  content: 'Tähän alle sitten pienempi otsikko ja sivuston kuvaus.'
}], ['core/columns', {
  className: 'artcloud_hero_columns_child'
}, [['core/column', {
  className: 'artcloud_hero_column_child',
  verticalAlignment: 'center'
}, [['core/buttons', {
  className: 'artcloud_hero_button',
  text: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Show', 'artcloud-blocks'),
  url: '#'
}, [['core/button', {
  className: 'artcloud_hero_button',
  text: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Show', 'artcloud-blocks'),
  url: '#'
}], ['core/button', {
  className: 'artcloud_hero_button',
  text: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Signup', 'artcloud-blocks'),
  url: '#'
}]]]]]]]]], ['core/column', {
  className: 'artcloud_hero_column_content'
}, [['core/image', {
  className: 'artcloud_hero_image',
  content: ''
}]]]]]]]];
const Edit = ({
  attributes,
  setAttributes
}) => {
  const {
    selectedSvg,
    selectedSvgV,
    selectedSvgA
  } = attributes;
  const [svgOptions, setSvgOptions] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)([]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
    fetch('/wp-json/artcloud/v1/svgs').then(response => response.json()).then(data => {
      setSvgOptions(data);
    }).catch(error => {
      console.error('Error fetching SVG data:', error);
    });
  }, []);
  const activeThemeName = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_5__.useSelect)(select => {
    return select('core').getCurrentTheme();
  }, []);
  const defaultSvg = activeThemeName && activeThemeName.name.rendered === 'Vihreat' ? selectedSvgV : selectedSvgA;
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
    if (!selectedSvg) {
      setAttributes({
        selectedSvg: defaultSvg
      });
    }
  }, [defaultSvg]);
  const handleSelectChange = newSvg => {
    setAttributes({
      selectedSvg: newSvg
    });
  };
  const getMaskImageUrl = selectedOption => {
    const selectedSvgOption = svgOptions.find(option => option.value === selectedOption);
    return selectedSvgOption ? `url("data:image/svg+xml,${encodeURIComponent(selectedSvgOption.value)}")` : '';
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    ...(0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.useBlockProps)()
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.InspectorControls, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelBody, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Background settings", "artcloud-blocks"),
    initialOpen: true
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.SelectControl, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Available options", "artcloud-blocks"),
    value: selectedSvg,
    options: svgOptions.map(option => ({
      label: option.label,
      value: option.value
    })),
    onChange: handleSelectChange
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("style", null, `.artcloud_hero_column_content .wp-block-image img {
                    mask-image: ${getMaskImageUrl(selectedSvg)} !important;
                    mask-position: center;
                    mask-repeat: no-repeat;
                    mask-size: 100% auto;
                    max-width: 100%;
                    height: 494px;
                    object-fit: cover;
                    text-align: center;
                    margin: 0 auto;
                    width: 29.7rem !important;
                }`), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.InnerBlocks, {
    template: blockColumns,
    allowedBlocks: ALLOWED_BLOCKS
  }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Edit);

/***/ }),

/***/ "./src/blocks/artcloud-hero/index.js":
/*!*******************************************!*\
  !*** ./src/blocks/artcloud-hero/index.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./style.scss */ "./src/blocks/artcloud-hero/style.scss");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _edit__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./edit */ "./src/blocks/artcloud-hero/edit.js");
/* harmony import */ var _save__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./save */ "./src/blocks/artcloud-hero/save.js");
/* harmony import */ var _block_json__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./block.json */ "./src/blocks/artcloud-hero/block.json");







const heroIcon = {
  src: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    id: "Layer_2",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 29.95 28.64"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("style", null, `.cls-1{fill:var(--wp--preset--color--white);stroke-width:0px;}`)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
    id: "Layer_1-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    className: "cls-1",
    d: "m4.79,11.39h6.07c.39,0,.71-.32.71-.71s-.32-.71-.71-.71h-6.07c-.39,0-.71.32-.71.71s.32.71.71.71Z"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    className: "cls-1",
    d: "m4.79,15.35h6.07c.39,0,.71-.32.71-.71s-.32-.71-.71-.71h-6.07c-.39,0-.71.32-.71.71s.32.71.71.71Z"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    className: "cls-1",
    d: "m4.79,19.23h1.31c.39,0,.71-.32.71-.71s-.32-.71-.71-.71h-1.31c-.39,0-.71.32-.71.71s.32.71.71.71Z"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    className: "cls-1",
    d: "m10.24,17.81h-1.31c-.39,0-.71.32-.71.71s.32.71.71.71h1.31c.39,0,.71-.32.71-.71s-.32-.71-.71-.71Z"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    className: "cls-1",
    d: "m29.24,0H0.71c-.39,0-.71.32-.71.71v27.22c0,.39.32.71.71.71h28.53c.39,0,.71-.32.71-.71V.71c0-.39-.32-.71-.71-.71Zm-.71,27.22H1.42V1.42h27.12v25.8Z"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    className: "cls-1",
    d: "m15.8,19.86h8.72c.39,0,.71-.32.71-.71v-8.63c0-.39-.32-.71-.71-.71h-8.72c-.39,0-.71.32-.71.71v8.63c0,.39.32.71.71.71Zm.71-8.63h7.3v7.21h-7.3v-7.21Z"
  }))),
  background: 'var(--wp--preset--color--primary)',
  foreground: 'var(--wp--preset--color--white)'
};
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)(_block_json__WEBPACK_IMPORTED_MODULE_6__.name, {
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('ArtCloud Vihreät Hero', 'artcloud-blocks'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Hero block for fetch image, title & description', 'artcloud-blocks'),
  icon: heroIcon,
  edit: _edit__WEBPACK_IMPORTED_MODULE_4__["default"],
  save: _save__WEBPACK_IMPORTED_MODULE_5__["default"]
});

/***/ }),

/***/ "./src/blocks/artcloud-hero/save.js":
/*!******************************************!*\
  !*** ./src/blocks/artcloud-hero/save.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__);


const Save = ({
  attributes
}) => {
  const {
    selectedSvg
  } = attributes;
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    ..._wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.useBlockProps.save({
      className: `card-text-align`
    })
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.InnerBlocks.Content, null), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("style", null, `
        .artcloud_hero_column_content .wp-block-image img {
            mask-image: url("data:image/svg+xml,${encodeURIComponent(selectedSvg)}") !important;
            mask-position: center;
            mask-repeat: no-repeat;
            mask-size: 100% auto;
            max-width: 100%;
            height: 494px;
            object-fit: cover;
            text-align: center;
            margin: 0 auto;
            width: 29.7rem !important;
          }
        `));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Save);

/***/ }),

/***/ "./src/blocks/artcloud-hero/style.scss":
/*!*********************************************!*\
  !*** ./src/blocks/artcloud-hero/style.scss ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "react":
/*!************************!*\
  !*** external "React" ***!
  \************************/
/***/ ((module) => {

module.exports = window["React"];

/***/ }),

/***/ "@wordpress/block-editor":
/*!*************************************!*\
  !*** external ["wp","blockEditor"] ***!
  \*************************************/
/***/ ((module) => {

module.exports = window["wp"]["blockEditor"];

/***/ }),

/***/ "@wordpress/blocks":
/*!********************************!*\
  !*** external ["wp","blocks"] ***!
  \********************************/
/***/ ((module) => {

module.exports = window["wp"]["blocks"];

/***/ }),

/***/ "@wordpress/components":
/*!************************************!*\
  !*** external ["wp","components"] ***!
  \************************************/
/***/ ((module) => {

module.exports = window["wp"]["components"];

/***/ }),

/***/ "@wordpress/data":
/*!******************************!*\
  !*** external ["wp","data"] ***!
  \******************************/
/***/ ((module) => {

module.exports = window["wp"]["data"];

/***/ }),

/***/ "@wordpress/element":
/*!*********************************!*\
  !*** external ["wp","element"] ***!
  \*********************************/
/***/ ((module) => {

module.exports = window["wp"]["element"];

/***/ }),

/***/ "@wordpress/i18n":
/*!******************************!*\
  !*** external ["wp","i18n"] ***!
  \******************************/
/***/ ((module) => {

module.exports = window["wp"]["i18n"];

/***/ }),

/***/ "./src/blocks/artcloud-hero/block.json":
/*!*********************************************!*\
  !*** ./src/blocks/artcloud-hero/block.json ***!
  \*********************************************/
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$schema":"https://raw.githubusercontent.com/WordPress/gutenberg/trunk/schemas/json/block.json","apiVersion":3,"name":"artcloud-blocks/artcloud-hero","version":"1.0.0","title":"ArtCloud Vihreät Hero","category":"artcloud-blocks","description":"Create a new hero block","keywords":["hero","box"],"supports":{"align":["wide","full"],"html":false},"textdomain":"artcloud-blocks","editorScript":"file:./index.js","editorStyle":"file:./index.css","style":"file:./style-index.css","attributes":{"title":{"type":"string"},"selectedSvg":{"type":"string","default":""},"selectedSvgV":{"type":"string","default":"<svg xmlns=\\"http://www.w3.org/2000/svg\\" xmlns:xlink=\\"http://www.w3.org/1999/xlink\\" width=\\"68.493\\" height=\\"71.854\\" viewBox=\\"0 0 68.493 71.854\\"><defs><clipPath id=\\"clip-path\\"><rect id=\\"Rectangle_661\\" data-name=\\"Rectangle 661\\" width=\\"68.493\\" height=\\"71.854\\" transform=\\"translate(0 0)\\" fill=\\"none\\"/></clipPath></defs><g id=\\"Group_767\\" data-name=\\"Group 767\\" transform=\\"translate(0 0)\\"><g id=\\"Group_766\\" data-name=\\"Group 766\\" clip-path=\\"url(#clip-path)\\"><path id=\\"Path_109\\" data-name=\\"Path 109\\" d=\\"M32.754,1.119v0a1.557,1.557,0,0,1,2.987,0v0A11.315,11.315,0,0,0,53.5,6.889l0,0a1.557,1.557,0,0,1,2.416,1.755v.005a11.316,11.316,0,0,0,10.975,15.1h0a1.557,1.557,0,0,1,.922,2.84h0a11.317,11.317,0,0,0,0,18.672h0a1.556,1.556,0,0,1-.922,2.839h0a11.317,11.317,0,0,0-10.975,15.1v0A1.557,1.557,0,0,1,53.5,64.966a11.316,11.316,0,0,0-17.758,5.767v0a1.557,1.557,0,0,1-2.987,0v0a11.317,11.317,0,0,0-17.759-5.769h0a1.556,1.556,0,0,1-2.415-1.755v0A11.318,11.318,0,0,0,1.6,48.1h0a1.556,1.556,0,0,1-.922-2.839h0a11.317,11.317,0,0,0,0-18.672h0a1.556,1.556,0,0,1,.922-2.84h0A11.317,11.317,0,0,0,12.58,8.647l0-.005a1.556,1.556,0,0,1,2.415-1.755l0,0a11.316,11.316,0,0,0,17.757-5.77\\" fill=\\"#009639\\"/></g></g></svg>"},"selectedSvgA":{"type":"string","default":"<svg id=\\"Layer_2\\" xmlns=\\"http://www.w3.org/2000/svg\\" viewBox=\\"0 0 57.65 57.65\\"><defs><style>.cls-1{stroke-width:0px;}</style></defs><g id=\\"Layer_1-2\\"><path class=\\"cls-1\\" d=\\"m32.47,2.76l1.59,5.68c.66,2.36,3.36,3.48,5.49,2.28l5.14-2.89c3.33-1.87,7.02,1.82,5.15,5.15l-2.89,5.14c-1.2,2.14-.08,4.83,2.28,5.49l5.68,1.59c3.68,1.03,3.68,6.25,0,7.28l-5.68,1.59c-2.36.66-3.48,3.36-2.28,5.49l2.89,5.14c1.87,3.33-1.82,7.02-5.15,5.15l-5.14-2.89c-2.14-1.2-4.83-.08-5.49,2.28l-1.59,5.68c-1.03,3.68-6.25,3.68-7.28,0l-1.59-5.68c-.66-2.36-3.36-3.48-5.49-2.28l-5.14,2.89c-3.33,1.87-7.02-1.82-5.15-5.15l2.89-5.14c1.2-2.14.08-4.83-2.28-5.49l-5.68-1.59c-3.68-1.03-3.68-6.25,0-7.28l5.68-1.59c2.36-.66,3.48-3.36,2.28-5.49l-2.89-5.14c-1.87-3.33,1.82-7.02,5.15-5.15l5.14,2.89c2.14,1.2,4.83.08,5.49-2.28l1.59-5.68c1.03-3.68,6.25-3.68,7.28,0Z\\" /></g></svg>"},"description":{"type":"string"},"alignment":{"type":"string","default":"left"},"backgroundColor":{"type":"string"},"textColor":{"type":"string"},"backgroundImage":{"type":"string","default":""}}}');

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = __webpack_modules__;
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/chunk loaded */
/******/ 	(() => {
/******/ 		var deferred = [];
/******/ 		__webpack_require__.O = (result, chunkIds, fn, priority) => {
/******/ 			if(chunkIds) {
/******/ 				priority = priority || 0;
/******/ 				for(var i = deferred.length; i > 0 && deferred[i - 1][2] > priority; i--) deferred[i] = deferred[i - 1];
/******/ 				deferred[i] = [chunkIds, fn, priority];
/******/ 				return;
/******/ 			}
/******/ 			var notFulfilled = Infinity;
/******/ 			for (var i = 0; i < deferred.length; i++) {
/******/ 				var [chunkIds, fn, priority] = deferred[i];
/******/ 				var fulfilled = true;
/******/ 				for (var j = 0; j < chunkIds.length; j++) {
/******/ 					if ((priority & 1 === 0 || notFulfilled >= priority) && Object.keys(__webpack_require__.O).every((key) => (__webpack_require__.O[key](chunkIds[j])))) {
/******/ 						chunkIds.splice(j--, 1);
/******/ 					} else {
/******/ 						fulfilled = false;
/******/ 						if(priority < notFulfilled) notFulfilled = priority;
/******/ 					}
/******/ 				}
/******/ 				if(fulfilled) {
/******/ 					deferred.splice(i--, 1)
/******/ 					var r = fn();
/******/ 					if (r !== undefined) result = r;
/******/ 				}
/******/ 			}
/******/ 			return result;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/jsonp chunk loading */
/******/ 	(() => {
/******/ 		// no baseURI
/******/ 		
/******/ 		// object to store loaded and loading chunks
/******/ 		// undefined = chunk not loaded, null = chunk preloaded/prefetched
/******/ 		// [resolve, reject, Promise] = chunk loading, 0 = chunk loaded
/******/ 		var installedChunks = {
/******/ 			"blocks/artcloud-hero/index": 0,
/******/ 			"blocks/artcloud-hero/style-index": 0
/******/ 		};
/******/ 		
/******/ 		// no chunk on demand loading
/******/ 		
/******/ 		// no prefetching
/******/ 		
/******/ 		// no preloaded
/******/ 		
/******/ 		// no HMR
/******/ 		
/******/ 		// no HMR manifest
/******/ 		
/******/ 		__webpack_require__.O.j = (chunkId) => (installedChunks[chunkId] === 0);
/******/ 		
/******/ 		// install a JSONP callback for chunk loading
/******/ 		var webpackJsonpCallback = (parentChunkLoadingFunction, data) => {
/******/ 			var [chunkIds, moreModules, runtime] = data;
/******/ 			// add "moreModules" to the modules object,
/******/ 			// then flag all "chunkIds" as loaded and fire callback
/******/ 			var moduleId, chunkId, i = 0;
/******/ 			if(chunkIds.some((id) => (installedChunks[id] !== 0))) {
/******/ 				for(moduleId in moreModules) {
/******/ 					if(__webpack_require__.o(moreModules, moduleId)) {
/******/ 						__webpack_require__.m[moduleId] = moreModules[moduleId];
/******/ 					}
/******/ 				}
/******/ 				if(runtime) var result = runtime(__webpack_require__);
/******/ 			}
/******/ 			if(parentChunkLoadingFunction) parentChunkLoadingFunction(data);
/******/ 			for(;i < chunkIds.length; i++) {
/******/ 				chunkId = chunkIds[i];
/******/ 				if(__webpack_require__.o(installedChunks, chunkId) && installedChunks[chunkId]) {
/******/ 					installedChunks[chunkId][0]();
/******/ 				}
/******/ 				installedChunks[chunkId] = 0;
/******/ 			}
/******/ 			return __webpack_require__.O(result);
/******/ 		}
/******/ 		
/******/ 		var chunkLoadingGlobal = globalThis["webpackChunkartcloud_blocks"] = globalThis["webpackChunkartcloud_blocks"] || [];
/******/ 		chunkLoadingGlobal.forEach(webpackJsonpCallback.bind(null, 0));
/******/ 		chunkLoadingGlobal.push = webpackJsonpCallback.bind(null, chunkLoadingGlobal.push.bind(chunkLoadingGlobal));
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module depends on other loaded chunks and execution need to be delayed
/******/ 	var __webpack_exports__ = __webpack_require__.O(undefined, ["blocks/artcloud-hero/style-index"], () => (__webpack_require__("./src/blocks/artcloud-hero/index.js")))
/******/ 	__webpack_exports__ = __webpack_require__.O(__webpack_exports__);
/******/ 	
/******/ })()
;
//# sourceMappingURL=index.js.map