/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/blocks/artcloud-feedback/edit.js":
/*!**********************************************!*\
  !*** ./src/blocks/artcloud-feedback/edit.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_5__);






// const ALLOWED_BLOCKS = ['core/column', 'core/cover', 'core/columns', 'core/image', 'core/button', 'core/heading', 'core/paragraph', 'core/group'];

const blockColumns = [['core/columns', {
  className: 'artcloud_fb_columns_main',
  opacity: 0,
  overlayColor: 'pale-cyan-blue'
}, [['core/column', {
  className: 'artcloud_fb_column'
}, [['core/heading', {
  lavel: 5,
  className: 'artcloud_fb_heading',
  content: 'Teema h3'
}], ['core/paragraph', {
  className: 'artcloud_fb_description',
  content: 'Excepteur sint occaecat cupidatat non proident, sunt in'
}]]]]]];
const Edit = ({
  attributes,
  setAttributes
}) => {
  const {
    svgSize,
    svgHeight,
    titlePosition,
    svgColor,
    selectedSvg,
    selectedSvgV,
    selectedSvgA
  } = attributes;
  const [svgOptions, setSvgOptions] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)([]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
    fetch('/wp-json/artcloud/v1/svgs').then(response => response.json()).then(data => {
      setSvgOptions(data);
    }).catch(error => {
      console.error('Error fetching SVG data:', error);
    });
  }, []);
  const activeThemeName = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_5__.useSelect)(select => {
    return select('core').getCurrentTheme();
  }, []);
  const defaultSvg = activeThemeName && activeThemeName.name.rendered === 'Vihreat' ? selectedSvgV : selectedSvgA;
  if (!selectedSvg) {
    setAttributes({
      selectedSvg: defaultSvg
    });
  }
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
    setAttributes({
      selectedSvg: defaultSvg
    });
  }, [defaultSvg]);
  const handleSelectChange = newSvg => {
    setAttributes({
      selectedSvg: newSvg
    });
  };
  const getMaskImageUrl = selectedOption => {
    const selectedSvgOption = svgOptions.find(option => option.value === selectedOption);
    return selectedSvgOption ? `url("data:image/svg+xml,${encodeURIComponent(selectedSvgOption.value)}")` : `url("data:image/svg+xml,${encodeURIComponent(defaultSvg)}")`;
  };
  const onChangeSVGColor = newColor => {
    setAttributes({
      svgColor: newColor
    });
  };
  const onChangeSVGSize = newSize => {
    setAttributes({
      svgSize: newSize
    });
  };
  const onChangeSVGHeight = newHeight => {
    setAttributes({
      svgHeight: newHeight
    });
  };
  const onChangeTitlePosition = newPosition => {
    setAttributes({
      titlePosition: newPosition
    });
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    ...(0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.useBlockProps)()
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.InspectorControls, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelBody, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Background settings", "artcloud-blocks"),
    initialOpen: true
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.SelectControl, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Available options", "artcloud-blocks"),
    value: selectedSvg,
    options: svgOptions.map(option => ({
      label: option.label,
      value: option.value
    })),
    onChange: handleSelectChange
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.RangeControl, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("SVG Size", "artcloud-blocks"),
    value: svgSize,
    onChange: onChangeSVGSize,
    min: 10,
    max: 45
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.RangeControl, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("SVG Height", "artcloud-blocks"),
    value: svgHeight,
    onChange: onChangeSVGHeight,
    min: 10,
    max: 45
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.RangeControl, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Title Position", "artcloud-blocks"),
    value: titlePosition,
    onChange: onChangeTitlePosition,
    min: 1,
    max: 45
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.PanelColorSettings, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Color Settings", "artcloud-blocks"),
    icon: "admin-appearance",
    initialOpen: true,
    colorSettings: [{
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("SVG Color", "artcloud-blocks"),
      value: svgColor,
      onChange: onChangeSVGColor
    }]
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("style", null, ` .wp-block-column.artcloud_fb_column {
                mask-image: ${getMaskImageUrl(selectedSvg)} !important;
                mask-position: center;
				background-color: ${svgColor};
				mask-repeat: no-repeat;
				mask-size: ${svgSize}rem;
				height:${svgSize + 5 > svgHeight ? svgSize + 5 : svgHeight}rem;
				max-width: ${svgSize}rem;
            }`), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("style", null, ` .artcloud_fb_heading{
					top: ${titlePosition}rem;
				}`), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("style", null, ` .artcloud_fb_description{
					top: ${titlePosition + 1}rem;
				}
				`), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.InnerBlocks, {
    template: blockColumns
  }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Edit);

/***/ }),

/***/ "./src/blocks/artcloud-feedback/index.js":
/*!***********************************************!*\
  !*** ./src/blocks/artcloud-feedback/index.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./style.scss */ "./src/blocks/artcloud-feedback/style.scss");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _edit__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./edit */ "./src/blocks/artcloud-feedback/edit.js");
/* harmony import */ var _save__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./save */ "./src/blocks/artcloud-feedback/save.js");
/* harmony import */ var _block_json__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./block.json */ "./src/blocks/artcloud-feedback/block.json");




/**
 * Internal dependencies
 */



const iconComments = {
  src: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    id: "Layer_2",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 29.35 29.68"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("style", null, `.cls-1{fill:var(--wp--preset--color--white);stroke-width:0px;}`)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
    id: "Layer_1-2"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    className: "cls-1",
    d: "m7.6,8.92h14.5c.39,0,.71-.32.71-.71s-.32-.71-.71-.71H7.6c-.39,0-.71.32-.71.71s.32.71.71.71Z"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    className: "cls-1",
    d: "m7.6,13.34h14.5c.39,0,.71-.32.71-.71s-.32-.71-.71-.71H7.6c-.39,0-.71.32-.71.71s.32.71.71.71Z"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    className: "cls-1",
    d: "m7.6,17.56h14.5c.39,0,.71-.32.71-.71s-.32-.71-.71-.71H7.6c-.39,0-.71.32-.71.71s.32.71.71.71Z"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    className: "cls-1",
    d: "m28.64,0H0.71c-.39,0-.71.32-.71.71v23.96c0,.39.32.71.71.71h19.25l4.09,4.09c.14.14.32.21.5.21.09,0,.18-.02.27-.05.27-.11.44-.37.44-.65v-3.59h3.39c.39,0,.71-.32.71-.71V0.71c0-.39-.32-.71-.71-.71Zm-.71,23.96h-3.39c-.39,0-.71.32-.71.71,0,.01,0,.03,0,.04,0,.01,0,.03,0,.04v2.5l-3.03-3.03c-.09-.09-.2-.14-.32-.17-.1-.05-.21-.09-.33-.09H1.42V1.42h26.52v22.55Z"
  }))),
  background: 'var(--wp--preset--color--primary)',
  foreground: 'var(--wp--preset--color--white)'
};
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)(_block_json__WEBPACK_IMPORTED_MODULE_6__.name, {
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Artcloud Feedback Block', 'artcloud-blocks'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Display feedback or quotes', 'artcloud-blocks'),
  icon: iconComments,
  edit: _edit__WEBPACK_IMPORTED_MODULE_4__["default"],
  save: _save__WEBPACK_IMPORTED_MODULE_5__["default"]
});

/***/ }),

/***/ "./src/blocks/artcloud-feedback/save.js":
/*!**********************************************!*\
  !*** ./src/blocks/artcloud-feedback/save.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__);


const Save = ({
  attributes
}) => {
  const {
    titlePosition,
    selectedSvg,
    svgColor,
    svgSize,
    svgHeight
  } = attributes;
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    ..._wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.useBlockProps.save({
      className: `feedback-text-align`
    })
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("style", null, ` .wp-block-column.artcloud_fb_column {
					mask-image: url("data:image/svg+xml,${encodeURIComponent(selectedSvg)}") !important;
					mask-position: center;
					background-color: ${svgColor};
					mask-repeat: no-repeat;
					mask-size: ${svgSize}rem;
					height:${svgSize + 5 > svgHeight ? svgSize + 5 : svgHeight}rem;
					max-width: ${svgSize}rem;
                }`), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("style", null, ` .artcloud_fb_heading{
					top: ${titlePosition}rem;
				}`), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("style", null, ` .artcloud_fb_description{
					top: ${titlePosition + 1}rem;
				}
				`), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.InnerBlocks.Content, null));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Save);

/***/ }),

/***/ "./src/blocks/artcloud-feedback/style.scss":
/*!*************************************************!*\
  !*** ./src/blocks/artcloud-feedback/style.scss ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "react":
/*!************************!*\
  !*** external "React" ***!
  \************************/
/***/ ((module) => {

module.exports = window["React"];

/***/ }),

/***/ "@wordpress/block-editor":
/*!*************************************!*\
  !*** external ["wp","blockEditor"] ***!
  \*************************************/
/***/ ((module) => {

module.exports = window["wp"]["blockEditor"];

/***/ }),

/***/ "@wordpress/blocks":
/*!********************************!*\
  !*** external ["wp","blocks"] ***!
  \********************************/
/***/ ((module) => {

module.exports = window["wp"]["blocks"];

/***/ }),

/***/ "@wordpress/components":
/*!************************************!*\
  !*** external ["wp","components"] ***!
  \************************************/
/***/ ((module) => {

module.exports = window["wp"]["components"];

/***/ }),

/***/ "@wordpress/data":
/*!******************************!*\
  !*** external ["wp","data"] ***!
  \******************************/
/***/ ((module) => {

module.exports = window["wp"]["data"];

/***/ }),

/***/ "@wordpress/element":
/*!*********************************!*\
  !*** external ["wp","element"] ***!
  \*********************************/
/***/ ((module) => {

module.exports = window["wp"]["element"];

/***/ }),

/***/ "@wordpress/i18n":
/*!******************************!*\
  !*** external ["wp","i18n"] ***!
  \******************************/
/***/ ((module) => {

module.exports = window["wp"]["i18n"];

/***/ }),

/***/ "./src/blocks/artcloud-feedback/block.json":
/*!*************************************************!*\
  !*** ./src/blocks/artcloud-feedback/block.json ***!
  \*************************************************/
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$schema":"https://raw.githubusercontent.com/WordPress/gutenberg/trunk/schemas/json/block.json","apiVersion":3,"name":"artcloud-blocks/artcloud-feedback","version":"1.0.0","title":"Artcloud Feedback Block","category":"artcloud-blocks","description":"Create a new tile with title description & button","keywords":["card","box"],"supports":{"align":["wide","full"],"html":false},"textdomain":"artcloud-blocks","editorScript":"file:./index.js","editorStyle":"file:./index.css","style":"file:./style-index.css","attributes":{"svgSize":{"type":"number","default":20},"svgHeight":{"type":"number","default":25},"titlePosition":{"type":"number","default":8},"svgColor":{"type":"string","default":"var(--wp--preset--color--primary)"},"selectedSvg":{"type":"string","default":""},"selectedSvgV":{"type":"string","default":"<svg xmlns=\\"http://www.w3.org/2000/svg\\" viewBox=\\"0 0 83.74 59.496\\"><path d=\\"M61.342,47.757c12.667-3.685,22.4-9.185,22.4-20.5C83.74,7.779,62.458,0,41.87,0S0,7.779,0,27.257C0,40.29,9.771,48.047,22,52.512c10.4,3.8,28.149,6.543,45.822,6.984a.974.974,0,0,0,.376-1.9c-9.235-1.976-12.308-3.458-12.308-5.971,0-2.1,1.942-2.828,5.52-3.864Z\\"/></svg>"},"selectedSvgA":{"type":"string","default":"<svg id=\\"Layer_2\\" xmlns=\\"http://www.w3.org/2000/svg\\" viewBox=\\"0 0 59.97 52.19\\"><defs><style>.cls-1{stroke-width:0px;}</style></defs><g id=\\"Layer_1-2\\"><path class=\\"cls-1\\" d=\\"m51.35,0H8.62C3.88,0,0,3.88,0,8.62v27.06c0,4.74,3.88,8.62,8.62,8.62h28.89l9.84,7.75c.44.35,1.09.03,1.09-.53v-7.22h2.92c4.74,0,8.62-3.88,8.62-8.62V8.62c0-4.74-3.88-8.62-8.62-8.62Z\\"/></g></svg>"},"title":{"type":"string"},"description":{"type":"string"},"alignment":{"type":"string","default":"left"},"backgroundColor":{"type":"string"},"textColor":{"type":"string"},"backgroundImage":{"type":"string","default":""}}}');

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = __webpack_modules__;
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/chunk loaded */
/******/ 	(() => {
/******/ 		var deferred = [];
/******/ 		__webpack_require__.O = (result, chunkIds, fn, priority) => {
/******/ 			if(chunkIds) {
/******/ 				priority = priority || 0;
/******/ 				for(var i = deferred.length; i > 0 && deferred[i - 1][2] > priority; i--) deferred[i] = deferred[i - 1];
/******/ 				deferred[i] = [chunkIds, fn, priority];
/******/ 				return;
/******/ 			}
/******/ 			var notFulfilled = Infinity;
/******/ 			for (var i = 0; i < deferred.length; i++) {
/******/ 				var [chunkIds, fn, priority] = deferred[i];
/******/ 				var fulfilled = true;
/******/ 				for (var j = 0; j < chunkIds.length; j++) {
/******/ 					if ((priority & 1 === 0 || notFulfilled >= priority) && Object.keys(__webpack_require__.O).every((key) => (__webpack_require__.O[key](chunkIds[j])))) {
/******/ 						chunkIds.splice(j--, 1);
/******/ 					} else {
/******/ 						fulfilled = false;
/******/ 						if(priority < notFulfilled) notFulfilled = priority;
/******/ 					}
/******/ 				}
/******/ 				if(fulfilled) {
/******/ 					deferred.splice(i--, 1)
/******/ 					var r = fn();
/******/ 					if (r !== undefined) result = r;
/******/ 				}
/******/ 			}
/******/ 			return result;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/jsonp chunk loading */
/******/ 	(() => {
/******/ 		// no baseURI
/******/ 		
/******/ 		// object to store loaded and loading chunks
/******/ 		// undefined = chunk not loaded, null = chunk preloaded/prefetched
/******/ 		// [resolve, reject, Promise] = chunk loading, 0 = chunk loaded
/******/ 		var installedChunks = {
/******/ 			"blocks/artcloud-feedback/index": 0,
/******/ 			"blocks/artcloud-feedback/style-index": 0
/******/ 		};
/******/ 		
/******/ 		// no chunk on demand loading
/******/ 		
/******/ 		// no prefetching
/******/ 		
/******/ 		// no preloaded
/******/ 		
/******/ 		// no HMR
/******/ 		
/******/ 		// no HMR manifest
/******/ 		
/******/ 		__webpack_require__.O.j = (chunkId) => (installedChunks[chunkId] === 0);
/******/ 		
/******/ 		// install a JSONP callback for chunk loading
/******/ 		var webpackJsonpCallback = (parentChunkLoadingFunction, data) => {
/******/ 			var [chunkIds, moreModules, runtime] = data;
/******/ 			// add "moreModules" to the modules object,
/******/ 			// then flag all "chunkIds" as loaded and fire callback
/******/ 			var moduleId, chunkId, i = 0;
/******/ 			if(chunkIds.some((id) => (installedChunks[id] !== 0))) {
/******/ 				for(moduleId in moreModules) {
/******/ 					if(__webpack_require__.o(moreModules, moduleId)) {
/******/ 						__webpack_require__.m[moduleId] = moreModules[moduleId];
/******/ 					}
/******/ 				}
/******/ 				if(runtime) var result = runtime(__webpack_require__);
/******/ 			}
/******/ 			if(parentChunkLoadingFunction) parentChunkLoadingFunction(data);
/******/ 			for(;i < chunkIds.length; i++) {
/******/ 				chunkId = chunkIds[i];
/******/ 				if(__webpack_require__.o(installedChunks, chunkId) && installedChunks[chunkId]) {
/******/ 					installedChunks[chunkId][0]();
/******/ 				}
/******/ 				installedChunks[chunkId] = 0;
/******/ 			}
/******/ 			return __webpack_require__.O(result);
/******/ 		}
/******/ 		
/******/ 		var chunkLoadingGlobal = globalThis["webpackChunkartcloud_blocks"] = globalThis["webpackChunkartcloud_blocks"] || [];
/******/ 		chunkLoadingGlobal.forEach(webpackJsonpCallback.bind(null, 0));
/******/ 		chunkLoadingGlobal.push = webpackJsonpCallback.bind(null, chunkLoadingGlobal.push.bind(chunkLoadingGlobal));
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module depends on other loaded chunks and execution need to be delayed
/******/ 	var __webpack_exports__ = __webpack_require__.O(undefined, ["blocks/artcloud-feedback/style-index"], () => (__webpack_require__("./src/blocks/artcloud-feedback/index.js")))
/******/ 	__webpack_exports__ = __webpack_require__.O(__webpack_exports__);
/******/ 	
/******/ })()
;
//# sourceMappingURL=index.js.map