<?php

/**
 * Plugin Name:       	Artcloud Blocks
 * Plugin URI: 			#
 * Description:       	Multiple Gutenberg Blocks to make your website more interactive.
 * Requires at least: 	6.1
 * Requires PHP:      	7.0
 * Version:           	1.5.7
 * Author:            	ArtCloud
 * Author URI:			#
 * License:           	GPL-2.0-or-later
 * License URI:       	https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       	artcloud-blocks
 *
 * @package           create-block
 */

if (!defined('ABSPATH')) {
	exit;
}
function create_artcloud_blocks_block_init()
{

	wp_register_script(
		'artcloud-blocks-script',
		plugins_url('build/blocks/artcloud-alert/index.js', __FILE__),
		array('wp-blocks', 'react', 'wp-i18n', 'wp-block-editor')
	);

	register_block_type(__DIR__ . '/build/blocks/artcloud-accordion');
	register_block_type(__DIR__ . '/build/blocks/artcloud-accordion-item');
	register_block_type(__DIR__ . '/build/blocks/artcloud-accordion-base');
	register_block_type(__DIR__ . '/build/blocks/artcloud-phase');
	register_block_type(__DIR__ . '/build/blocks/artcloud-phase-item');
	register_block_type(__DIR__ . '/build/blocks/artcloud-phase-base');
	register_block_type(__DIR__ . '/build/blocks/artcloud-alert');
	register_block_type(__DIR__ . '/build/blocks/my-post-block');
	register_block_type(__DIR__ . '/build/blocks/artcloud-card');
	register_block_type(__DIR__ . '/build/blocks/artcloud-feedback');
	register_block_type(__DIR__ . '/build/blocks/artcloud-hero');
	register_block_type(__DIR__ . '/build/blocks/artcloud-icon');
	register_block_type(__DIR__ . '/build/blocks/artcloud-posts', array(
		'render_callback' => 'artcloud_posts_render',
	));
	register_block_type(__DIR__ . '/build/blocks/artcloud-authors', array(
		'render_callback' => 'artcloud_authors_render'
	));
	register_block_type(__DIR__ . '/build/blocks/artcloud-shortcode', array(
		'render_callback' => 'render_shortcode'
	));
	register_block_type(__DIR__ . '/build/blocks/artcloud-highlight', array(
		'render_callback' => 'artcloud_highlight_blocks_render'
	));
	register_block_type(__DIR__ . '/build/blocks/artcloud-rss-feed', array(
		'render_callback' => 'artcloud_rss_feed_render'
	));
	//this block move to theme
	// register_block_type(__DIR__ . '/build/blocks/artcloud-menu');

	// register_block_type(__DIR__ . '/build/blocks/artcloud-accordion-old');
	// register_block_type(__DIR__ . '/build/blocks/artcloud-phase-old');
	// register_block_type(__DIR__ . '/build/blocks/artcloud-highlight-post');
	// register_block_type(__DIR__ . '/build/blocks/artcloud-peoples', array(
	// 	'render_callback' => 'artcloud_peoples_render'
	// ));


	// Set script translations for the main script
	wp_set_script_translations('artcloud-blocks-editor-script', 'artcloud-blocks', plugin_dir_path(__FILE__) . 'languages');
}
add_action('init', 'create_artcloud_blocks_block_init');

function artcloud_blocks_load_translations($mofile, $domain)
{
	if ('artcloud-blocks' === $domain && false !== strpos($mofile, WP_LANG_DIR . '/plugins/')) {
		$locale = apply_filters('plugin_locale', determine_locale(), $domain);
		$mofile = WP_PLUGIN_DIR . '/' . dirname(plugin_basename(__FILE__)) . '/languages/' . $domain . '-' . $locale . '.mo';
	}
	return $mofile;
}
add_filter('load_textdomain_mofile', 'artcloud_blocks_load_translations', 10, 2);

//Render call back Function
require_once plugin_dir_path(__FILE__) . 'src/blocks/artcloud-shortcode/render_shortcode.php';
require_once plugin_dir_path(__FILE__) . 'src/blocks/artcloud-authors/artcloud-authors-render.php';
require_once plugin_dir_path(__FILE__) . 'src/blocks/artcloud-posts/artcloud-posts-render.php';
require_once plugin_dir_path(__FILE__) . 'src/blocks/artcloud-highlight/artcloud-highlight.php';
// require_once plugin_dir_path(__FILE__) . 'src/blocks/artcloud-peoples/artcloud-peoples-render.php';
require_once plugin_dir_path(__FILE__) . 'src/blocks/artcloud-rss-feed/artcloud-rss-feed-render.php';

//Artcloud Blocks register category
if (!function_exists('artcloud_block_category')) {
	function artcloud_block_category($categories)
	{
		$artcloud_block = array(
			'slug'  => 'artcloud-blocks',
			'title' => __('Artcloud Blocks', 'artcloud-blocks'),
		);

		$categories_sorted = array();
		$categories_sorted[0] = $artcloud_block;

		foreach ($categories as $category) {
			$categories_sorted[] = $category;
		}

		return $categories_sorted;
	}
	add_filter('block_categories', 'artcloud_block_category', 10, 2);
}

// Add a custom field to the REST API response for posts
function artcloud_add_rest_api_fields()
{
	register_rest_field(
		'event',
		'thumbnail_url',
		array(
			'get_callback' => 'get_thumbnail_url',
			'update_callback' => null,
			'schema' => null,
		)
	);
}
function get_thumbnail_url($object)
{
	$thumbnail_id = get_post_thumbnail_id($object['id']);
	$thumbnail = wp_get_attachment_image_src($thumbnail_id, 'full');

	return isset($thumbnail[0]) ? $thumbnail[0] : null;
}

register_rest_field('post', 'featuredImage', array(
	'get_callback' => function () {
		return get_the_post_thumbnail('', 'medium');
	},
));
register_rest_field('post', 'authorName', array(
	'get_callback' => function () {
		return get_the_author();
	},
));
add_action('rest_api_init', 'artcloud_add_rest_api_fields');
//svg Support hook
function artcloud_svg_mime_type($mimes = array())
{
	$mimes['svg']  = 'image/svg+xml';
	$mimes['svgz'] = 'image/svg+xml';
	return $mimes;
}
add_filter('upload_mimes', 'artcloud_svg_mime_type');

function artcloud_enqueue_script_frontend()
{
	wp_enqueue_style(
		'artcloud-block-css',
		plugin_dir_url(__FILE__) . '/assets/css/artcloud_block.css',
		array(),
		'1.0',
		'all'
	);
	wp_enqueue_script(
		'artcloud-accordion-js',
		plugin_dir_url(__FILE__) . '/src/blocks/artcloud-accordion/assets/artcloud-accordion.js',
		array('jquery'),
		'1.0',
		'all'
	);
	wp_enqueue_script(
		'hideAlertBlock',
		plugin_dir_url(__FILE__) . '/src/blocks/artcloud-alert/hideAlertBlock.js',
		array('jquery'),
		'1.0',
		true
	);
	wp_enqueue_script(
		'loadmore-posts-script',
		plugin_dir_url(__FILE__) . '/src/blocks/artcloud-posts/loadmore-posts-script.js',
		array('jquery'),
		'1.0',
		true
	);
	// wp_enqueue_script(
	// 	'filter-people-script',
	// 	plugin_dir_url(__FILE__) . '/src/blocks/artcloud-peoples/artcloud-people-filter.js',
	// 	array('jquery'),
	// 	'1.0',
	// 	true
	// );
	wp_enqueue_script(
		'loadmore-rss-feed-script',
		plugin_dir_url(__FILE__) . '/src/blocks/artcloud-rss-feed/load-more-ajax-call.js',
		array('jquery'),
		'1.0',
		true
	);
	wp_enqueue_script(
		'artcloud-seperate-accordion-js',
		plugin_dir_url(__FILE__) . '/assets/lib/js/separate-accordion.js',
		array(),
		'1.0',
		true
	);
	wp_enqueue_script(
		'artcloud-group-accordion-js',
		plugin_dir_url(__FILE__) . '/assets/lib/js/group-accordion.js',
		array(),
		'1.0',
		true
	);
	wp_localize_script('loadmore-posts-script', 'artcloudAjax', array(
		'ajaxurl' => admin_url('admin-ajax.php'),
	));
}
add_action('wp_enqueue_scripts', 'artcloud_enqueue_script_frontend');

function artcloud_enqueue_script_backend()
{
	if (is_admin()) {
		wp_enqueue_style(
			'add-delete-persons-category',
			plugin_dir_url(__FILE__) . '/src/blocks/artcloud-peoples/peoplesAddRemove.css',
			array(),
			'1.0',
			'all'
		);
		wp_enqueue_script(
			'artcloud-seperate-accordion-js',
			plugin_dir_url(__FILE__) . '/assets/lib/js/separate-accordion.js',
			array(),
			'1.0',
			true
		);
		wp_enqueue_script(
			'artcloud-group-accordion-js',
			plugin_dir_url(__FILE__) . '/assets/lib/js/group-accordion.js',
			array(),
			'1.0',
			true
		);
	}
}
add_action('admin_enqueue_scripts', 'artcloud_enqueue_script_backend');

// Add artcloud image size for post thumbnails
function artcloud_post_thumbnail_size()
{
	add_image_size('full', 1200, 320, true);
	add_image_size('medium', 658, 401, true);
	add_image_size('small', 380, 205, true);
}
add_action('after_setup_theme', 'artcloud_post_thumbnail_size');

//copy .po file from plugins to content language folder
function artcloud_blocks_copy_language_files($plugin_slug, $pot_file, $po_file, $mo_file)
{
	$source_dir = WP_PLUGIN_DIR . '/' . $plugin_slug . '/languages/';
	$destination_dir = WP_CONTENT_DIR . '/languages/plugins/';
	$source_pot_file = $source_dir . $pot_file;
	$source_po_file = $source_dir . $po_file;
	$source_mo_file = $source_dir . $mo_file;
	$destination_pot_file = $destination_dir . $pot_file;
	$destination_po_file = $destination_dir . $po_file;
	$destination_mo_file = $destination_dir . $mo_file;

	if (!file_exists($source_pot_file) && !file_exists($source_po_file) && !file_exists($source_mo_file) || !wp_mkdir_p($destination_dir)) {
		return;
	}
	if (file_exists($destination_po_file) && file_exists($destination_po_file) && file_exists($destination_mo_file)) {
		return;
	}
	if (!@copy($source_pot_file, $destination_pot_file)) {
		return;
	}
	if (!@copy($source_po_file, $destination_po_file)) {
		return;
	}
	if (!@copy($source_mo_file, $destination_mo_file)) {
		return;
	}
}
artcloud_blocks_copy_language_files('artcloud-blocks', 'artcloud-blocks.pot', 'artcloud-blocks-fi.po', 'artcloud-blocks-fi.mo');
